/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.model.profiling.RunningProcessDescription;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class RunningProcessesData
implements Serializable,
XSerializable {
    private static final long serialVersionUID = -5129173039285372572L;
    private final Map<String, RunningProcessDescription> processes = new HashMap<String, RunningProcessDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTask(RunningProcessDescription task) {
        if (task == null) {
            return;
        }
        Map<String, RunningProcessDescription> map = this.processes;
        synchronized (map) {
            this.processes.put(task.getUid(), task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(String taskUid) {
        if (taskUid == null) {
            return;
        }
        Map<String, RunningProcessDescription> map = this.processes;
        synchronized (map) {
            this.processes.remove(taskUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RunningProcessDescription> getAllTasks() {
        Map<String, RunningProcessDescription> map = this.processes;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.processes.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskProgress(String taskUid, byte progress) {
        Map<String, RunningProcessDescription> map = this.processes;
        synchronized (map) {
            RunningProcessDescription task = this.processes.get(taskUid);
            if (task != null) {
                task.setProgress(progress);
            }
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        for (Map.Entry<String, RunningProcessDescription> entry : this.processes.entrySet()) {
            XHelper.writeObject(elm, "processes/item", entry.getValue()).setAttribute("itemId", entry.getKey());
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        for (Element itemElm : XmlUtil.getElements(elm, "processes/item")) {
            RunningProcessDescription item = (RunningProcessDescription)XHelper.readObject(itemElm, ".");
            if (item == null) continue;
            this.processes.put(itemElm.getAttribute("itemId"), item);
        }
    }
}

