/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.util;

import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class XSModelUtil {
    public static boolean entityEquals(BaseEntity be1, BaseEntity be2, Map<String, String> uidContext) {
        if (!be1.getClass().equals(be2.getClass())) {
            return false;
        }
        if (uidContext.containsKey(be1.getUid())) {
            if (uidContext.get(be1.getUid()) == null) {
                return be2.getUid() == null;
            }
            return uidContext.get(be1.getUid()).equals(be2.getUid());
        }
        uidContext.put(be1.getUid(), be2.getUid());
        EntityType et = MetaRegistryHelper.getEntityType(be1.getClass().getName());
        for (Property p : MetaRegistryHelper.getAllProperties(et).values()) {
            Object actualValue;
            Object expectedValue = be1.getValue(p.getId());
            if (XSModelUtil.valueEquals(expectedValue, actualValue = be2.getValue(p.getId()), uidContext)) continue;
            return false;
        }
        for (EntityCollection ec : MetaRegistryHelper.getAllCollections(et).values()) {
            Object v1 = be1.getValue(ec.getId());
            Object v2 = be2.getValue(ec.getId());
            if (v1 instanceof List) {
                if (!(v2 instanceof List)) {
                    return false;
                }
                List list1 = (List)v1;
                List list2 = (List)v2;
                if (ec.getUnitTestParameters() != null && !ec.getUnitTestParameters().isOrdered() && !ec.getUnitTestParameters().getDesignators().isEmpty()) {
                    Collections.sort(list1, (a, b) -> MiscUtil.compare(XSModelUtil.buildSortKey(a, ec.getUnitTestParameters().getDesignators()), XSModelUtil.buildSortKey(b, ec.getUnitTestParameters().getDesignators())));
                    Collections.sort(list2, (a, b) -> MiscUtil.compare(XSModelUtil.buildSortKey(a, ec.getUnitTestParameters().getDesignators()), XSModelUtil.buildSortKey(b, ec.getUnitTestParameters().getDesignators())));
                }
                if (list1.size() != list2.size()) {
                    return false;
                }
                for (int i = 0; i < list1.size(); ++i) {
                    Object list2Val;
                    Object list1Val = list1.get(i);
                    boolean result = XSModelUtil.valueEquals(list1Val, list2Val = list2.get(i), uidContext);
                    if (result) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static String buildSortKey(Object obj, List<String> designators) {
        Introspectable in = (Introspectable)obj;
        StringBuilder sb = new StringBuilder();
        for (String designator : designators) {
            Object value;
            if (sb.length() > 0) {
                sb.append("|");
            }
            if ((value = in.getValue(designator)) instanceof DictionaryReference) {
                sb.append(((DictionaryReference)value).getCode());
                continue;
            }
            if (value instanceof EntityReference) {
                sb.append(((EntityReference)value).getUid());
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private static boolean valueEquals(Object v1, Object v2, Map<String, String> uidContext) {
        if (v1 == null) {
            if (v2 != null && (v2 instanceof Collection ? ((Collection)v2).isEmpty() : v2 instanceof Map && ((Map)v2).isEmpty())) {
                return true;
            }
            return v2 == null;
        }
        if (v2 == null) {
            return v1 instanceof Collection ? ((Collection)v1).isEmpty() : v1 instanceof Map && ((Map)v1).isEmpty();
        }
        if (!v1.getClass().equals(v2.getClass())) {
            return false;
        }
        boolean result = false;
        if (v1 instanceof BaseEntity) {
            result = XSModelUtil.entityEquals((BaseEntity)v1, (BaseEntity)v2, uidContext);
        } else if (v1 instanceof BigDecimal) {
            if (((BigDecimal)v1).compareTo((BigDecimal)v2) != 0) {
                result = false;
            }
        } else {
            try {
                result = v1.equals(v2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return result;
    }
}

