/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.validation;

import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ValidationHelper {
    public static void addValidationMessages(Validatable object, Element elm) {
    }

    public static boolean isValid(Collection<? extends Validatable> objects) {
        for (Validatable validatable : objects) {
            if (ValidationHelper.isValid(validatable)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Validatable object) {
        EntityTypeWrapper etw = EntityTypeWrapper.get(object.getClass().getName());
        for (EntityTypeWrapper.PropertyWrapper prop : etw.getProperties()) {
            Validatable child;
            EntityTypeWrapper childEt;
            if (etw.isValidatable() && !object.getValidationContext().getValidationMessages(prop.getId()).isEmpty()) {
                return false;
            }
            Object propValue = object.getValue(prop.getId());
            if (propValue == null || (childEt = EntityTypeWrapper.get(propValue.getClass().getName())) == null || !childEt.isValidatable() || ValidationHelper.isValid(child = (Validatable)propValue)) continue;
            return false;
        }
        for (EntityTypeWrapper.CollectionWrapper coll : etw.getCollections()) {
            EntityTypeWrapper elementEt = EntityTypeWrapper.get(coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) {
                if (!etw.isValidatable() || !ValidationHelper.isCollectionHasValidationMessages(object, coll)) continue;
                return false;
            }
            if (etw.isValidatable() && ValidationHelper.isCollectionHasValidationMessages(object, coll)) {
                return false;
            }
            Collection value = (Collection)object.getValue(coll.getId());
            for (Object item : value) {
                if (ValidationHelper.isValid((Validatable)item)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCollectionHasValidationMessages(Validatable object, EntityTypeWrapper.CollectionWrapper coll) {
        return !object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId()).isEmpty() || !object.getValidationContext().getValidationMessages(coll.getId()).isEmpty();
    }

    public static boolean move(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        return ValidationHelper.move(from, to, true);
    }

    public static boolean move(Collection<ValidationMessage> from, Collection<ValidationMessage> to, boolean clearFrom) {
        if (!from.isEmpty()) {
            to.addAll(from);
            if (clearFrom) {
                from.clear();
            }
            return true;
        }
        return false;
    }

    public static boolean move(Map<Integer, Collection<ValidationMessage>> from, Map<Integer, Collection<ValidationMessage>> to) {
        if (!from.isEmpty()) {
            to.putAll(from);
            from.clear();
            return true;
        }
        return false;
    }

    public static Map<String, Collection<ValidationMessage>> getAllValidationMessages(Validatable object) {
        return ValidationHelper.getAllValidationMessages(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Collection<ValidationMessage>> getAllValidationMessages(Validatable object, String prefix) {
        HashMap<String, Collection<ValidationMessage>> result = new HashMap<String, Collection<ValidationMessage>>();
        EntityTypeWrapper et = EntityTypeWrapper.get(object.getClass().getName());
        if (!et.isValidatable()) {
            return result;
        }
        for (EntityTypeWrapper.PropertyWrapper prop : et.getProperties()) {
            Map<String, Collection<ValidationMessage>> map;
            Object child;
            EntityTypeWrapper childEt;
            Collection<ValidationMessage> messages = object.getValidationContext().getValidationMessages(prop.getId());
            if (!messages.isEmpty()) {
                result.put(prefix + prop.getId(), new ArrayList<ValidationMessage>(messages));
            }
            if ((childEt = EntityTypeWrapper.get(prop.getType())) == null || !childEt.isValidatable() || (child = (Validatable)object.getValue(prop.getId())) == null || (map = ValidationHelper.getAllValidationMessages((Validatable)child, prefix + prop.getId() + ".")).isEmpty()) continue;
            result.putAll(map);
        }
        for (EntityTypeWrapper.CollectionWrapper coll : et.getCollections()) {
            EntityTypeWrapper elementEt = EntityTypeWrapper.get(coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) {
                Map<Integer, Collection<ValidationMessage>> messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId());
                if (messagesMap.isEmpty()) continue;
                for (Map.Entry entry : messagesMap.entrySet()) {
                    result.put(prefix + coll.getId() + "[" + entry.getKey() + "]", new ArrayList((Collection)entry.getValue()));
                }
                continue;
            }
            Collection<ValidationMessage> messages = object.getValidationContext().getValidationMessages(coll.getId());
            if (!messages.isEmpty()) {
                result.put(prefix + coll.getId(), new ArrayList<ValidationMessage>(messages));
            }
            Collection value = (Collection)object.getValue(coll.getId());
            boolean bl = false;
            for (Object item : value) {
                void var9_12;
                Map<String, Collection<ValidationMessage>> subresult = ValidationHelper.getAllValidationMessages((Validatable)item, String.format("%s%s[%s].", prefix, coll.getId(), (int)var9_12));
                if (!subresult.isEmpty()) {
                    result.putAll(subresult);
                }
                ++var9_12;
            }
        }
        return result;
    }

    public static Validatable clearValidValues(Validatable object) throws Exception {
        Validatable result = (Validatable)object.getClass().newInstance();
        EntityTypeWrapper et = EntityTypeWrapper.get(object.getClass().getName());
        for (EntityTypeWrapper.PropertyWrapper prop : et.getProperties()) {
            Validatable child;
            EntityTypeWrapper childEt;
            Collection<ValidationMessage> messages = object.getValidationContext().getValidationMessages(prop.getId());
            if (!messages.isEmpty()) {
                result.getValidationContext().getValidationMessages(prop.getId()).addAll(messages);
            }
            if ((childEt = EntityTypeWrapper.get(prop.getType())) == null || !childEt.isValidatable() || (child = (Validatable)object.getValue(prop.getId())) == null) continue;
            Validatable newChild = ValidationHelper.clearValidValues(child);
            result.setValue(prop.getId(), newChild);
        }
        for (EntityTypeWrapper.CollectionWrapper coll : et.getCollections()) {
            EntityTypeWrapper elementEt = EntityTypeWrapper.get(coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) {
                Map<Integer, Collection<ValidationMessage>> messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId());
                if (messagesMap.isEmpty()) continue;
                result.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId()).putAll(messagesMap);
                continue;
            }
            Collection<ValidationMessage> messages = object.getValidationContext().getValidationMessages(coll.getId());
            if (!messages.isEmpty()) {
                result.getValidationContext().getValidationMessages(coll.getId()).addAll(messages);
            }
            Collection value = (Collection)object.getValue(coll.getId());
            Collection resValue = (Collection)result.getValue(coll.getId());
            for (Validatable item : value) {
                Validatable newItem = ValidationHelper.clearValidValues(item);
                resValue.add(newItem);
            }
        }
        return result;
    }

    static class EntityTypeWrapper {
        private boolean validatable;
        private final List<PropertyWrapper> properties = new ArrayList<PropertyWrapper>();
        private final List<CollectionWrapper> collections = new ArrayList<CollectionWrapper>();

        EntityTypeWrapper() {
        }

        static EntityTypeWrapper get(String id) {
            EntityTypeWrapper etw = new EntityTypeWrapper();
            EntityType et = MetaRegistryHelper.getEntityType(id);
            if (et != null) {
                etw.validatable = et.isValidatable();
                for (Property prop : MetaRegistryHelper.getAllProperties(et).values()) {
                    etw.properties.add(new PropertyWrapper(prop));
                }
                for (EntityCollection coll : MetaRegistryHelper.getAllCollections(et).values()) {
                    etw.collections.add(new CollectionWrapper(coll));
                }
                return etw;
            }
            RestEntityType ret = RestMetaRegistryHelper.getEntityType(id);
            if (ret != null) {
                etw.validatable = ret.isValidatable();
                for (RestProperty prop : RestMetaRegistryHelper.getAllProperties(ret).values()) {
                    etw.properties.add(new PropertyWrapper(prop));
                }
                for (RestCollection coll : RestMetaRegistryHelper.getAllCollections(ret).values()) {
                    etw.collections.add(new CollectionWrapper(coll));
                }
                return etw;
            }
            return null;
        }

        boolean isValidatable() {
            return this.validatable;
        }

        List<PropertyWrapper> getProperties() {
            return this.properties;
        }

        List<CollectionWrapper> getCollections() {
            return this.collections;
        }

        static class CollectionWrapper {
            private final String id;
            private final String elementType;

            CollectionWrapper(EntityCollection collection) {
                this.id = collection.getId();
                this.elementType = collection.getElementType();
            }

            CollectionWrapper(RestCollection collection) {
                this.id = collection.getId();
                this.elementType = collection.getElementType();
            }

            String getId() {
                return this.id;
            }

            String getElementType() {
                return this.elementType;
            }
        }

        static class PropertyWrapper {
            private final String id;
            private final String type;

            PropertyWrapper(Property property) {
                this.id = property.getId();
                this.type = property.getType();
            }

            PropertyWrapper(RestProperty property) {
                this.id = property.getId();
                this.type = property.getType();
            }

            String getId() {
                return this.id;
            }

            String getType() {
                return this.type;
            }
        }
    }
}

