/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.converter;

import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsConverter {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsConverter.class);

    public static Collection<RestrictionGroup> toRestrictionGroups(Collection<AclPropertyRestrictionGroup> propertyRestrictionGroups) {
        ArrayList<RestrictionGroup> restrictionGroups = new ArrayList<RestrictionGroup>();
        for (AclPropertyRestrictionGroup propertyRestrictionGroup : propertyRestrictionGroups) {
            RestrictionGroup restrictionGroup;
            ArrayList<RestrictionGroup> restrictionValue;
            if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE || propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
                AclPropertyRestriction propertyRestriction = (AclPropertyRestriction)propertyRestrictionGroup.getValue();
                String propertyId = propertyRestriction.getPropertyId();
                String conditionId = propertyRestriction.getConditionId();
                List<Object> value = propertyRestriction.getValue();
                RestrictionResourceProperty property = RestrictionResourcesRegistry.get().getProperty(propertyId);
                if (property == null) {
                    throw new RuntimeException(String.format("unsupported property %s", propertyId));
                }
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId)) {
                    if (property.isCollection()) {
                        conditionId = StandardRestrictionResourcePropertyConditions.CONTAINS.getId();
                        value = Collections.singletonList(value);
                    } else {
                        conditionId = StandardRestrictionResourcePropertyConditions.EQUALS.getId();
                        if (!(Boolean.class.isAssignableFrom(property.getType()) || Number.class.isAssignableFrom(property.getType()) || Date.class.isAssignableFrom(property.getType()))) {
                            value = Collections.singletonList(value);
                        }
                    }
                } else if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                    if (property.isCollection()) {
                        conditionId = StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId();
                        value = Collections.singletonList(value);
                    } else {
                        conditionId = StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId();
                        if (!(Boolean.class.isAssignableFrom(property.getType()) || Number.class.isAssignableFrom(property.getType()) || Date.class.isAssignableFrom(property.getType()))) {
                            value = Collections.singletonList(value);
                        }
                    }
                } else if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId)) {
                    conditionId = property.isCollection() ? StandardRestrictionResourcePropertyConditions.CONTAINS.getId() : StandardRestrictionResourcePropertyConditions.EQUALS.getId();
                } else if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                    conditionId = property.isCollection() ? StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId() : StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId();
                } else if (StandardAclResourcePropertyConditions.YES.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.YES.getId();
                } else if (StandardAclResourcePropertyConditions.NO.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.NO.getId();
                } else if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.WITHIN.getId();
                } else if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.BEYOND.getId();
                } else if (StandardAclResourcePropertyConditions.TODAY.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.TODAY.getId();
                } else if (StandardAclResourcePropertyConditions.YESTERDAY.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.YESTERDAY.getId();
                } else if (StandardAclResourcePropertyConditions.CURRENT_DECADE.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId();
                } else if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(conditionId)) {
                    conditionId = StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId();
                } else if (StandardAclResourcePropertyConditions.NULL.getId().equals(conditionId)) {
                    conditionId = property.isCollection() ? StandardRestrictionResourcePropertyConditions.EMPTY.getId() : StandardRestrictionResourcePropertyConditions.NULL.getId();
                } else if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(conditionId)) {
                    conditionId = property.isCollection() ? StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId() : StandardRestrictionResourcePropertyConditions.NOT_NULL.getId();
                }
                RestrictionResourcePropertyCondition condition = RestrictionResourcesRegistry.get().getCondition(conditionId);
                if (condition == null) {
                    throw new RuntimeException(String.format("unsupported condition %s", conditionId));
                }
                RestrictionValue restrictionValue2 = new RestrictionValue();
                restrictionValue2.setPropertyId(propertyId);
                restrictionValue2.setConditionId(conditionId);
                restrictionValue2.setValue(value);
                RestrictionGroup restrictionGroup2 = new RestrictionGroup();
                restrictionGroup2.setType(RestrictionGroupType.SIMPLE);
                restrictionGroup2.setValue(restrictionValue2);
                if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
                    ArrayList<RestrictionGroup> notRestrictionValue = new ArrayList<RestrictionGroup>();
                    notRestrictionValue.add(restrictionGroup2);
                    RestrictionGroup notRestrictionGroup = new RestrictionGroup();
                    notRestrictionGroup.setType(RestrictionGroupType.NOT);
                    notRestrictionGroup.setValue(notRestrictionValue);
                    restrictionGroups.add(notRestrictionGroup);
                    continue;
                }
                restrictionGroups.add(restrictionGroup2);
                continue;
            }
            if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.AND) {
                restrictionValue = new ArrayList<RestrictionGroup>();
                restrictionValue.addAll(RestrictionsConverter.toRestrictionGroups((List)propertyRestrictionGroup.getValue()));
                restrictionGroup = new RestrictionGroup();
                restrictionGroup.setType(RestrictionGroupType.AND);
                restrictionGroup.setValue(restrictionValue);
                restrictionGroups.add(restrictionGroup);
                continue;
            }
            if (propertyRestrictionGroup.getType() != AclPropertyRestrictionGroupType.OR) continue;
            restrictionValue = new ArrayList();
            restrictionValue.addAll(RestrictionsConverter.toRestrictionGroups((List)propertyRestrictionGroup.getValue()));
            restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType(RestrictionGroupType.OR);
            restrictionGroup.setValue(restrictionValue);
            restrictionGroups.add(restrictionGroup);
        }
        return restrictionGroups;
    }

    public static Collection<AclPropertyRestrictionGroup> toPropertyRestrictionGroups(Collection<RestrictionGroup> restrictionGroups) {
        ArrayList<AclPropertyRestrictionGroup> propertyRestrictionGroups = new ArrayList<AclPropertyRestrictionGroup>();
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            AclPropertyRestrictionGroup propertyRestrictionGroup;
            ArrayList<AclPropertyRestrictionGroup> childPropertyRestrictionGroups;
            if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
                RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
                AclPropertyRestriction propertyRestriction = new AclPropertyRestriction();
                propertyRestriction.setPropertyId(restrictionValue.getPropertyId());
                propertyRestriction.setConditionId(restrictionValue.getConditionId());
                propertyRestriction.setValue(restrictionValue.getValue());
                AclPropertyRestrictionGroup propertyRestrictionGroup2 = new AclPropertyRestrictionGroup();
                propertyRestrictionGroup2.setType(AclPropertyRestrictionGroupType.SIMPLE);
                propertyRestrictionGroup2.setValue(propertyRestriction);
                propertyRestrictionGroups.add(propertyRestrictionGroup2);
                continue;
            }
            if (restrictionGroup.getType() == RestrictionGroupType.NOT) {
                childPropertyRestrictionGroups = new ArrayList<AclPropertyRestrictionGroup>();
                for (RestrictionGroup childRestrictionGroup : (List)restrictionGroup.getValue()) {
                    if (childRestrictionGroup.getType() != RestrictionGroupType.SIMPLE) continue;
                    RestrictionValue restrictionValue = (RestrictionValue)childRestrictionGroup.getValue();
                    AclPropertyRestriction propertyRestriction = new AclPropertyRestriction();
                    propertyRestriction.setPropertyId(restrictionValue.getPropertyId());
                    propertyRestriction.setConditionId(restrictionValue.getConditionId());
                    propertyRestriction.setValue(restrictionValue.getValue());
                    AclPropertyRestrictionGroup propertyRestrictionGroup3 = new AclPropertyRestrictionGroup();
                    propertyRestrictionGroup3.setType(AclPropertyRestrictionGroupType.NOT);
                    propertyRestrictionGroup3.setValue(propertyRestriction);
                    childPropertyRestrictionGroups.add(propertyRestrictionGroup3);
                }
                if (childPropertyRestrictionGroups.size() <= 0) continue;
                propertyRestrictionGroup = new AclPropertyRestrictionGroup();
                propertyRestrictionGroup.setType(AclPropertyRestrictionGroupType.AND);
                propertyRestrictionGroup.setValue(childPropertyRestrictionGroups);
                propertyRestrictionGroups.add(propertyRestrictionGroup);
                continue;
            }
            if (restrictionGroup.getType() == RestrictionGroupType.AND) {
                childPropertyRestrictionGroups = new ArrayList();
                childPropertyRestrictionGroups.addAll(RestrictionsConverter.toPropertyRestrictionGroups((List)restrictionGroup.getValue()));
                propertyRestrictionGroup = new AclPropertyRestrictionGroup();
                propertyRestrictionGroup.setType(AclPropertyRestrictionGroupType.AND);
                propertyRestrictionGroup.setValue(childPropertyRestrictionGroups);
                propertyRestrictionGroups.add(propertyRestrictionGroup);
                continue;
            }
            if (restrictionGroup.getType() != RestrictionGroupType.OR) continue;
            childPropertyRestrictionGroups = new ArrayList();
            childPropertyRestrictionGroups.addAll(RestrictionsConverter.toPropertyRestrictionGroups((List)restrictionGroup.getValue()));
            propertyRestrictionGroup = new AclPropertyRestrictionGroup();
            propertyRestrictionGroup.setType(AclPropertyRestrictionGroupType.OR);
            propertyRestrictionGroup.setValue(childPropertyRestrictionGroups);
            propertyRestrictionGroups.add(propertyRestrictionGroup);
        }
        return propertyRestrictionGroups;
    }
}

