/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rpc;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.compress.CompressingUnMarshaller;
import org.jboss.remoting.transport.ClientFactory;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.http.HTTPClientInvoker;
import org.jboss.remoting.transport.http.WebServerError;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.remoting.transporter.TransporterClient;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceManager
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final String address;
    private final String rpcServerAddress;
    private final Map<Class<?>, Object> services = new HashMap();

    public static RpcServiceManager get() {
        return Environment.getPublished(RpcServiceManager.class);
    }

    public RpcServiceManager(String addr) {
        this(addr, 10, Duration.ofSeconds(180L));
    }

    public RpcServiceManager(String addr, int callAttempts, Duration timeout) {
        this.address = addr;
        this.rpcServerAddress = addr + "/rpc/invoker/?numberOfCallAttempts=" + callAttempts + "&timeout=" + timeout.toMillis();
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public void dispose() {
        Iterator<Map.Entry<Class<?>, Object>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            this.disposeService(it.next().getValue());
            it.remove();
        }
    }

    public void disposeService(Object service) {
        this.log.debug(String.format("disposing remote service %s on %s", service.getClass().getName(), this.rpcServerAddress));
        TransporterClient.destroyTransporterClient((Object)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<? extends T> cls) throws Exception {
        if (cls == null) {
            return null;
        }
        Object result = this.services.get(cls);
        if (result == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(cls.getClassLoader());
                result = TransporterClient.createTransporterClient((String)this.rpcServerAddress, cls);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            this.services.put(cls, result);
            this.log.debug(String.format("instanciated remote service %s on %s", result.getClass().getName(), this.rpcServerAddress));
        }
        return (T)result;
    }

    static {
        InvokerRegistry.registerInvokerFactories((String)"http", CompressingHTTPTransportClientFactory.class, null);
    }

    public static class CompressingHTTPClientInvoker
    extends HTTPClientInvoker {
        public CompressingHTTPClientInvoker(InvokerLocator loc, Map config) {
            super(loc, config);
        }

        protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
            HttpURLConnection conn = super.createURLConnection(url, metadata);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            return conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(InvocationRequest invocationReq) throws Throwable {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuilder buf = new StringBuilder(stackTrace.length * 20);
            for (int i = 1; i < stackTrace.length; ++i) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append("\tat ").append(stackTrace[i]);
            }
            this.setClientStacktrace(invocationReq, buf.toString());
            long timing = System.currentTimeMillis();
            try {
                Object object = super.invoke(invocationReq);
                return object;
            }
            finally {
                if (MiscUtil.TIMING_LOG.isDebugEnabled()) {
                    MiscUtil.logTiming(timing, "RPC invocation " + invocationReq);
                    StringBuilder buf2 = new StringBuilder();
                    for (StackTraceElement elm : Thread.currentThread().getStackTrace()) {
                        String className = elm.getClassName();
                        if (className != null && className.startsWith("com.gridnine.") && !className.startsWith(RpcServiceManager.class.getName())) {
                            buf2.append('\n').append(elm);
                            continue;
                        }
                        if (buf2.length() > 0) break;
                    }
                    if (buf2.length() > 0) {
                        MiscUtil.TIMING_LOG.debug("invocation context:" + buf2);
                    }
                }
            }
        }

        private void setClientStacktrace(InvocationRequest invocationReq, String stacktrace) {
            Object payload = invocationReq.getParameter();
            if (!(payload instanceof RemoteInvocation)) {
                return;
            }
            RemoteInvocation ri = (RemoteInvocation)payload;
            if (ri.getParameters() == null) {
                return;
            }
            for (Object param : ri.getParameters()) {
                if (!(param instanceof ServiceInvocationContext)) continue;
                ((ServiceInvocationContext)param).setClientStacktrace(stacktrace);
            }
        }

        protected Object makeInvocation(HttpURLConnection conn, String url, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller, boolean setTimeout) throws IOException {
            Throwable savedException = null;
            for (int i = 0; i < this.numberOfCallAttempts; ++i) {
                try {
                    Object o = this.useHttpURLConnection(conn, invocation, metadata, marshaller, unmarshaller);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("result: " + o));
                    }
                    return o;
                }
                catch (CannotConnectException var12) {
                    savedException = var12.getCause();
                    String suffix = i < this.numberOfCallAttempts - 1 ? ": will retry" : "";
                    log.debug((Object)("Cannot connect on attempt " + (i + 1) + suffix));
                    conn = this.createURLConnection(url, metadata);
                    if (!setTimeout) continue;
                    this.getSimulatedTimeout(this.configuration, metadata, conn);
                    continue;
                }
            }
            String msg = "can not connect to " + url + " after " + this.numberOfCallAttempts + " attempt(s)";
            throw new CannotConnectException(msg, savedException);
        }

        private Object useHttpURLConnection(HttpURLConnection conn, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws WebServerError {
            int responseCode;
            Object result;
            block65: {
                result = null;
                boolean var7 = true;
                try {
                    InputStream is;
                    Throwable throwable;
                    String responseMessage2;
                    Map header;
                    this.setChunked(this.configuration, conn);
                    String basicAuth = this.getBasicAuth(metadata);
                    if (basicAuth != null) {
                        conn.setRequestProperty("Authorization", basicAuth);
                    }
                    if ((result = this.checkForLeasePing(conn, invocation, metadata)) != null) {
                        return result;
                    }
                    boolean sendingData = true;
                    String type = "POST";
                    if (metadata != null) {
                        type = (String)metadata.get("TYPE");
                        if (type != null) {
                            if (!type.equals("POST") && !type.equals("PUT")) {
                                sendingData = false;
                            }
                        } else {
                            type = "POST";
                        }
                    } else {
                        metadata = new HashMap<String, Object>();
                        header = new HashMap<String, String>();
                        header.put("Content-Type", WebUtil.getContentType((Object)invocation));
                        metadata.put("HEADER", header);
                    }
                    if ((header = (Map)metadata.get("HEADER")) != null) {
                        Set keys = header.keySet();
                        for (String responseMessage2 : keys) {
                            responseMessage2 = (String)header.get(responseMessage2);
                            log.debug((Object)("Setting request header with " + responseMessage2 + " : " + responseMessage2));
                            conn.setRequestProperty(responseMessage2, responseMessage2);
                        }
                    } else {
                        conn.setRequestProperty("Content-Type", WebUtil.getContentType((Object)invocation));
                    }
                    conn.setRequestProperty("JBoss-Remoting-Version", new Integer(this.getVersion()).toString());
                    conn.setRequestProperty("User-Agent", "JBossRemoting - 2.4.0.SP1 (Pinto)");
                    if (sendingData) {
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setRequestMethod(type);
                        throwable = null;
                        try (OutputStream stream = SecurityUtility.getOutputStream((HttpURLConnection)conn);){
                            if (marshaller instanceof VersionedMarshaller) {
                                ((VersionedMarshaller)marshaller).write(invocation, stream, this.getVersion());
                            } else {
                                marshaller.write(invocation, stream);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        responseCode = SecurityUtility.getResponseCode((HttpURLConnection)conn);
                        is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                        throwable = null;
                        try {
                            Map<String, List<String>> headers = conn.getHeaderFields();
                            if (metadata == null) {
                                metadata = new HashMap();
                            }
                            if (headers != null) {
                                for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                                    if (e.getKey() == null) continue;
                                    metadata.put(e.getKey(), e.getValue());
                                }
                            }
                            responseMessage2 = SecurityUtility.getResponseMessage((HttpURLConnection)conn);
                            metadata.put("ResponseCodeMessage", responseMessage2);
                            metadata.put("ResponseCode", new Integer(responseCode));
                            metadata.put("ResponseHeaders", headers);
                            result = this.readResponse(metadata, headers, unmarshaller, is);
                            break block65;
                        }
                        catch (Throwable headers) {
                            throwable = headers;
                            throw headers;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable headers) {
                                        throwable.addSuppressed(headers);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    conn.setDoOutput(false);
                    conn.setDoInput(true);
                    conn.setRequestMethod(type);
                    SecurityUtility.connect((HttpURLConnection)conn);
                    is = SecurityUtility.getResponseCode((HttpURLConnection)conn) < 400 ? conn.getInputStream() : conn.getErrorStream();
                    throwable = null;
                    try {
                        Map<String, List<String>> headers = conn.getHeaderFields();
                        result = this.readResponse(null, headers, unmarshaller, is);
                        if (metadata == null) {
                            metadata = new HashMap();
                        }
                        metadata.putAll(headers);
                        responseMessage2 = SecurityUtility.getResponseMessage((HttpURLConnection)conn);
                        metadata.put("ResponseCodeMessage", responseMessage2);
                        responseCode = SecurityUtility.getResponseCode((HttpURLConnection)conn);
                        metadata.put("ResponseCode", new Integer(responseCode));
                        metadata.put("ResponseHeaders", conn.getHeaderFields());
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (Exception var18) {
                    String message = "Can not connect http client invoker.";
                    if (var18.getMessage() != null) {
                        message = message + " " + var18.getMessage() + ".";
                    }
                    try {
                        String type = SecurityUtility.getResponseMessage((HttpURLConnection)conn);
                        int code = SecurityUtility.getResponseCode((HttpURLConnection)conn);
                        message = message + " Response: " + type + "/" + code + ".";
                    }
                    catch (IOException var17) {
                        log.debug((Object)"Unable to retrieve response message", (Throwable)var17);
                    }
                    throw new CannotConnectException(message, (Throwable)var18);
                }
            }
            if (responseCode >= 400) {
                Object configObj;
                boolean doNotThrow = this.noThrowOnError;
                if (metadata != null && (configObj = metadata.get("NoThrowOnError")) != null && configObj instanceof String) {
                    doNotThrow = Boolean.valueOf((String)configObj);
                }
                if (doNotThrow) {
                    if (result instanceof String) {
                        WebServerError ex = new WebServerError((String)result);
                        return ex;
                    }
                    return result instanceof InvocationResponse ? ((InvocationResponse)result).getResult() : result;
                }
                if (result instanceof InvocationResponse) {
                    return result;
                }
                if (result instanceof String) {
                    WebServerError ex = new WebServerError((String)result);
                    throw ex;
                }
                WebServerError ex = new WebServerError("Error received when calling on web server.  Error returned was " + responseCode);
                throw ex;
            }
            return result;
        }

        private void setChunked(Map metadata, HttpURLConnection conn) {
            String chunkedValue = (String)metadata.get("chunkedLength");
            if (chunkedValue != null && chunkedValue.length() > 0) {
                try {
                    int chunkedLength = Integer.parseInt(chunkedValue);
                    try {
                        Class<?> cl = conn.getClass();
                        Class[] paramTypes = new Class[]{Integer.TYPE};
                        Method setChunkedLengthMethod = SecurityUtility.getMethod(cl, (String)"setChunkedStreamingMode", (Class[])paramTypes);
                        setChunkedLengthMethod.invoke((Object)conn, new Integer(chunkedLength));
                    }
                    catch (NoSuchMethodException var8) {
                        log.warn((Object)("Could not set chunked length (" + chunkedLength + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)"));
                    }
                    catch (IllegalAccessException var9) {
                        log.error((Object)"Error setting http client connection chunked length.");
                        log.debug((Object)var9);
                    }
                    catch (InvocationTargetException var10) {
                        log.error((Object)"Error setting http client connection chunked length.");
                        log.debug((Object)var10);
                    }
                    catch (Exception var11) {
                        log.error((Object)"Unexpected error setting http client connection chunked length.");
                        log.debug((Object)var11);
                    }
                }
                catch (NumberFormatException var12) {
                    log.error((Object)("Could not set chunked length for http client connection because value (" + chunkedValue + ") is not a number."));
                }
            }
        }

        private String getBasicAuth(Map metadata) {
            String authString = null;
            String username = null;
            String password = null;
            if (metadata != null) {
                username = (String)metadata.get("http.basic.username");
            }
            if (username == null || username.length() == 0) {
                username = SecurityUtility.getSystemProperty((String)"http.basic.username");
            }
            if (metadata != null) {
                password = (String)metadata.get("http.basic.password");
            }
            if (password == null) {
                password = SecurityUtility.getSystemProperty((String)"http.basic.password");
            }
            if (username != null && password != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(username);
                buffer.append(":");
                buffer.append(password);
                String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes(), (int)8);
                authString = "Basic " + encoded;
            }
            return authString;
        }

        private int getSimulatedTimeout(Map configuration, Map metadata, HttpURLConnection conn) {
            int timeout = -1;
            String connectionTimeout = (String)configuration.get("timeout");
            String invocationTimeout = (String)metadata.get("timeout");
            if (invocationTimeout != null && invocationTimeout.length() > 0) {
                try {
                    timeout = Integer.parseInt(invocationTimeout);
                }
                catch (NumberFormatException var15) {
                    log.error((Object)("Could not set timeout for current invocation because value (" + invocationTimeout + ") is not a number."));
                }
            }
            if (timeout < 0 && connectionTimeout != null && connectionTimeout.length() > 0) {
                try {
                    timeout = Integer.parseInt(connectionTimeout);
                }
                catch (NumberFormatException var14) {
                    log.error((Object)("Could not set timeout for http client connection because value (" + connectionTimeout + ") is not a number."));
                }
            }
            if (timeout < 0) {
                timeout = 0;
            }
            try {
                Class<?> cl = conn.getClass();
                Class[] paramTypes = new Class[]{Integer.TYPE};
                Method setTimeoutMethod = SecurityUtility.getMethod(cl, (String)"setConnectTimeout", (Class[])paramTypes);
                setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
                setTimeoutMethod = SecurityUtility.getMethod(cl, (String)"setReadTimeout", (Class[])paramTypes);
                setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
                return -1;
            }
            catch (NoSuchMethodException var10) {
                log.debug((Object)"Using older JDK (prior to 1.5): will simulate timeout");
            }
            catch (IllegalAccessException var11) {
                log.error((Object)"Error setting http client connection timeout.");
                log.debug((Object)var11);
            }
            catch (InvocationTargetException var12) {
                log.error((Object)"Error setting http client connection timeout.");
                log.debug((Object)var12);
            }
            catch (Exception var13) {
                log.error((Object)"Unexpected error setting http client connection timeout.");
                log.debug((Object)var13);
            }
            return timeout;
        }

        private Object checkForLeasePing(HttpURLConnection conn, Object invocation, Map metadata) throws IOException {
            InvocationRequest request;
            Object payload;
            InvocationResponse response = null;
            boolean shouldLease = false;
            long leasePeriod = -1L;
            if (invocation != null && invocation instanceof InvocationRequest && (payload = (request = (InvocationRequest)invocation).getParameter()) != null && payload instanceof String && "$PING$".equalsIgnoreCase((String)payload) && request.getReturnPayload() != null) {
                try {
                    conn.setDoOutput(false);
                    conn.setDoInput(true);
                    conn.setRequestMethod("HEAD");
                    conn.setRequestProperty("JBoss-Remoting-Version", new Integer(this.getVersion()).toString());
                    conn.setRequestProperty("User-Agent", "JBossRemoting - 2.4.0.SP1 (Pinto)");
                    conn.setRequestProperty("JBoss-Remoting-Lease-Query", "true");
                    conn.setRequestProperty("sessionId", request.getSessionId());
                    SecurityUtility.connect((HttpURLConnection)conn);
                    Map<String, List<String>> headers = conn.getHeaderFields();
                    if (headers != null) {
                        List<String> leasingPeriod;
                        List<String> leasingEnabled = headers.get("LEASING_ENABLED");
                        if (leasingEnabled != null && leasingEnabled instanceof List) {
                            shouldLease = new Boolean(leasingEnabled.get(0));
                        }
                        if ((leasingPeriod = headers.get("LEASE_PERIOD")) != null && leasingPeriod instanceof List) {
                            leasePeriod = new Long(leasingPeriod.get(0));
                        }
                    }
                }
                catch (IOException var13) {
                    log.error((Object)"Error checking server for lease information.", (Throwable)var13);
                }
                HashMap<String, Long> p = new HashMap<String, Long>();
                p.put("clientLeasePeriod", new Long(leasePeriod));
                InvocationResponse innterResponse = new InvocationResponse(null, (Object)new Boolean(shouldLease), false, p);
                response = new InvocationResponse(null, (Object)innterResponse, false, null);
            }
            return response;
        }

        private Object readResponse(Map metadata, Map headers, UnMarshaller unmarshaller, InputStream is) throws ClassNotFoundException, IOException {
            Object o;
            Map map;
            Object result = null;
            String encoding = null;
            Object ceObj = CollectionUtil.mapGetCaseInsensitive(headers, "Content-Encoding");
            if (ceObj != null && ceObj instanceof List) {
                encoding = (String)((List)ceObj).get(0);
            }
            if (encoding != null && encoding.indexOf("gzip") >= 0) {
                unmarshaller = new CompressingUnMarshaller(MarshalFactory.getUnMarshaller((String)"serializable"));
            }
            Map map2 = map = metadata == null ? headers : metadata;
            if (map.get("preserveLines") == null && (o = this.configuration.get("preserveLines")) != null) {
                map.put("preserveLines", o);
            }
            try {
                result = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(is, map, this.getVersion()) : unmarshaller.read(is, map);
                return result;
            }
            catch (ClassNotFoundException var10) {
                throw var10;
            }
            catch (IOException var11) {
                if (-1 == is.read()) {
                    throw new EOFException();
                }
                throw var11;
            }
        }
    }

    public static class CompressingHTTPTransportClientFactory
    implements ClientFactory {
        public ClientInvoker createClientInvoker(InvokerLocator locator, Map config) {
            return new CompressingHTTPClientInvoker(locator, config);
        }

        public boolean supportsSSL() {
            return false;
        }
    }
}

