/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.List;
import java.util.RandomAccess;

public final class RuleEngine {
    public static void applyRules(List<? extends RuleProxy<?, ?>> objects, RuleSet rules) throws Exception {
        RuleEngine.applyRules(objects, rules, null);
    }

    public static void applyRules(List<? extends RuleProxy<?, ?>> objects, RuleSet rules, RuleResultHandler ruleResultHandler) throws Exception {
        if (rules == null) {
            return;
        }
        RuleEngine.applyRules(objects, rules.getRules(), ruleResultHandler);
    }

    public static void applyRules(List<? extends RuleProxy<?, ?>> objects, List<RuleSettings> rules) throws Exception {
        RuleEngine.applyRules(objects, rules, null);
    }

    public static void applyRules(List<? extends RuleProxy<?, ?>> objects, List<RuleSettings> rules, RuleResultHandler ruleResultHandler) throws Exception {
        if (!(objects instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace("List and not RandomAccess");
        }
        block0: for (int i = 0; i < objects.size(); ++i) {
            RuleProxy<?, ?> proxy = objects.get(i);
            if (!(rules instanceof RandomAccess)) {
                IncidentsLog.reportStackTrace("List and not RandomAccess");
            }
            block1: for (int j = 0; j < rules.size(); ++j) {
                String category;
                RuleResult res;
                int k;
                RuleSettings rs = rules.get(j);
                if (rs.getTarget() == null || !proxy.getProxyType().equals(rs.getTarget().getId()) || rs.getPeriodBegin() != null && (proxy.getProxyDate() == null || rs.getPeriodBegin().after(proxy.getProxyDate())) || rs.getPeriodEnd() != null && (proxy.getProxyDate() == null || rs.getPeriodEnd().before(proxy.getProxyDate()))) continue;
                if (ruleResultHandler != null) {
                    ruleResultHandler.processRule(proxy, rs);
                }
                if (!(rs.getResults() instanceof RandomAccess)) {
                    IncidentsLog.reportStackTrace("List and not RandomAccess");
                }
                for (k = 0; k < rs.getResults().size(); ++k) {
                    res = rs.getResults().get(k);
                    if (res.getAction() != null && ((category = res.getAction().getRuleCategoryValue(proxy.getActionSet(), res.getValue())) != null && proxy.getAppliedRuleCategories().contains(category) && (ruleResultHandler == null || !ruleResultHandler.isProcessAllRuleResults()) || category != null && !proxy.getDesiredRuleCategories().isEmpty() && !proxy.getDesiredRuleCategories().contains(category))) continue block1;
                }
                if (!(rs.getRestrictions() instanceof RandomAccess)) {
                    IncidentsLog.reportStackTrace("List and not RandomAccess");
                }
                for (k = 0; k < rs.getRestrictions().size(); ++k) {
                    RuleRestriction restr = rs.getRestrictions().get(k);
                    if (restr.getProperty() != null && !restr.getProperty().match(proxy.getPropertySet(), restr.getCondition(), restr.getValue())) continue block1;
                }
                for (k = 0; k < rs.getResults().size(); ++k) {
                    res = rs.getResults().get(k);
                    if (res.getAction() == null) continue;
                    category = res.getAction().getRuleCategoryValue(proxy.getActionSet(), res.getValue());
                    if (ruleResultHandler != null) {
                        ruleResultHandler.processRuleResult(proxy, rs, res);
                    }
                    if (!proxy.getAppliedRuleCategories().contains(category)) {
                        res.getAction().apply(proxy, res.getValue());
                        if (proxy.getAppliedRuleCategories().contains(category)) {
                            proxy.getAppliedRules().add(rs.getUid());
                        }
                    }
                    if (proxy.getStopPredicate() != null && proxy.getStopPredicate().apply(proxy).booleanValue()) continue block0;
                }
            }
            if (ruleResultHandler == null) continue;
            ruleResultHandler.done(proxy);
        }
    }

    private RuleEngine() {
    }
}

