/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public final class FilterQuery
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -359838213975776953L;
    private String property;
    private Object value;
    private SortOrder sortOrder;

    FilterQuery() {
    }

    public FilterQuery(String prop) {
        this(prop, null, null);
    }

    public FilterQuery(String prop, Object val) {
        this(prop, val, null);
    }

    public FilterQuery(String prop, SortOrder order) {
        this(prop, null, order);
    }

    public FilterQuery(String prop, Object val, SortOrder order) {
        this.property = prop;
        this.value = val;
        this.sortOrder = order;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder val) {
        this.sortOrder = val;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.property = XHelper.readString(elm, "property");
        this.sortOrder = XHelper.readEnum(elm, "sortOrder", SortOrder.class);
        this.value = XHelper.readObject(elm, "value");
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tagName = reader.getName().getLocalPart();
            if ("property".equals(tagName)) {
                this.property = XSHelper.readString(reader);
                continue;
            }
            if ("sortOrder".equals(tagName)) {
                this.sortOrder = XSHelper.readEnum(reader, SortOrder.class);
                continue;
            }
            if ("value".equals(tagName)) {
                this.value = XSHelper.readObject(reader);
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "property", this.property);
        XHelper.writeEnum(elm, "sortOrder", this.sortOrder);
        if (this.value != null && !XHelper.isSupportedObjectType(this.value.getClass())) {
            throw new IllegalStateException("unsupported filter value type " + this.value.getClass().getName());
        }
        XHelper.writeObject(elm, "value", this.value);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "property", this.property);
        XSHelper.writeEnum(writer, "sortOrder", this.sortOrder);
        if (this.value != null && !XSHelper.isSupportedObjectType(this.value.getClass())) {
            throw new IllegalStateException("unsupported filter value type " + this.value.getClass().getName());
        }
        XSHelper.writeObject(writer, "value", this.value);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        FilterQuery clone = new FilterQuery();
        clone.property = this.property;
        clone.sortOrder = this.sortOrder;
        clone.value = XCloneHelper.cloneObject(this.value, newUids, uids);
        return clone;
    }
}

