/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ProjectionQuery
extends StorageQuery {
    private static final long serialVersionUID = 3664671864760938520L;
    private final List<Projection> projections = new ArrayList<Projection>();

    public List<Projection> getProjections() {
        return this.projections;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.projections.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "projections/item")) {
            this.projections.add(Projection.readFromXML(itemElm));
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tagName = reader.getName().getLocalPart();
            if ("projections".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(tagName)) {
                        this.projections.add(Projection.readFromXML(reader));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        for (Projection filter : this.projections) {
            filter.toXML(XmlUtil.addElement(elm, "projections/item"));
        }
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        super.toXML(writer);
        if (!this.projections.isEmpty()) {
            writer.writeStartElement("projections");
            for (Projection filter : this.projections) {
                writer.writeStartElement("item");
                filter.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected void copyFrom(StorageQuery sourceStorageQuery, boolean newUids, Map<String, String> uids) throws Exception {
        ProjectionQuery source = (ProjectionQuery)sourceStorageQuery;
        this.projections.clear();
        this.projections.addAll(XCloneHelper.cloneCollection(source.projections, newUids, uids));
    }

    public String toString() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT ");
            if (this.projections.isEmpty()) {
                buf.append("???");
            } else {
                int count = 0;
                for (Projection proj : this.projections) {
                    if (count > 0) {
                        buf.append(",");
                    }
                    proj.toString(buf);
                    ++count;
                }
            }
            this.getCriteria().toString(buf);
            return buf.toString();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("failed converting projection query to string", t);
            return super.toString();
        }
    }
}

