/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class SecurityHelper {
    public static PrivateKey createPrivateKey(byte[] content) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(content);
        return factory.generatePrivate(spec);
    }

    public static PublicKey createPublicKey(byte[] content) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(content);
        return factory.generatePublic(spec);
    }

    public static SecurityData generateKeys() throws Exception {
        LocalDate startDate = LocalDate.now();
        LocalDate endDate = startDate.plusYears(1L);
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        keyGenerator.initialize(2048);
        KeyPair keyPair = keyGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Name("CN=Gridnine"), BigInteger.ONE, (java.util.Date)Date.valueOf(startDate), (java.util.Date)Date.valueOf(endDate), new X500Name("CN=CIR"), publicKey);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(privateKey);
        Certificate certificate = CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(builder.build(signer).toASN1Structure().getEncoded()));
        return new SecurityData(privateKey, publicKey, certificate);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class PBE {
        private static final byte[] salt = new byte[]{-56, 115, 65, -116, 126, -40, -18, -119};
        private static final int iterations = 1024;
        private static final int length = 128;
        private SecretKey secretKey = null;
        private Cipher cipher = null;

        public PBE(char[] password) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(password, salt, 1024, 128);
            this.secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }

        public PBEStorage encrypt(byte[] content) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidParameterSpecException {
            this.cipher.init(1, this.secretKey);
            return new PBEStorage(this.cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV(), this.cipher.doFinal(content));
        }

        public byte[] decrypt(PBEStorage storage) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
            this.cipher.init(2, (Key)this.secretKey, new IvParameterSpec(storage.getIv()));
            return this.cipher.doFinal(storage.getContent());
        }
    }

    public static class PBEStorage {
        private final byte[] iv;
        private final byte[] content;

        public PBEStorage(byte[] iv, byte[] content) {
            this.iv = iv;
            this.content = content;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public byte[] getContent() {
            return this.content;
        }

        public static PBEStorage read(byte[] base64) {
            byte[] data = Base64.getDecoder().decode(base64);
            int length = ByteBuffer.wrap(data).getInt();
            byte[] iv = new byte[length];
            byte[] content = new byte[data.length - 4 - length];
            System.arraycopy(data, 4, iv, 0, iv.length);
            System.arraycopy(data, 4 + length, content, 0, content.length);
            return new PBEStorage(iv, content);
        }

        public static byte[] write(PBEStorage storage) {
            byte[] iv = storage.getIv();
            byte[] content = storage.getContent();
            byte[] data = new byte[4 + iv.length + content.length];
            System.arraycopy(ByteBuffer.allocate(4).putInt(iv.length).array(), 0, data, 0, 4);
            System.arraycopy(iv, 0, data, 4, iv.length);
            System.arraycopy(content, 0, data, 4 + iv.length, content.length);
            return Base64.getEncoder().encode(data);
        }
    }

    public static class SecurityData {
        private final PrivateKey privateKey;
        private final PublicKey publicKey;
        private final Certificate certificate;

        public SecurityData(PrivateKey privateKey, PublicKey publicKey, Certificate certificate) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
            this.certificate = certificate;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

