/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclPermissionsProvider;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.resource.AclQueryable;
import com.gridnine.xtrip.common.security.acl.resource.AclResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxyBuilder;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclHelper {
    private static final Logger log = LoggerFactory.getLogger(AclHelper.class);
    public static final String PATTERN_WILDCARD = "*";
    public static final String ENTRY_COMPOUND_ID_SEPARATOR = "|";
    public static final String ENTRY_COMPOUND_PROPERTY_NAME = "compoundId";
    public static final AclGroup all = new AclGroup("all");
    public static final AclGroup administators = new AclGroup("administrators");
    public static final AclUser system = new AclUser("system");
    public static final AclUser admin = new AclUser("admin");
    public static final Comparator<AclPrincipal> principalComparator;
    public static final Comparator<AclGroup> groupComparator;
    public static final Comparator<AclUser> userComparator;

    public static boolean isSpecialGroup(AclGroup group) {
        return group.equals(all) || group.equals(administators);
    }

    public static boolean isSpecialUser(AclUser user) {
        return user.equals(system) || user.equals(admin);
    }

    public static String createEntryCompoundId(String principalId, String resourceId) {
        return principalId + ENTRY_COMPOUND_ID_SEPARATOR + resourceId;
    }

    public static Collection<AclGroup> getGroups() {
        return AssetsStorage.get().search(AclGroup.class, new SearchQuery()).getData();
    }

    public static Collection<AclGroup> getRootGroups() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq(AclGroup.Property.parentId.name(), null));
        return AssetsStorage.get().search(AclGroup.class, query).getData();
    }

    public static AclGroup getGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        return AssetsStorage.get().find(AclGroup.class, AclGroup.Property.id.name(), groupId);
    }

    public static AclGroup getGroupParent(String groupId) {
        if (groupId == null) {
            return null;
        }
        AclGroup group = AclHelper.getGroup(groupId);
        if (group != null) {
            return AclHelper.getGroup(group.getParentId());
        }
        return null;
    }

    public static Collection<AclGroup> getGroupChildren(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq(AclGroup.Property.parentId.name(), groupId));
        return AssetsStorage.get().search(AclGroup.class, query).getData();
    }

    public static Collection<AclUser> getGroupUsers(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains(AclUser.Property.groupIds.name(), groupId));
        return AssetsStorage.get().search(AclUser.class, query).getData();
    }

    public static void saveGroup(AclGroup group) {
        if (group == null) {
            return;
        }
        AssetsStorage.get().save(group);
    }

    public static void deleteGroup(AclGroup group) {
        if (group == null) {
            return;
        }
        if (AclHelper.isSpecialGroup(group)) {
            throw new IllegalArgumentException(String.format("group %s can not be deleted", group.getId()));
        }
        for (AclUser user : AclHelper.getGroupUsers(group.getId())) {
            user.getGroupIds().remove(group.getId());
            AclHelper.saveUser(user);
        }
        for (AclGroup child : AclHelper.getGroupChildren(group.getId())) {
            child.setParentId(null);
            AclHelper.saveGroup(child);
        }
        for (AclEntry entry : AclHelper.getEntries(group.getId())) {
            AclHelper.deleteEntry(entry);
        }
        AssetsStorage.get().delete(group);
    }

    public static Collection<AclUser> getUsers() {
        return AssetsStorage.get().search(AclUser.class, new SearchQuery()).getData();
    }

    public static Collection<AclUser> getRootUsers() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isEmpty(AclUser.Property.groupIds.name()));
        return AssetsStorage.get().search(AclUser.class, query).getData();
    }

    public static AclUser getUser(String userId) {
        if (userId == null) {
            return null;
        }
        return AssetsStorage.get().find(AclUser.class, AclUser.Property.id.name(), userId);
    }

    public static Collection<AclGroup> getUserGroups(String userId) {
        if (userId == null) {
            return Collections.emptyList();
        }
        AclUser user = AclHelper.getUser(userId);
        if (user != null) {
            ArrayList<AclGroup> groups = new ArrayList<AclGroup>();
            for (String groupId : user.getGroupIds()) {
                AclGroup group = AclHelper.getGroup(groupId);
                if (group == null) continue;
                groups.add(group);
            }
            return groups;
        }
        return Collections.emptyList();
    }

    public static void saveUser(AclUser user) {
        if (user == null) {
            return;
        }
        AssetsStorage.get().save(user);
    }

    public static void deleteUser(AclUser user) {
        if (user == null) {
            return;
        }
        if (AclHelper.isSpecialUser(user)) {
            throw new IllegalArgumentException(String.format("user %s can not be deleted", user.getId()));
        }
        for (AclEntry entry : AclHelper.getEntries(user.getId())) {
            AclHelper.deleteEntry(entry);
        }
        AssetsStorage.get().delete(user);
    }

    public static Collection<AclEntry> getEntries() {
        return AssetsStorage.get().search(AclEntry.class, new SearchQuery()).getData();
    }

    public static Collection<AclEntry> getEntries(String principalId) {
        if (principalId == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq(AclEntry.Property.principalId.name(), principalId));
        return AssetsStorage.get().search(AclEntry.class, query).getData();
    }

    public static AclEntry getEntry(String resourceId, String principalId) {
        if (resourceId == null || principalId == null) {
            return null;
        }
        return AssetsStorage.get().find(AclEntry.class, ENTRY_COMPOUND_PROPERTY_NAME, AclHelper.createEntryCompoundId(principalId, resourceId));
    }

    public static void saveEntry(AclEntry entry) {
        if (entry == null) {
            return;
        }
        AssetsStorage.get().save(entry);
    }

    public static void deleteEntry(AclEntry entry) {
        if (entry == null) {
            return;
        }
        AssetsStorage.get().delete(entry);
    }

    public static Collection<AclRule> getRules(String resourceId, String userId) {
        AclPermissionsProvider provider = Environment.getPublished(AclPermissionsProvider.class);
        return provider.getRules(resourceId, userId);
    }

    public static boolean isGranted(EntityContainer<? extends BaseEntity> entityContainer, String entityId, String resourceId, String userId, String operationId) throws Exception {
        AclResourceProxy proxy = null;
        if (entityContainer != null && entityId != null) {
            proxy = AclHelper.buildProxies(entityContainer, resourceId).get(entityId);
        }
        return AclHelper.isGranted(proxy, resourceId, userId, operationId);
    }

    public static boolean isGranted(AclResourceProxy proxy, String resourceId, String userId, String operationId) throws Exception {
        AclPermissionsProvider provider = Environment.getPublished(AclPermissionsProvider.class);
        AclResourceOperationPermission permission = provider.getPermission(proxy, resourceId, userId, operationId);
        return permission != AclResourceOperationPermission.DENY;
    }

    public static Map<String, AclResourceProxy> buildProxies(Object object, String resourceId) throws Exception {
        return AclHelper.buildProxies(object, null, resourceId);
    }

    public static Map<String, AclResourceProxy> buildProxies(EntityContainer<?> entityContainer, String resourceId) throws Exception {
        return AclHelper.buildProxies(entityContainer.getEntity(), entityContainer.getUid(), resourceId);
    }

    public static Map<String, AclResourceProxy> buildProxies(Object object, String containerUid, String resourceId) throws Exception {
        AclResource resource;
        AclResourcesEnvironment environment;
        AclHelper.requireNonNull(object, () -> "object is null");
        AclHelper.requireNonNull(resourceId, () -> "resource id is null");
        if (log.isDebugEnabled()) {
            log.debug("building proxies for " + object.getClass().getName() + " using resource " + resourceId);
        }
        if ((environment = Environment.getPublished(AclResourcesEnvironment.class)).getResource(resourceId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource %s is not registered, checking meta registry", resourceId));
            }
            resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
            while (resourceId != null) {
                log.debug(String.format("checking meta resource %s", resourceId));
                if (environment.getResource(resourceId) != null) break;
                log.debug(String.format("meta resource %s is not registered", resourceId));
                resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
                log.debug(String.format("using super resource %s", resourceId));
            }
            if (resourceId == null) {
                if (log.isDebugEnabled()) {
                    log.debug("resources is not registered, permission is null");
                }
                return Collections.emptyMap();
            }
        }
        if ((resource = environment.getResource(resourceId)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("resource " + resourceId + " is not found, returning empty map");
            }
            return Collections.emptyMap();
        }
        HashMap<String, AclResourceProxy> proxies = new HashMap<String, AclResourceProxy>();
        AclHelper.buildProxies(object, containerUid, resourceId, null, proxies);
        return proxies;
    }

    private static void buildProxies(Object object, String containerUid, String resourceId, AclResourceProxy parentProxy, Map<String, AclResourceProxy> proxies) throws Exception {
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        AclResource resource = environment.getResource(resourceId);
        AclHelper.requireNonNull(resource, () -> "resource " + resourceId + " is not found");
        String resourceProxyBuilderId = environment.getResourceProxyBuilder(resourceId);
        if (resourceProxyBuilderId == null) {
            if (log.isDebugEnabled()) {
                log.debug("resource proxy builder for resource " + resourceId + " is not found");
            }
            Collection<String> resourceChildIds = environment.getResourceChildren(resourceId);
            for (String resourceChildId : resourceChildIds) {
                AclHelper.buildProxies(object, containerUid, resourceChildId, parentProxy, proxies);
            }
        } else {
            AclResourceProxyBuilder resourceProxyBuilder = environment.getProxyBuilder(resourceProxyBuilderId);
            AclHelper.requireNonNull(resourceProxyBuilder, () -> "resource proxy builder " + resourceId + " is not found");
            for (AclResourceProxy proxy : resourceProxyBuilder.build(object, containerUid, parentProxy)) {
                proxies.put(proxy.getId(), proxy);
                Collection<String> resourceChildIds = environment.getResourceChildren(resourceId);
                for (String resourceChildId : resourceChildIds) {
                    AclHelper.buildProxies(object, containerUid, resourceChildId, proxy, proxies);
                }
            }
        }
    }

    public static SearchQuery modifyQuery(SearchQuery query, String resourceId, String userId) throws Exception {
        AclPermissionsProvider provider;
        SearchQueryData searchQueryData;
        if (log.isDebugEnabled()) {
            log.debug("original query: " + query);
        }
        if ((searchQueryData = (provider = Environment.getPublished(AclPermissionsProvider.class)).getSearchQueryData(resourceId, userId)) != null) {
            if (searchQueryData.getCriterion() != null) {
                query.getCriteria().getCriterions().add(searchQueryData.getCriterion());
            }
            for (String field : searchQueryData.getFields()) {
                String property = field.substring(field.lastIndexOf(".") + 1);
                query.getPreferredProperties().remove(property);
                Iterator<FilterQuery> iterator = query.getFilters().iterator();
                while (iterator.hasNext()) {
                    FilterQuery filter = iterator.next();
                    if (!filter.getProperty().equals(property)) continue;
                    iterator.remove();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("modified query: " + query);
        }
        return query;
    }

    public static SearchCriterion getCriterion(AclPropertyRestrictionGroup propertyRestrictionGroup, String userId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("checking property restriction group " + (Object)((Object)propertyRestrictionGroup.getType()));
        }
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE || propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
            AclResourceProperty property;
            AclPropertyRestriction propertyRestriction = (AclPropertyRestriction)propertyRestrictionGroup.getValue();
            String propertyId = propertyRestriction.getPropertyId();
            if (propertyId == null) {
                if (log.isDebugEnabled()) {
                    log.debug("property id of property restriction is null, returning null");
                }
                return null;
            }
            String conditionId = propertyRestriction.getConditionId();
            if (conditionId == null) {
                if (log.isDebugEnabled()) {
                    log.debug("condition id of property restriction is null, returning null");
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("checking property restriction of property " + propertyId);
            }
            if ((property = environment.getProperty(propertyId)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("property " + propertyId + " is not registered, returning null");
                }
                return null;
            }
            AclResourcePropertyCondition condition = environment.getCondition(conditionId);
            if (condition == null) {
                if (log.isDebugEnabled()) {
                    log.debug("condition " + conditionId + " is not registered, returning null");
                }
                return null;
            }
            if (property instanceof AclQueryable) {
                SearchCriterion criterion;
                if (log.isDebugEnabled()) {
                    log.debug("property " + property.getId() + " is quaryable");
                }
                if ((criterion = ((AclQueryable)((Object)property)).getQuery(condition, propertyRestriction.getValue(), userId)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("criterion of property " + property.getId() + " is not empty");
                    }
                    if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE) {
                        return criterion;
                    }
                    if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
                        return SearchCriterion.not(criterion);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("property restriction group " + (Object)((Object)propertyRestrictionGroup.getType()) + " is not supported, returning null");
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug("criterion of property " + property.getId() + " is empty, returning null");
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("property " + property.getId() + " is not quaryable, returning null");
            }
            return null;
        }
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.AND) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (AclPropertyRestrictionGroup group : (List)propertyRestrictionGroup.getValue()) {
                SearchCriterion criterion = AclHelper.getCriterion(group, userId);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            if (log.isDebugEnabled()) {
                log.debug("property restriction group " + (Object)((Object)propertyRestrictionGroup.getType()) + " collects " + String.valueOf(criterions.size()) + " criterions");
            }
            return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.OR) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (AclPropertyRestrictionGroup group : (List)propertyRestrictionGroup.getValue()) {
                SearchCriterion criterion = AclHelper.getCriterion(group, userId);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            if (log.isDebugEnabled()) {
                log.debug("property restriction group " + (Object)((Object)propertyRestrictionGroup.getType()) + " collects " + String.valueOf(criterions.size()) + " criterions");
            }
            return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        if (log.isDebugEnabled()) {
            log.debug("property restriction group " + (Object)((Object)propertyRestrictionGroup.getType()) + " is not supported, returning null");
        }
        return null;
    }

    private static void requireNonNull(Object object, Supplier<String> errorMessageSupplier) throws Exception {
        if (object != null) {
            return;
        }
        String errorMessage = errorMessageSupplier.get();
        if (log.isErrorEnabled()) {
            log.error(errorMessage);
        }
        throw new Exception(errorMessage);
    }

    public static String createCompoundId(String parentId, String resourceId) {
        return String.format("%s-%s", parentId, resourceId);
    }

    public static String createPermission(String key, RestrictionResourceOperation operation) {
        return AclHelper.createPermission(key, operation.getId());
    }

    public static String createPermission(String key, String operationId) {
        return key + "_" + operationId.toLowerCase();
    }

    public static boolean isForOperation(String permission, RestrictionResourceOperation operation) {
        return AclHelper.isForOperation(permission, operation.getId());
    }

    public static boolean isForOperation(String permission, String operationId) {
        return permission != null && permission.endsWith("_" + operationId.toLowerCase());
    }

    static {
        all.setId("all");
        all.setName(L10n.get(Messages.AclHelper_allUsersAndGroups));
        all.setDescription(L10n.get(Messages.AclHelper_allUsersAndGroups));
        all.setParentId(null);
        administators.setId("administrators");
        administators.setName(L10n.get(Messages.AclHelper_administrators));
        administators.setDescription(L10n.get(Messages.AclHelper_administrators));
        administators.setParentId(all.getId());
        system.setId("system");
        system.setName(L10n.get(Messages.AclHelper_system));
        system.setDescription(L10n.get(Messages.AclHelper_system));
        system.getGroupIds().add(administators.getId());
        admin.setId("admin");
        admin.setName(L10n.get(Messages.AclHelper_administrator));
        admin.setDescription(L10n.get(Messages.AclHelper_administrator));
        admin.getGroupIds().add(administators.getId());
        principalComparator = new Comparator<AclPrincipal>(){

            @Override
            public int compare(AclPrincipal o1, AclPrincipal o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                if (o1 instanceof AclGroup && o2 instanceof AclUser) {
                    return -1;
                }
                if (o1 instanceof AclUser && o2 instanceof AclGroup) {
                    return 1;
                }
                if (o1 instanceof AclGroup && o2 instanceof AclGroup) {
                    return groupComparator.compare((AclGroup)o1, (AclGroup)o2);
                }
                if (o1 instanceof AclUser && o2 instanceof AclUser) {
                    return userComparator.compare((AclUser)o1, (AclUser)o2);
                }
                return MiscUtil.compare(o1.getName(), o2.getName());
            }
        };
        groupComparator = new Comparator<AclGroup>(){

            @Override
            public int compare(AclGroup o1, AclGroup o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                if (o1.equals(all)) {
                    return o2.equals(all) ? 0 : -1;
                }
                if (o2.equals(all)) {
                    return o1.equals(all) ? 0 : 1;
                }
                if (o1.equals(administators)) {
                    return o2.equals(administators) ? 0 : -1;
                }
                if (o2.equals(administators)) {
                    return o1.equals(administators) ? 0 : 1;
                }
                return MiscUtil.compare(o1.getName() != null ? o1.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null, o2.getName() != null ? o2.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null);
            }
        };
        userComparator = new Comparator<AclUser>(){

            @Override
            public int compare(AclUser o1, AclUser o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                if (o1.equals(system)) {
                    return o2.equals(system) ? 0 : -1;
                }
                if (o2.equals(system)) {
                    return o1.equals(system) ? 0 : 1;
                }
                if (o1.equals(admin)) {
                    return o2.equals(admin) ? 0 : -1;
                }
                if (o2.equals(admin)) {
                    return o1.equals(admin) ? 0 : 1;
                }
                return MiscUtil.compare(o1.getName() != null ? o1.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null, o2.getName() != null ? o2.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null);
            }
        };
    }

    public static class SearchQueryData {
        private SearchCriterion criterion;
        private final List<String> fields = new ArrayList<String>();

        public void setCriterion(SearchCriterion criterion) {
            this.criterion = criterion;
        }

        public SearchCriterion getCriterion() {
            return this.criterion;
        }

        public List<String> getFields() {
            return this.fields;
        }
    }
}

