/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.helper;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(AclRulesHelper.class);
    private static final SearchCriterion EMPTY_RESULT_CRITERION = SearchCriterion.eq("containerUid", null);

    public static <E> boolean isEquals(E data, E value) {
        return MiscUtil.equals(data, value);
    }

    public static <E> boolean isEquals(Collection<E> data, E value) {
        return data.contains(value);
    }

    public static <E> boolean isIncludes(E data, Collection<E> values) {
        return values.contains(data);
    }

    public static <E> boolean isIncludes(Collection<E> data, Collection<E> values) {
        for (E value : values) {
            if (!data.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWithin(Date date, DateInterval interval) {
        return MiscUtil.isBetween(interval.getBeginDate(), interval.getEndDate(), date);
    }

    public static boolean isToday(Date date) {
        Calendar calendar = Calendar.getInstance();
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return AclRulesHelper.isWithin(date, dateInterval);
    }

    public static boolean isYesterday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return AclRulesHelper.isWithin(date, dateInterval);
    }

    public static boolean isCurrentDecade(Date date) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(1), MiscUtil.getEndDecade(1));
        return AclRulesHelper.isWithin(date, dateInterval);
    }

    public static boolean isLastDecade(Date date) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(2), MiscUtil.getEndDecade(2));
        return AclRulesHelper.isWithin(date, dateInterval);
    }

    public static <E> boolean isNull(E data) {
        return data == null;
    }

    public static <E> boolean isNull(Collection<E> data) {
        return data.isEmpty();
    }

    public static SearchCriterion createEqualsCriterion(String propertyId, Object value) {
        return SearchCriterion.eq(propertyId, value);
    }

    public static SearchCriterion createNotEqualsCriterion(String propertyId, Object value) {
        return SearchCriterion.ne(propertyId, value);
    }

    public static SearchCriterion createIncludesCriterion(String propertyId, Iterable<?> iterable, boolean collection) {
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_RESULT_CRITERION;
        }
        while (iterator.hasNext()) {
            if (collection) {
                criterions.add(SearchCriterion.contains(propertyId, iterator.next()));
                continue;
            }
            criterions.add(SearchCriterion.eq(propertyId, iterator.next()));
        }
        return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createNotIncludesCriterion(String propertyId, Iterable<?> iterable, boolean collection) {
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_RESULT_CRITERION;
        }
        while (iterator.hasNext()) {
            if (collection) {
                criterions.add(SearchCriterion.not(SearchCriterion.contains(propertyId, iterator.next())));
                continue;
            }
            criterions.add(SearchCriterion.ne(propertyId, iterator.next()));
        }
        return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createPeriodWithinCriterion(String propertyId, DateInterval dateInterval) {
        if (dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
            return null;
        }
        if (dateInterval.getBeginDate() == null) {
            return SearchCriterion.le(propertyId, dateInterval.getEndDate());
        }
        if (dateInterval.getEndDate() == null) {
            return SearchCriterion.ge(propertyId, dateInterval.getBeginDate());
        }
        return SearchCriterion.and(SearchCriterion.ge(propertyId, dateInterval.getBeginDate()), SearchCriterion.le(propertyId, dateInterval.getEndDate()));
    }

    public static SearchCriterion createPeriodBeyondCriterion(String propertyId, DateInterval dateInterval) {
        if (dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
            return null;
        }
        if (dateInterval.getBeginDate() == null) {
            return SearchCriterion.gt(propertyId, dateInterval.getEndDate());
        }
        if (dateInterval.getEndDate() == null) {
            return SearchCriterion.lt(propertyId, dateInterval.getBeginDate());
        }
        return SearchCriterion.or(SearchCriterion.lt(propertyId, dateInterval.getBeginDate()), SearchCriterion.gt(propertyId, dateInterval.getEndDate()));
    }

    public static SearchCriterion createTodayCriterion(String propertyId) {
        Calendar calendar = Calendar.getInstance();
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return AclRulesHelper.createPeriodWithinCriterion(propertyId, dateInterval);
    }

    public static SearchCriterion createYesterdayCriterion(String propertyId) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return AclRulesHelper.createPeriodWithinCriterion(propertyId, dateInterval);
    }

    public static SearchCriterion createCurrentDecadeCriterion(String propertyId) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(1), MiscUtil.getEndDecade(1));
        return AclRulesHelper.createPeriodWithinCriterion(propertyId, dateInterval);
    }

    public static SearchCriterion createLastDecadeCriterion(String propertyId) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(2), MiscUtil.getEndDecade(2));
        return AclRulesHelper.createPeriodWithinCriterion(propertyId, dateInterval);
    }

    public static SearchCriterion createIsNullCriterion(String propertyId, boolean collection) {
        if (collection) {
            return SearchCriterion.eq(propertyId, "");
        }
        return SearchCriterion.eq(propertyId, null);
    }

    public static SearchCriterion createIsNotNullCriterion(String propertyId, boolean collection) {
        if (collection) {
            return SearchCriterion.ne(propertyId, "");
        }
        return SearchCriterion.ne(propertyId, null);
    }

    public static String getInfo(String name, AclResourcePropertyCondition condition, Object object) {
        if (object instanceof String) {
            return AclRulesHelper.getInfo(name, condition, (String)object);
        }
        if (object instanceof Iterable) {
            return AclRulesHelper.getInfo(name, condition, (Iterable)object);
        }
        if (object instanceof Date) {
            return AclRulesHelper.getInfo(name, condition, (Date)object);
        }
        if (object instanceof DateInterval) {
            return AclRulesHelper.getInfo(name, condition, (DateInterval)object);
        }
        if (object == null) {
            return String.format("%s %s", name, condition.getName());
        }
        return String.format("%s %s %s", name, condition.getName(), object.toString());
    }

    public static String getInfo(String name, AclResourcePropertyCondition condition, String value) {
        return String.format("%s %s %s", name, condition.getName(), value);
    }

    public static String getInfo(String name, AclResourcePropertyCondition condition, Iterable<?> value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object iterable : value) {
            if (iterable == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iterable);
        }
        return String.format("%s %s %s", name, condition.getName(), stringBuilder.toString());
    }

    public static String getInfo(String name, AclResourcePropertyCondition condition, Date value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId()) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
            return String.format("%s %s %s", name, condition.getName(), dateFormat.format(value));
        }
        return null;
    }

    public static String getInfo(String name, AclResourcePropertyCondition condition, DateInterval value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(condition.getId())) {
            if (value != null) {
                if (value.getBeginDate() != null && value.getEndDate() == null) {
                    return String.format(L10n.get(Messages.AclRulesHelper_after), name, dateFormat.format(value.getBeginDate()));
                }
                if (value.getBeginDate() == null && value.getEndDate() != null) {
                    return String.format(L10n.get(Messages.AclRulesHelper_before), name, dateFormat.format(value.getEndDate()));
                }
                return String.format(L10n.get(Messages.AclRulesHelper_fromTill), name, value.getBeginDate() != null ? dateFormat.format(value.getBeginDate()) : null, value.getEndDate() != null ? dateFormat.format(value.getEndDate()) : null);
            }
            return String.format(L10n.get(Messages.AclRulesHelper_fromTill), name, null, null);
        }
        if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(condition.getId())) {
            if (value != null) {
                if (value.getBeginDate() != null && value.getEndDate() == null) {
                    return String.format(L10n.get(Messages.AclRulesHelper_before), name, dateFormat.format(value.getBeginDate()));
                }
                if (value.getBeginDate() == null && value.getEndDate() != null) {
                    return String.format(L10n.get(Messages.AclRulesHelper_after), name, dateFormat.format(value.getEndDate()));
                }
                return String.format(L10n.get(Messages.AclRulesHelper_notFromTill), name, value.getBeginDate() != null ? dateFormat.format(value.getBeginDate()) : null, value.getEndDate() != null ? dateFormat.format(value.getEndDate()) : null);
            }
            return String.format(L10n.get(Messages.AclRulesHelper_notFromTill), name, null, null);
        }
        return null;
    }

    public static List<String> toStringList(Iterable<?> value, Class<?> type) {
        ArrayList<String> stringList = new ArrayList<String>();
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            if (String.class.isAssignableFrom(type)) {
                stringList.add((String)iterator.next());
                continue;
            }
            if (type.isEnum()) {
                stringList.add(((Enum)iterator.next()).name());
                continue;
            }
            if (BaseDictionary.class.isAssignableFrom(type)) {
                stringList.add(((DictionaryReference)iterator.next()).getCode());
                continue;
            }
            if (!BaseEntity.class.isAssignableFrom(type)) continue;
            stringList.add(((EntityReference)iterator.next()).getUid());
        }
        return stringList;
    }
}

