/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.resource.AclEntityResource;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.resource.AclResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclFieldRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAclPermissionsHelper {
    private static final Logger log = LoggerFactory.getLogger(StandardAclPermissionsHelper.class);

    public static AclResourceOperationPermission getPermission(AclResourceProxy proxy, String resourceId, String userId, String operationId) throws Exception {
        log.debug(String.format("checking %s permission of principal %s on resource %s using proxy %s", operationId, userId, resourceId, proxy != null ? String.format("of resource %s", proxy.getResourceId()) : null));
        if (resourceId == null) {
            log.debug(String.format("resource id is null, permission is null", new Object[0]));
            return null;
        }
        if (userId == null) {
            log.debug(String.format("user id is null, permission is null", new Object[0]));
            return null;
        }
        if (operationId == null) {
            log.debug(String.format("operation id is null, permission is null", new Object[0]));
            return null;
        }
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        if (environment.getResource(resourceId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource %s is not registered, checking meta registry", resourceId));
            }
            resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
            while (resourceId != null) {
                log.debug(String.format("checking meta resource %s", resourceId));
                if (environment.getResource(resourceId) != null) break;
                log.debug(String.format("meta resource %s is not registered", resourceId));
                resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
                log.debug(String.format("using super resource %s", resourceId));
            }
            if (resourceId == null) {
                if (log.isDebugEnabled()) {
                    log.debug("resources is not registered, permission is null");
                }
                return null;
            }
        }
        if (AclHelper.getUser(userId) == null) {
            log.debug(String.format("user %s is not registered, permission is null", userId));
            return null;
        }
        if (environment.getOperation(operationId) == null) {
            log.debug(String.format("operation %s is not registered, permission is null", operationId));
            return null;
        }
        log.debug(String.format("checking resources", new Object[0]));
        ArrayList<String> deniedGroups = new ArrayList<String>();
        while (resourceId != null) {
            log.debug(String.format("checking resource %s", resourceId));
            if (environment.getResource(resourceId) == null) {
                log.debug(String.format("resource %s is not registered, permission is null", resourceId));
                return null;
            }
            AclResourceOperationPermission permission = StandardAclPermissionsHelper.getPermission2(proxy, resourceId, userId, operationId, deniedGroups);
            if (permission != null) {
                log.debug(String.format("permission %s for resource %s found", permission.name(), resourceId));
                return permission;
            }
            log.debug(String.format("permission for resource %s not found", resourceId));
            resourceId = environment.getResourceParent(resourceId);
            log.debug(String.format("using parent resource %s", resourceId));
        }
        return null;
    }

    private static AclResourceOperationPermission getPermission2(AclResourceProxy proxy, String resourceId, String userId, String operationId, List<String> deniedGroups) throws Exception {
        log.debug(String.format("checking principals", new Object[0]));
        log.debug(String.format("checking user", new Object[0]));
        log.debug(String.format("checking user %s", userId));
        if (AclHelper.getUser(userId) == null) {
            log.debug(String.format("user %s is not registered, permission is null", userId));
            return null;
        }
        log.debug(String.format("searching entry for resource %s and user %s", resourceId, userId));
        AclEntry entry = AclHelper.getEntry(resourceId, userId);
        if (entry != null) {
            log.debug(String.format("entry for resource %s and user %s found", resourceId, userId));
            AclResourceOperationPermission userPermission = StandardAclPermissionsHelper.getPermission(proxy, entry.getRules(), resourceId, userId, operationId);
            if (userPermission != null) {
                log.debug(String.format("permission %s for user %s found", userPermission.name(), userId));
                return userPermission;
            }
            log.debug(String.format("permission for user %s not found", userId));
        } else {
            log.debug(String.format("entry for resource %s and user %s not found", resourceId, userId));
        }
        ArrayList<String> checkedGroups = new ArrayList<String>();
        boolean undefinedRootPermissionFound = false;
        log.debug(String.format("checking groups", new Object[0]));
        block0: for (AclGroup group : AclHelper.getUserGroups(userId)) {
            while (group != null) {
                String groupId = group.getId();
                log.debug(String.format("checking group %s", groupId));
                if (deniedGroups.contains(groupId)) {
                    log.debug(String.format("group %s was already denied, skipping group", groupId));
                    continue block0;
                }
                if (checkedGroups.contains(groupId)) {
                    log.debug(String.format("group %s was already checked, skipping group", groupId));
                    continue block0;
                }
                checkedGroups.add(groupId);
                log.debug(String.format("searching entry for resource %s and group %s", resourceId, groupId));
                entry = AclHelper.getEntry(resourceId, groupId);
                if (entry != null) {
                    log.debug(String.format("entry for resource %s and group %s found", resourceId, groupId));
                    AclResourceOperationPermission groupPermission = StandardAclPermissionsHelper.getPermission(proxy, entry.getRules(), resourceId, userId, operationId);
                    if (groupPermission != null) {
                        log.debug(String.format("permission %s for group %s found", groupPermission.name(), groupId));
                        if (groupPermission == AclResourceOperationPermission.GRANT) {
                            return groupPermission;
                        }
                        deniedGroups.add(groupId);
                        continue block0;
                    }
                    log.debug(String.format("permission for group %s not found", groupId));
                } else {
                    log.debug(String.format("entry for resource %s and group %s not found", resourceId, groupId));
                }
                group = AclHelper.getGroupParent(groupId);
                log.debug(String.format("using parent group %s", group != null ? group.getId() : null));
            }
            undefinedRootPermissionFound = true;
        }
        return undefinedRootPermissionFound ? null : AclResourceOperationPermission.DENY;
    }

    public static AclResourceOperationPermission getPermission(AclResourceProxy proxy, List<AclRule> rules, String resourceId, String userId, String operationId) throws Exception {
        log.debug(String.format("checking rules", new Object[0]));
        block0: for (AclRule rule : rules) {
            for (AclAction action : rule.getActions()) {
                AclResource resource;
                if (!action.getOperationId().equals(operationId) && !action.getOperationId().equals(StandardAclResourceOperations.ALL.getId())) continue;
                AclResourceOperationPermission permission = action.getPermission();
                log.debug(String.format("permission %s for operation %s found", permission.name(), operationId));
                if (proxy != null) {
                    log.debug(String.format("checking property restriction groups", new Object[0]));
                    for (AclPropertyRestrictionGroup propertyRestrictionGroup : rule.getPropertyRestrictionGroups()) {
                        Boolean match = StandardAclPermissionsHelper.getMatch(proxy, propertyRestrictionGroup, userId, operationId);
                        if (match == null) continue;
                        if (!match.booleanValue()) {
                            log.debug(String.format("property restriction group %s is not matched", new Object[]{propertyRestrictionGroup.getType()}));
                            continue block0;
                        }
                        log.debug(String.format("property restriction group %s is matched", new Object[]{propertyRestrictionGroup.getType()}));
                    }
                } else if (rule.getPropertyRestrictionGroups().size() > 0 && (resource = Environment.getPublished(AclResourcesEnvironment.class).getResource(resourceId)) != null && resource instanceof AclEntityResource) {
                    return null;
                }
                return permission;
            }
        }
        return null;
    }

    private static Boolean getMatch(AclResourceProxy proxy, AclPropertyRestrictionGroup propertyRestrictionGroup, String userId, String operationId) throws Exception {
        log.debug(String.format("checking property restriction group %s", new Object[]{propertyRestrictionGroup.getType()}));
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE || propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
            AclPropertyRestriction propertyRestriction = (AclPropertyRestriction)propertyRestrictionGroup.getValue();
            String propertyId = propertyRestriction.getPropertyId();
            if (propertyId == null) {
                log.debug(String.format("property id of property restriction is null, returning null", new Object[0]));
                return null;
            }
            String conditionId = propertyRestriction.getConditionId();
            if (conditionId == null) {
                log.debug(String.format("condition id of property restriction is null, returning null", new Object[0]));
                return null;
            }
            log.debug(String.format("checking property restriction of property %s", propertyId));
            AclResourceProperty property = environment.getProperty(propertyId);
            if (property == null) {
                log.debug(String.format("property %s is not registered, returning null", propertyId));
                return null;
            }
            AclResourcePropertyCondition condition = environment.getCondition(conditionId);
            if (condition == null) {
                log.debug(String.format("condition %s is not registered, returning null", conditionId));
                return null;
            }
            if (property instanceof AclMatchable) {
                log.debug(String.format("property %s is matchable", property.getId()));
                log.debug(String.format("checking proxies", new Object[0]));
                for (AclResourceProxy parentProxy = proxy; parentProxy != null; parentProxy = parentProxy.getParent()) {
                    log.debug(String.format("checking proxy of resource %s", parentProxy.getResourceId()));
                    if (property.getResourceId().equals(parentProxy.getResourceId())) {
                        log.debug(String.format("proxy of resource %s conforms property %s", parentProxy.getResourceId(), property.getId()));
                        boolean match = ((AclMatchable)((Object)property)).match(parentProxy, condition, propertyRestriction.getValue(), userId);
                        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE && match || propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT && !match) {
                            log.debug(String.format("proxy for property %s is matched", property.getId()));
                            return Boolean.TRUE;
                        }
                        log.debug(String.format("proxy for property %s is not matched", property.getId()));
                        return Boolean.FALSE;
                    }
                    log.debug(String.format("proxy of resource %s not conforms property %s", parentProxy.getResourceId(), property.getId()));
                    log.debug(String.format("using parent proxy %s", parentProxy != null ? String.format("of resource %s", parentProxy.getResourceId()) : null));
                }
                log.error(String.format("proxy of resource %s conforming property %s not found", property.getResourceId(), property.getId()));
                throw new Exception(String.format("proxy of resource %s conforming property %s not found", property.getResourceId(), property.getId()));
            }
            log.debug(String.format("property %s is not matchable", property.getId()));
            return null;
        }
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.AND) {
            Boolean result = null;
            for (AclPropertyRestrictionGroup group : (List)propertyRestrictionGroup.getValue()) {
                Boolean match = StandardAclPermissionsHelper.getMatch(proxy, group, userId, operationId);
                if (match == null) continue;
                Boolean bl = result != null ? Boolean.valueOf(result != false && match != false) : (result = match);
                if (match.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return result;
        }
        if (propertyRestrictionGroup.getType() == AclPropertyRestrictionGroupType.OR) {
            Boolean result = null;
            for (AclPropertyRestrictionGroup group : (List)propertyRestrictionGroup.getValue()) {
                Boolean match = StandardAclPermissionsHelper.getMatch(proxy, group, userId, operationId);
                if (match == null) continue;
                Boolean bl = result != null ? Boolean.valueOf(result != false || match != false) : (result = match);
                if (!match.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return result;
        }
        return null;
    }

    public static AclHelper.SearchQueryData getSearchQueryData(String resourceId, String userId) throws Exception {
        log.debug(String.format("retrieving criterions for principal %s on resource %s", userId, resourceId));
        if (resourceId == null) {
            log.debug(String.format("resource id is null, returning null", new Object[0]));
            return null;
        }
        if (userId == null) {
            log.debug(String.format("user id is null, returning null", new Object[0]));
            return null;
        }
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        if (environment.getResource(resourceId) == null) {
            log.debug(String.format("resource %s is not registered, returning null", resourceId));
            return null;
        }
        if (AclHelper.getUser(userId) == null) {
            log.debug(String.format("user %s is not registered, returning null", userId));
            return null;
        }
        log.debug(String.format("checking resource %s", resourceId));
        return StandardAclPermissionsHelper.getSearchQueryData2(resourceId, userId);
    }

    private static AclHelper.SearchQueryData getSearchQueryData2(String resourceId, String userId) throws Exception {
        log.debug(String.format("checking principals", new Object[0]));
        log.debug(String.format("checking user", new Object[0]));
        log.debug(String.format("checking user %s", userId));
        if (AclHelper.getUser(userId) == null) {
            log.debug(String.format("user %s is not registered, returning null", userId));
            return null;
        }
        log.debug(String.format("searching entry for resurce %s and user %s", resourceId, userId));
        AclEntry entry = AclHelper.getEntry(resourceId, userId);
        if (entry != null) {
            log.debug(String.format("entry for resource %s and user %s found", resourceId, userId));
            return StandardAclPermissionsHelper.getSearchQueryData(entry.getRules(), userId);
        }
        log.debug(String.format("entry for resource %s and user %s not found", resourceId, userId));
        ArrayList<SearchCriterion> groupsCriterions = new ArrayList<SearchCriterion>();
        ArrayList<List<String>> groupsFields = new ArrayList<List<String>>();
        ArrayList<String> checkedGroups = new ArrayList<String>();
        boolean groupQueryDataFound = false;
        log.debug(String.format("checking groups", new Object[0]));
        block0: for (AclGroup group : AclHelper.getUserGroups(userId)) {
            while (group != null) {
                String groupId = group.getId();
                log.debug(String.format("checking group %s", groupId));
                if (AclHelper.getGroup(groupId) == null) {
                    log.debug(String.format("group %s is not registered, skipping group", groupId));
                    continue block0;
                }
                if (checkedGroups.contains(groupId)) {
                    log.debug(String.format("group %s was already checked, skipping group", groupId));
                    continue block0;
                }
                checkedGroups.add(groupId);
                log.debug(String.format("searching entry for resource %s and group %s", resourceId, groupId));
                entry = AclHelper.getEntry(resourceId, groupId);
                if (entry != null) {
                    log.debug(String.format("entry for resource %s and group %s found", resourceId, groupId));
                    AclHelper.SearchQueryData groupSearchQueryData = StandardAclPermissionsHelper.getSearchQueryData(entry.getRules(), userId);
                    groupsCriterions.add(groupSearchQueryData.getCriterion());
                    groupsFields.add(groupSearchQueryData.getFields());
                    groupQueryDataFound = true;
                    continue block0;
                }
                log.debug(String.format("entry for resource %s and group %s not found", resourceId, groupId));
                group = AclHelper.getGroupParent(groupId);
                log.debug(String.format("using parent group %s", group != null ? group.getId() : null));
            }
        }
        if (groupQueryDataFound) {
            AclHelper.SearchQueryData queryData = new AclHelper.SearchQueryData();
            queryData.setCriterion(SearchCriterion.or(groupsCriterions.toArray(new SearchCriterion[groupsCriterions.size()])));
            if (!groupsFields.isEmpty()) {
                ArrayList fields = new ArrayList();
                fields.addAll((Collection)groupsFields.get(0));
                for (int i = 1; i < groupsFields.size(); ++i) {
                    fields.retainAll((Collection)groupsFields.get(i));
                }
                queryData.getFields().addAll(fields);
            }
            return queryData;
        }
        return null;
    }

    private static AclHelper.SearchQueryData getSearchQueryData(List<AclRule> rules, String userId) throws Exception {
        log.debug(String.format("checking rules", new Object[0]));
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        ArrayList<String> fields = new ArrayList<String>();
        for (AclRule rule : rules) {
            for (AclPropertyRestrictionGroup propertyRestrictionGroup : rule.getPropertyRestrictionGroups()) {
                SearchCriterion criterion = AclHelper.getCriterion(propertyRestrictionGroup, userId);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            for (AclFieldRestriction fieldRestriction : rule.getFieldRestrictions()) {
                if (fields.contains(fieldRestriction.getFieldId())) continue;
                fields.add(fieldRestriction.getFieldId());
            }
        }
        AclHelper.SearchQueryData queryData = new AclHelper.SearchQueryData();
        queryData.setCriterion(SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()])));
        queryData.getFields().addAll(fields);
        return queryData;
    }

    public static Collection<AclRule> getRules(String resourceId, String userId) {
        ArrayList<AclRule> rules = new ArrayList<AclRule>();
        Collection<AclGroup> groups = StandardAclPermissionsHelper.getAllUserGroups(userId);
        AclEntry userEntry = AclHelper.getEntry(resourceId, userId);
        if (userEntry != null) {
            rules.addAll(userEntry.getRules());
        }
        for (AclGroup group : groups) {
            AclEntry groupEntry = AclHelper.getEntry(resourceId, group.getId());
            if (groupEntry == null) continue;
            rules.addAll(groupEntry.getRules());
        }
        return rules;
    }

    public static Collection<AclGroup> getAllUserGroups(String userId) {
        HashSet<AclGroup> groups = new HashSet<AclGroup>();
        Collection<AclGroup> directGroups = AclHelper.getUserGroups(userId);
        groups.addAll(directGroups);
        for (AclGroup group : directGroups) {
            groups.addAll(StandardAclPermissionsHelper.getAllParentGroups(group));
        }
        return groups;
    }

    private static Collection<AclGroup> getAllParentGroups(AclGroup currentGroup) {
        if (currentGroup == null) {
            return Collections.emptyList();
        }
        HashSet<AclGroup> parentGroups = new HashSet<AclGroup>();
        String currentGroupId = currentGroup.getId();
        String parentGroupId = null;
        do {
            if (!StringUtils.isNotBlank((String)currentGroupId)) continue;
            AclGroup parentGroup = AclHelper.getGroupParent(currentGroupId);
            if (parentGroup != null && StringUtils.isNotBlank((String)parentGroup.getId())) {
                parentGroups.add(parentGroup);
                currentGroupId = parentGroup.getId();
                parentGroupId = parentGroup.getParentId();
                continue;
            }
            parentGroupId = null;
        } while (StringUtils.isNotBlank(parentGroupId));
        return parentGroups;
    }
}

