/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.principal;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class AclUser
extends BaseAsset
implements AclPrincipal {
    private static final long serialVersionUID = -8619119499997295257L;
    private String id;
    private String name;
    private String description;
    private final List<String> groupIds = new ArrayList<String>();

    public AclUser() {
    }

    public AclUser(String uid) {
        super(uid);
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.id = XHelper.readString(elm, "id");
        this.name = XHelper.readString(elm, "name");
        this.description = XHelper.readString(elm, "description");
        this.groupIds.clear();
        for (Element groupElement : XmlUtil.getElements(elm, "groupIds/item")) {
            this.groupIds.add(XHelper.readString(groupElement, "."));
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("id".equals(tagName)) {
            this.id = XSHelper.readString(reader);
            return true;
        }
        if ("name".equals(tagName)) {
            this.name = XSHelper.readString(reader);
            return true;
        }
        if ("description".equals(tagName)) {
            this.description = XSHelper.readString(reader);
            return true;
        }
        if ("groupIds".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.groupIds.add(XSHelper.readString(reader));
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "id", this.id);
        XHelper.writeString(elm, "name", this.name);
        XHelper.writeString(elm, "description", this.description);
        for (String group : this.groupIds) {
            XHelper.writeString(elm, "groupIds/item", group);
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "id", this.id);
        XSHelper.writeString(writer, "name", this.name);
        XSHelper.writeString(writer, "description", this.description);
        if (!this.groupIds.isEmpty()) {
            writer.writeStartElement("groupIds");
            for (String group : this.groupIds) {
                XSHelper.writeString(writer, "item", group);
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        AclUser source = (AclUser)sourceAsset;
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.groupIds.clear();
        this.groupIds.addAll(XCloneHelper.cloneCollection(source.groupIds, newUids, uids));
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", this.id, this.name);
    }

    public static enum Property {
        id,
        name,
        description,
        groupIds;

    }
}

