/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.security.acl.resource.AclResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceField;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperation;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyRenderer;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxyBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class AclResourcesEnvironment {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Map<String, AclResource> resources = new HashMap<String, AclResource>();
    private final Map<String, Set<String>> parent2children = new HashMap<String, Set<String>>();
    private final Map<String, String> child2parent = new HashMap<String, String>();
    private final Map<String, AclResourceOperation> operations = new HashMap<String, AclResourceOperation>();
    private final Map<String, Set<String>> resource2operations = new HashMap<String, Set<String>>();
    private final Map<String, AclResourceProperty> properties = new HashMap<String, AclResourceProperty>();
    private final Map<String, Set<String>> resource2properties = new HashMap<String, Set<String>>();
    private final Map<String, AclResourcePropertyCondition> conditions = new HashMap<String, AclResourcePropertyCondition>();
    private final Map<String, Set<String>> property2conditions = new HashMap<String, Set<String>>();
    private final Map<String, AclResourcePropertyRenderer> renderers = new HashMap<String, AclResourcePropertyRenderer>();
    private final Map<String, AclResourceField> fields = new HashMap<String, AclResourceField>();
    private final Map<String, Set<String>> resource2fields = new HashMap<String, Set<String>>();
    private final Map<String, AclResourceProxyBuilder> proxyBuilders = new HashMap<String, AclResourceProxyBuilder>();
    private final Map<String, String> resource2proxyBuilder = new HashMap<String, String>();

    public static AclResourcesEnvironment get() {
        return Environment.getPublished(AclResourcesEnvironment.class);
    }

    public Collection<AclResource> getResources() {
        this.lock.lock();
        try {
            Collection<AclResource> collection = Collections.unmodifiableCollection(this.resources.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AclResource> getRootResources() {
        this.lock.lock();
        try {
            HashSet<AclResource> rootResources = new HashSet<AclResource>();
            for (AclResource resource : this.resources.values()) {
                if (this.child2parent.get(resource.getId()) != null) continue;
                rootResources.add(resource);
            }
            HashSet<AclResource> hashSet = rootResources;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResource getResource(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResource aclResource = this.resources.get(resourceId);
            return aclResource;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getResourceParent(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.child2parent.get(resourceId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceChildren(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> childrenIds = this.parent2children.get(resourceId);
            if (childrenIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(childrenIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceProperties(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.resource2properties.get(resourceId);
            if (propertyIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(propertyIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceFields(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> fieldIds = this.resource2fields.get(resourceId);
            if (fieldIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(fieldIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceOperations(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> operationIds = this.resource2operations.get(resourceId);
            if (operationIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(operationIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addResource(AclResource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.properties.get(resource.getId()) != null) {
                throw new IllegalArgumentException(String.format("resource with id %s already added", resource.getId()));
            }
            this.resources.put(resource.getId(), resource);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(AclResource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            String string;
            Set<String> set;
            Set<String> propertyIds;
            Set<String> operationIds = this.resource2operations.get(resource.getId());
            if (operationIds != null) {
                for (String string2 : operationIds) {
                    this.unregisterOperation(resource.getId(), string2);
                }
            }
            if ((propertyIds = this.resource2properties.get(resource.getId())) != null) {
                for (String string3 : propertyIds) {
                    this.unregisterProperty(resource.getId(), string3);
                }
            }
            if ((set = this.resource2fields.get(resource.getId())) != null) {
                for (String fieldId : set) {
                    this.unregisterField(resource.getId(), fieldId);
                }
            }
            if ((string = this.child2parent.get(resource.getId())) != null) {
                this.unregisterParent(resource.getId(), string);
            }
            this.properties.remove(resource.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerParent(String resourceId, String parentResourceId) {
        if (resourceId == null || parentResourceId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> childrenIds = this.parent2children.get(parentResourceId);
            if (childrenIds == null) {
                childrenIds = new HashSet<String>();
                this.parent2children.put(parentResourceId, childrenIds);
            }
            childrenIds.add(resourceId);
            this.child2parent.put(resourceId, parentResourceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterParent(String resourceId, String parentResourceId) {
        if (resourceId == null || parentResourceId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> childrenIds = this.parent2children.get(parentResourceId);
            if (childrenIds != null) {
                childrenIds.remove(resourceId);
            }
            this.child2parent.remove(resourceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registerChild(String resourceId, String childResourceId) {
        this.registerParent(childResourceId, resourceId);
    }

    public void unregisterChild(String resourceId, String childResourceId) {
        this.unregisterParent(childResourceId, resourceId);
    }

    public Collection<AclResourceOperation> getOperations() {
        this.lock.lock();
        try {
            Collection<AclResourceOperation> collection = Collections.unmodifiableCollection(this.operations.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourceOperation getOperation(String operationId) {
        if (operationId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourceOperation aclResourceOperation = this.operations.get(operationId);
            return aclResourceOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addOperation(AclResourceOperation operation) {
        if (operation == null || operation.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.operations.get(operation.getId()) != null) {
                throw new IllegalArgumentException(String.format("operation with id %s already added", operation.getId()));
            }
            this.operations.put(operation.getId(), operation);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperation(AclResourceOperation operation) {
        if (operation == null || operation.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            for (String resourceId : this.resource2operations.keySet()) {
                this.unregisterOperation(resourceId, operation.getId());
            }
            this.operations.remove(operation.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOperation(String resourceId, String operationId) {
        if (resourceId == null || operationId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> operationIds = this.resource2operations.get(resourceId);
            if (operationIds == null) {
                operationIds = new HashSet<String>();
                this.resource2operations.put(resourceId, operationIds);
            }
            operationIds.add(operationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOperation(String resourceId, String operationId) {
        if (resourceId == null || operationId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> operationIds = this.resource2operations.get(resourceId);
            if (operationIds != null) {
                operationIds.remove(operationId);
                if (operationIds.size() == 0) {
                    this.resource2operations.remove(resourceId);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<AclResourceProperty> getProperties() {
        this.lock.lock();
        try {
            Collection<AclResourceProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourceProperty getProperty(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourceProperty aclResourceProperty = this.properties.get(propertyId);
            return aclResourceProperty;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPropertyConditions(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> conditionIds = this.property2conditions.get(propertyId);
            if (conditionIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(conditionIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProperty(AclResourceProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.properties.get(property.getId()) != null) {
                throw new IllegalArgumentException(String.format("property with id %s already added", property.getId()));
            }
            this.properties.put(property.getId(), property);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(AclResourceProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            Iterator<String> it;
            String propertyId = property.getId();
            Set<String> conditionIds = this.property2conditions.get(propertyId);
            if (conditionIds != null) {
                it = conditionIds.iterator();
                while (it.hasNext()) {
                    String conditionId = it.next();
                    if (propertyId == null || conditionId == null) continue;
                    it.remove();
                    if (conditionIds.size() != 0) continue;
                    this.property2conditions.remove(propertyId);
                }
            }
            it = this.resource2properties.keySet().iterator();
            while (it.hasNext()) {
                Set<String> propertyIds;
                String resourceId = it.next();
                if (resourceId == null || propertyId == null || (propertyIds = this.resource2properties.get(resourceId)) == null) continue;
                propertyIds.remove(propertyId);
                if (propertyIds.size() != 0) continue;
                it.remove();
            }
            this.properties.remove(property.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProperty(String resourceId, String propertyId) {
        if (resourceId == null || propertyId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.resource2properties.get(resourceId);
            if (propertyIds == null) {
                propertyIds = new HashSet<String>();
                this.resource2properties.put(resourceId, propertyIds);
            }
            propertyIds.add(propertyId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProperty(String resourceId, String propertyId) {
        if (resourceId == null || propertyId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.resource2properties.get(resourceId);
            if (propertyIds != null) {
                propertyIds.remove(propertyId);
                if (propertyIds.size() == 0) {
                    this.resource2properties.remove(resourceId);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<AclResourcePropertyCondition> getConditions() {
        this.lock.lock();
        try {
            Collection<AclResourcePropertyCondition> collection = Collections.unmodifiableCollection(this.conditions.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourcePropertyCondition getCondition(String conditionId) {
        if (conditionId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourcePropertyCondition aclResourcePropertyCondition = this.conditions.get(conditionId);
            return aclResourcePropertyCondition;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCondition(AclResourcePropertyCondition condition) {
        if (condition == null || condition.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.conditions.get(condition.getId()) != null) {
                throw new IllegalArgumentException(String.format("condition with id %s already added", condition.getId()));
            }
            this.conditions.put(condition.getId(), condition);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCondition(AclResourcePropertyCondition condition) {
        if (condition == null || condition.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            for (String propertyId : this.property2conditions.keySet()) {
                this.unregisterCondition(propertyId, condition.getId());
            }
            this.conditions.remove(condition.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCondition(String propertyId, String conditionId) {
        if (propertyId == null || conditionId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> conditionIds = this.property2conditions.get(propertyId);
            if (conditionIds == null) {
                conditionIds = new HashSet<String>();
                this.property2conditions.put(propertyId, conditionIds);
            }
            conditionIds.add(conditionId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCondition(String propertyId, String conditionId) {
        if (propertyId == null || conditionId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> conditionIds = this.property2conditions.get(propertyId);
            if (conditionIds != null) {
                conditionIds.remove(conditionId);
                if (conditionIds.size() == 0) {
                    this.property2conditions.remove(propertyId);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<AclResourcePropertyRenderer> getRenderers() {
        this.lock.lock();
        try {
            Collection<AclResourcePropertyRenderer> collection = Collections.unmodifiableCollection(this.renderers.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourcePropertyRenderer getRenderer(String rendererId) {
        if (rendererId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourcePropertyRenderer aclResourcePropertyRenderer = this.renderers.get(rendererId);
            return aclResourcePropertyRenderer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRenderer(AclResourcePropertyRenderer renderer) {
        if (renderer == null || renderer.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.renderers.get(renderer.getId()) != null) {
                throw new IllegalArgumentException(String.format("renderer with id %s already added", renderer.getId()));
            }
            this.renderers.put(renderer.getId(), renderer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeRenderer(AclResourcePropertyRenderer renderer) {
        if (renderer == null || renderer.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.renderers.remove(renderer.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<AclResourceField> getFields() {
        this.lock.lock();
        try {
            Collection<AclResourceField> collection = Collections.unmodifiableCollection(this.fields.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourceField getField(String fieldId) {
        if (fieldId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourceField aclResourceField = this.fields.get(fieldId);
            return aclResourceField;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addField(AclResourceField field) {
        if (field == null || field.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.fields.get(field.getId()) != null) {
                throw new IllegalArgumentException(String.format("field with id %s already added", field.getId()));
            }
            this.fields.put(field.getId(), field);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeField(AclResourceField field) {
        if (field == null || field.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            for (String fieldId : this.resource2fields.keySet()) {
                this.unregisterField(fieldId, field.getId());
            }
            this.fields.remove(field.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerField(String resourceId, String fieldId) {
        if (resourceId == null || fieldId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> fieldIds = this.resource2fields.get(resourceId);
            if (fieldIds == null) {
                fieldIds = new HashSet<String>();
                this.resource2fields.put(resourceId, fieldIds);
            }
            fieldIds.add(fieldId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterField(String resourceId, String fieldId) {
        if (resourceId == null || fieldId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> fieldIds = this.resource2fields.get(resourceId);
            if (fieldIds != null) {
                fieldIds.remove(fieldId);
                if (fieldIds.size() == 0) {
                    this.resource2fields.remove(resourceId);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<AclResourceProxyBuilder> getProxyBuilders() {
        this.lock.lock();
        try {
            Collection<AclResourceProxyBuilder> collection = Collections.unmodifiableCollection(this.proxyBuilders.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AclResourceProxyBuilder getProxyBuilder(String proxyBuilderId) {
        if (proxyBuilderId == null) {
            return null;
        }
        this.lock.lock();
        try {
            AclResourceProxyBuilder aclResourceProxyBuilder = this.proxyBuilders.get(proxyBuilderId);
            return aclResourceProxyBuilder;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getResourceProxyBuilder(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.resource2proxyBuilder.get(resourceId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProxyBuilder(AclResourceProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.proxyBuilders.get(proxyBuilder.getId()) != null) {
                throw new IllegalArgumentException(String.format("proxy builder with id %s already added", proxyBuilder.getId()));
            }
            this.proxyBuilders.put(proxyBuilder.getId(), proxyBuilder);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyBuilder(AclResourceProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            for (String resourceId : this.resource2proxyBuilder.keySet()) {
                this.unregisterProxyBuilder(resourceId, proxyBuilder.getId());
            }
            this.proxyBuilders.remove(proxyBuilder.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registerProxyBuilder(String resourceId, String proxyBuilderId) {
        if (resourceId == null || proxyBuilderId == null) {
            return;
        }
        this.lock.lock();
        try {
            this.resource2proxyBuilder.put(resourceId, proxyBuilderId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unregisterProxyBuilder(String resourceId, String proxyBuilderId) {
        if (resourceId == null || proxyBuilderId == null) {
            return;
        }
        this.lock.lock();
        try {
            this.resource2proxyBuilder.remove(resourceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface Hook {
        public void environmentInitialized(AclResourcesEnvironment var1);
    }
}

