/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.threadactivity;

import com.gridnine.xtrip.common.ibus.LocalMessageContext;
import com.gridnine.xtrip.common.rpc.logging.ServiceInvocationLoggingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadActivityLog {
    private static final Logger logger = LoggerFactory.getLogger(ThreadActivityLog.class);
    private static long minDuration = 30000L;

    public static boolean isEnabled() {
        return logger.isDebugEnabled();
    }

    public static void setMinDuration(long value) {
        minDuration = value;
    }

    public static long getMinDuration() {
        return minDuration;
    }

    public static void beginRequest(String type, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getId() + "] beginRequest " + type + " " + name);
        }
    }

    public static void endRequest(String type, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getId() + "] endRequest " + type + " " + name);
        }
    }

    public static void reportMessage(String message) {
        if (logger.isInfoEnabled()) {
            logger.info("[" + Thread.currentThread().getId() + "] " + message);
        }
    }

    public static void reportStackTrace(String message) {
        if (logger.isInfoEnabled()) {
            String clientStacktrace;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(Thread.currentThread().getId());
            sb.append("] ");
            sb.append(message);
            for (int i = 2; i < stackTrace.length; ++i) {
                sb.append("\n\tat ").append(stackTrace[i].toString());
            }
            LocalMessageContext.Source ibus = LocalMessageContext.getLocalMessageContext();
            if (ibus != null) {
                StackTraceElement[] ibusStackTrace = ibus.getStackTrace();
                sb.append("\nbus:");
                for (int i = 0; i < ibusStackTrace.length; ++i) {
                    sb.append("\n\tat ").append(ibusStackTrace[i].toString());
                }
            }
            if ((clientStacktrace = ServiceInvocationLoggingHelper.getThreadLocalClientStacktrace()) != null) {
                sb.append("\nclient:\n").append(clientStacktrace);
            }
            logger.info(sb.toString());
        }
    }
}

