/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.tools;

import com.gridnine.xtrip.common.update.UpdateEntry;
import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.RandomUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class UpdateIndexAntTask
extends Task {
    private boolean verbose;
    private FileSet pluginsFileSet;
    private File indexFile;
    private File setupFile;
    private final List<FileSet> clientJRE = new ArrayList<FileSet>();
    private boolean compact;

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void addPluginsFileSet(FileSet set) {
        this.pluginsFileSet = set;
    }

    public void setIndexFile(File value) {
        this.indexFile = value;
    }

    public void setSetupFile(File value) {
        this.setupFile = value;
    }

    public void addClientJRE(FileSet set) {
        this.clientJRE.add(set);
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void execute() throws BuildException {
        if (this.pluginsFileSet == null) {
            throw new BuildException("Plugins files set required");
        }
        if (this.indexFile == null) {
            throw new BuildException("Index file attribute required");
        }
        if (this.indexFile.isDirectory()) {
            throw new BuildException("Index file attribute has to be a file rather than a directory " + this.indexFile);
        }
        if (this.setupFile != null && !this.setupFile.isFile()) {
            throw new BuildException("Setupe file not found " + this.setupFile);
        }
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            if (this.verbose) {
                this.log("Existing index file was deleted: " + this.indexFile.getName());
            }
        }
        try {
            UpdateIndexFile updateIndexFile = new UpdateIndexFile();
            if (this.setupFile != null) {
                updateIndexFile.setSetupFile(new UpdateFile(this.setupFile));
            }
            for (File file : this.collectFiles(this.clientJRE)) {
                UpdateFile pf = new UpdateFile(file);
                updateIndexFile.getClientJRE().add(pf);
                if (!this.verbose) continue;
                this.log("Including file " + pf.getName() + " to \"jre/client\" section");
            }
            for (File file : this.collectFiles(this.pluginsFileSet)) {
                String name = file.getName();
                UpdateFile pf = new UpdateFile(file);
                if (name.contains(".common")) {
                    updateIndexFile.getCommonPlugins().add(pf);
                    if (this.verbose) {
                        this.log("Including file " + pf.getName() + " to \"common\" section");
                    }
                } else if (name.contains(".server")) {
                    updateIndexFile.getServerPlugins().add(pf);
                    if (this.verbose) {
                        this.log("Including file " + pf.getName() + " to \"server\" section");
                    }
                } else if (name.contains(".client")) {
                    updateIndexFile.getClientPlugins().add(pf);
                    if (this.verbose) {
                        this.log("Including file " + pf.getName() + " to \"client\" section");
                    }
                }
                if (!this.compact) continue;
                this.processZip(pf, file);
            }
            updateIndexFile.updateCheckSums();
            updateIndexFile.setComment(RandomUtil.getRandomString(RandomUtil.Chars.LATIN_ALPHA_UPPER, 3, 20));
            updateIndexFile.saveToXml(this.indexFile);
        }
        catch (Exception e) {
            this.log(e, 0);
            throw new BuildException();
        }
        this.log("Index file was generated to " + this.indexFile.getName());
    }

    private void processZip(UpdateFile pf, File file) throws Exception {
        if (!file.getName().endsWith(".zip")) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.isDirectory()) {
                    InputStream in = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        pf.getEntries().add(new UpdateEntry(pf, zipEntry, in));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                        continue;
                    }
                }
                pf.getEntries().add(new UpdateEntry(pf, zipEntry, null));
            }
        }
    }

    private Collection<File> collectFiles(FileSet fileSet) {
        ArrayList<File> result = new ArrayList<File>();
        for (String file : fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
            result.add(FileUtils.getFileUtils().resolveFile(fileSet.getDir(this.getProject()), file));
        }
        return result;
    }

    private Collection<File> collectFiles(List<FileSet> fileSetList) {
        ArrayList<File> result = new ArrayList<File>();
        for (FileSet fileSet : fileSetList) {
            for (String file : fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                result.add(FileUtils.getFileUtils().resolveFile(fileSet.getDir(this.getProject()), file));
            }
        }
        return result;
    }
}

