/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.update.UpdateEntry;
import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.update.UpdateItem;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.LoggerFactory;

public final class RemoteUpdateHelper {
    public static File findFile(List<File> files, UpdateFile updateFile) throws Exception {
        try {
            for (File file : files) {
                if (!TextUtil.isSame(updateFile.getName(), file.getName()) || !MiscUtil.getCheckSum(IoUtil.file2url(file), true).equals(updateFile.getCheckSum())) continue;
                return file;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(RemoteUpdateHelper.class).error("unable to find local file corresponding to " + updateFile.getName(), (Throwable)e);
        }
        return null;
    }

    public static void updateFileSizes(UpdateIndexFile updateFile, File localRepository) throws Exception {
        List<File> localFiles = Arrays.asList(localRepository.listFiles());
        RemoteUpdateHelper.updateFileSizes(updateFile.getCommonPlugins(), localRepository, localFiles);
        RemoteUpdateHelper.updateFileSizes(updateFile.getClientPlugins(), localRepository, localFiles);
        RemoteUpdateHelper.updateFileSizes(updateFile.getServerPlugins(), localRepository, localFiles);
    }

    private static void updateFileSizes(List<UpdateFile> filesMetadata, File localRepository, List<File> localFiles) throws Exception {
        for (UpdateFile fileMetadata : filesMetadata) {
            File file;
            if (fileMetadata.getEntries() != null && !fileMetadata.getEntries().isEmpty()) {
                File pluginDir = new File(localRepository, FilenameUtils.getBaseName((String)fileMetadata.getName()));
                for (UpdateEntry entry : fileMetadata.getEntries()) {
                    File file2 = new File(pluginDir, entry.getName());
                    if (!file2.exists()) continue;
                    entry.setSize(file2.length());
                }
            }
            if ((file = RemoteUpdateHelper.findFile(localFiles, fileMetadata)) == null) continue;
            fileMetadata.setSize(file.length());
        }
    }

    private RemoteUpdateHelper() {
    }

    public static void collectModifiedFiles(List<File> localFileList, UpdateFile remoteFile, List<UpdateItem> filesToAdd, List<File> filesToRemove) throws Exception {
        String remoteDirectory = FilenameUtils.getBaseName((String)remoteFile.getName());
        for (File file : localFileList) {
            if (!TextUtil.isSame(remoteDirectory, file.getName())) continue;
            if (!file.isDirectory()) {
                for (UpdateEntry entry : remoteFile.getEntries()) {
                    filesToAdd.add(entry);
                }
                return;
            }
            filesToRemove.remove(file);
            ArrayList<File> entryFiles = new ArrayList<File>();
            for (UpdateEntry entry : remoteFile.getEntries()) {
                File entryFile = new File(file, entry.getName());
                entryFiles.add(entryFile);
                if (!entryFile.exists()) {
                    filesToAdd.add(entry);
                    continue;
                }
                if (entry.isDirectory()) {
                    if (entryFile.isDirectory()) continue;
                    filesToRemove.add(entryFile);
                    filesToAdd.add(entry);
                    continue;
                }
                if (MiscUtil.getCheckSum(IoUtil.file2url(entryFile), true).equals(entry.getCheckSum())) continue;
                filesToRemove.add(entryFile);
                filesToAdd.add(entry);
            }
            RemoteUpdateHelper.processDirectory(file, entryFiles, filesToRemove);
            return;
        }
        for (UpdateEntry entry : remoteFile.getEntries()) {
            filesToAdd.add(entry);
        }
    }

    private static void processDirectory(File file, Collection<File> entryFiles, List<File> filesToRemove) {
        for (File item : file.listFiles()) {
            if (!entryFiles.contains(item)) {
                filesToRemove.add(item);
                continue;
            }
            if (!item.isDirectory()) continue;
            RemoteUpdateHelper.processDirectory(item, entryFiles, filesToRemove);
        }
    }

    public static boolean idModifiedJRE(UpdateIndexFile remoteIndexFile, UpdateIndexFile localIndexFile) throws IOException {
        File home = new File(System.getProperty("java.home"));
        if (!new File(Environment.getRootFolder(), "jre").getCanonicalFile().equals(home.getCanonicalFile())) {
            return false;
        }
        if (remoteIndexFile.getClientJRE() == null || remoteIndexFile.getClientJRE().size() < 1) {
            return false;
        }
        if (localIndexFile.getClientJRE() == null || localIndexFile.getClientJRE().size() < 1) {
            return true;
        }
        return !MiscUtil.equals(localIndexFile.getClientJRE().get(0).getCheckSum(), remoteIndexFile.getClientJRE().get(0).getCheckSum());
    }
}

