/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DateTimeConverter;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeConverterTest {
    private static final String TIMEZONE_BERLIN_ID = "Europe/Berlin";
    private static final DateTimeZone TIMEZONE_BERLIN = DateTimeZone.forID((String)"Europe/Berlin");
    private static final DateTimeZone TIMEZONE_MOSCOW = DateTimeZone.forID((String)"Europe/Moscow");

    @Test
    public void convertTimeDoesntConvertIfTimeZoneIsNull() {
        this.convertTimeDoesntConvertIfTimeZoneIsNullTestLogic(null, null);
        this.convertTimeDoesntConvertIfTimeZoneIsNullTestLogic(null, DateTimeZone.UTC);
        this.convertTimeDoesntConvertIfTimeZoneIsNullTestLogic(DateTimeZone.UTC, null);
    }

    @Test
    public void testConversion() {
        DateTimeZone pccTimeZone = DateTimeZone.forID((String)"Europe/Vienna");
        Date timeInVienna = new DateTime(2015, 3, 12, 11, 30).toDate();
        DateTimeZone serverTimeZone = DateTimeZone.forID((String)"Europe/Moscow");
        Date expectedTimeInMoscow = new DateTime(2015, 3, 12, 13, 30).toDate();
        Date actualTimeInMoscow = DateTimeConverter.convertTime(timeInVienna, pccTimeZone, serverTimeZone);
        Assert.assertEquals((Object)expectedTimeInMoscow, (Object)actualTimeInMoscow);
    }

    protected void convertTimeDoesntConvertIfTimeZoneIsNullTestLogic(DateTimeZone timeZonePcc, DateTimeZone timeZoneServer) {
        Date originalDate = DateTime.now().toDate();
        Date result = DateTimeConverter.convertTime(originalDate, timeZonePcc, timeZoneServer);
        Assert.assertSame((Object)originalDate, (Object)result);
    }

    private void convertTimeReturnsOldDateIfNoTimezonesAreSpecifiedTestLogic(DateTimeZone serverTimeZone, DateTimeZone ticketingPccTimeZone) {
        Date sabreDateTime = new DateTime(2015, 3, 15, 12, 55).toDate();
        Date result = DateTimeConverter.convertTime(sabreDateTime, serverTimeZone, ticketingPccTimeZone);
        Assert.assertSame((Object)sabreDateTime, (Object)result);
    }

    @Test
    public void testDateTimeConversion() {
        Date sourceDateTime = new DateTime(2015, 3, 15, 12, 55, TIMEZONE_MOSCOW).toDate();
        Date expectedResult = new DateTime(2015, 3, 15, 10, 55, TIMEZONE_BERLIN).toLocalDateTime().toDate();
        DateTime timeInMoscow = new DateTime((Object)sourceDateTime, TIMEZONE_MOSCOW);
        DateTime timeInBerlin = timeInMoscow.toDateTime(TIMEZONE_BERLIN);
        Date actualResult = timeInBerlin.toLocalDateTime().toDate();
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void convertTimeReturnsOldDateIfNoTimezonesAreSpecified() {
        this.convertTimeReturnsOldDateIfNoTimezonesAreSpecifiedTestLogic(TIMEZONE_MOSCOW, null);
        this.convertTimeReturnsOldDateIfNoTimezonesAreSpecifiedTestLogic(null, TIMEZONE_BERLIN);
    }

    @Test
    public void convertTimeConvertsTimesCorrectly() {
        Date sabreDateTime = new DateTime(2015, 3, 15, 12, 55).toDate();
        Date result = DateTimeConverter.convertTime(sabreDateTime, TIMEZONE_MOSCOW, TIMEZONE_BERLIN);
        Assert.assertEquals((Object)new DateTime(2015, 3, 15, 10, 55).toDate(), (Object)result);
    }

    @Test
    public void converTimeDoesntConvertIfTimeZonesAreEqual() {
        Date sabreDateTime = new DateTime(2015, 3, 15, 12, 55, TIMEZONE_MOSCOW).toDate();
        Date result = DateTimeConverter.convertTime(sabreDateTime, TIMEZONE_MOSCOW, TIMEZONE_MOSCOW);
        Assert.assertSame((Object)sabreDateTime, (Object)result);
    }

    @Test
    public void convertTimeConvertsCorrectlyBetweenMoscowAndBerlin() {
        Date sabreDateTime = new Date(1426748160000L);
        Date actualResult = DateTimeConverter.convertTime(sabreDateTime, TIMEZONE_MOSCOW, TIMEZONE_BERLIN);
        Date expectedResult = new DateTime(sabreDateTime.getTime()).minusHours(2).toDate();
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void convertTimeDoesntThrowNpeIfSourceTimeIsNull() {
        Assert.assertNull((Object)DateTimeConverter.convertTime(null, TIMEZONE_MOSCOW, TIMEZONE_BERLIN));
        Assert.assertNull((Object)DateTimeConverter.convertDateTime(null, TIMEZONE_MOSCOW, TIMEZONE_BERLIN));
    }
}

