/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DoubleKeyMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DoubleKeyHashMap<K1, K2, V>
implements DoubleKeyMap<K1, K2, V>,
Serializable {
    private static final long serialVersionUID = 4739973503773199398L;
    private final Map<K1, Map<K2, V>> map = new HashMap<K1, Map<K2, V>>();

    @Override
    public void put(K1 key1, K2 key2, V value) {
        Map<K2, V> innerMap = this.map.get(key1);
        if (innerMap == null) {
            innerMap = new HashMap<K2, V>();
            this.map.put(key1, innerMap);
        }
        innerMap.put(key2, value);
    }

    @Override
    public Collection<V> getKey1Values(K1 key1) {
        Map<K2, V> innerMap = this.map.get(key1);
        if (innerMap == null) {
            return Collections.emptySet();
        }
        return innerMap.values();
    }

    @Override
    public Collection<V> getKey2Values(K2 key2) {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<K2, V> innerMap : this.map.values()) {
            values.add(innerMap.get(key2));
        }
        return values;
    }

    @Override
    public V get(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.map.get(key1);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    @Override
    public V remove(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.map.get(key1);
        if (innerMap == null) {
            return null;
        }
        V value = innerMap.remove(key2);
        if (innerMap.isEmpty()) {
            this.map.remove(key1);
        }
        return value;
    }

    @Override
    public Collection<V> removeKey1Values(K1 key1) {
        Map<K2, V> innerMap = this.map.remove(key1);
        if (innerMap == null) {
            return Collections.emptySet();
        }
        return innerMap.values();
    }

    @Override
    public Collection<V> removeKey2Values(K2 key2) {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<K2, V> innerMap : this.map.values()) {
            V value = innerMap.remove(key2);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<K2, V> innerMap : this.map.values()) {
            values.addAll(innerMap.values());
        }
        return values;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

