/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class HotelsTimeUtil {
    public static final String TIME_FORMAT = "HH:mm";
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");

    static <I, O> O map(Optional<I> inputOptional, Function<I, O> function) {
        return inputOptional.map(function).orElse(null);
    }

    protected static Optional<ZonedDateTime> offsetDateTimeToZonedDateTimeOptional(OffsetDateTime offsetDateTime) {
        return offsetDateTime != null ? Optional.of(offsetDateTime.toZonedDateTime()) : Optional.empty();
    }

    protected static Date zonedDateTimeOptionalToDate(Optional<ZonedDateTime> zonedDateTimeOptional) {
        return HotelsTimeUtil.map(zonedDateTimeOptional, zonedDateTime -> Date.from(zonedDateTime.toInstant()));
    }

    public static org.joda.time.LocalDate dateToJodaLocalDate(Date date) {
        return date != null ? new org.joda.time.LocalDate((Object)date) : null;
    }

    public static org.joda.time.LocalDateTime dateToJodaLocalDateTime(Date date) {
        return date != null ? new org.joda.time.LocalDateTime((Object)date) : null;
    }

    public static LocalTime dateToJodaLocalTime(Date date) {
        return date != null ? new LocalTime((Object)date) : null;
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date != null ? LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return date != null ? LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()) : null;
    }

    public static java.time.LocalTime dateToLocalTime(Date date) {
        return date != null ? LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalTime() : null;
    }

    public static LocalDate gregorianCalendarToLocalDate(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar != null ? gregorianCalendar.toZonedDateTime().toLocalDate() : null;
    }

    public static java.time.LocalTime gregorianCalendarToLocalTime(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar != null ? gregorianCalendar.toZonedDateTime().toLocalTime() : null;
    }

    public static java.time.LocalTime integerToLocalTime(Integer integer) {
        if (integer == null) {
            return null;
        }
        return java.time.LocalTime.of(integer / 60, integer % 60);
    }

    public static boolean isAfter(LocalTime one, LocalTime another, boolean inclusive) {
        return inclusive ? !one.isBefore((ReadablePartial)another) : one.isAfter((ReadablePartial)another);
    }

    public static boolean isBefore(LocalTime one, LocalTime another, boolean inclusive) {
        return inclusive ? !one.isAfter((ReadablePartial)another) : one.isBefore((ReadablePartial)another);
    }

    public static Date jodaLocalDateTimeToDate(org.joda.time.LocalDateTime jodaLocalDateTime) {
        return jodaLocalDateTime != null ? jodaLocalDateTime.toDate() : null;
    }

    public static LocalDateTime jodaLocalDateTimeToLocalDateTime(org.joda.time.LocalDateTime jodaLocalDateTime) {
        return HotelsTimeUtil.dateToLocalDateTime(HotelsTimeUtil.jodaLocalDateTimeToDate(jodaLocalDateTime));
    }

    public static LocalDate jodaLocalDateToLocalDate(org.joda.time.LocalDate jodaLocalDate) {
        return jodaLocalDate != null ? LocalDate.of(jodaLocalDate.getYear(), jodaLocalDate.getMonthOfYear(), jodaLocalDate.getDayOfMonth()) : null;
    }

    public static Date jodaLocalDateToDate(org.joda.time.LocalDate jodaLocalDate) {
        return jodaLocalDate != null ? MiscUtil.clearTime(jodaLocalDate.toDate()) : null;
    }

    public static Integer jodaLocalTimeToInteger(LocalTime jodaLocalTime) {
        return jodaLocalTime != null ? Integer.valueOf(jodaLocalTime.getHourOfDay() * 60 + jodaLocalTime.getMinuteOfHour()) : null;
    }

    public static java.time.LocalTime jodaLocalTimeToLocalTime(LocalTime jodaLocalTime) {
        return jodaLocalTime != null ? java.time.LocalTime.of(jodaLocalTime.getHourOfDay(), jodaLocalTime.getMinuteOfHour()) : null;
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return localDateTime != null ? Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static org.joda.time.LocalDateTime localDateTimeToJodaLocalDateTime(LocalDateTime localDateTime) {
        return HotelsTimeUtil.dateToJodaLocalDateTime(HotelsTimeUtil.localDateTimeToDate(localDateTime));
    }

    public static Date localDateToDate(LocalDate localDate) {
        return localDate != null ? Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static org.joda.time.LocalDate localDateToJodaLocalDate(LocalDate localDate) {
        return HotelsTimeUtil.dateToJodaLocalDate(HotelsTimeUtil.localDateToDate(localDate));
    }

    public static Date localTimeToDate(java.time.LocalTime localTime) {
        return localTime != null ? Date.from(localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static Integer localTimeToInteger(java.time.LocalTime localTime) {
        return localTime != null ? Integer.valueOf(localTime.getHour() * 60 + localTime.getMinute()) : null;
    }

    public static LocalTime localTimeToJodaLocalTime(java.time.LocalTime localTime) {
        return HotelsTimeUtil.dateToJodaLocalTime(HotelsTimeUtil.localTimeToDate(localTime));
    }

    public static Date offsetDateTimeToDate(OffsetDateTime offsetDateTime) {
        return HotelsTimeUtil.zonedDateTimeOptionalToDate(HotelsTimeUtil.offsetDateTimeToZonedDateTimeOptional(offsetDateTime));
    }

    public static LocalDate xmlGregorianCalendarToLocalDate(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar != null ? HotelsTimeUtil.gregorianCalendarToLocalDate(xmlGregorianCalendar.toGregorianCalendar()) : null;
    }

    public static java.time.LocalTime xmlGregorianCalendarToLocalTime(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar != null ? HotelsTimeUtil.gregorianCalendarToLocalTime(xmlGregorianCalendar.toGregorianCalendar()) : null;
    }

    public static int yearsBetween(LocalDate startDate, LocalDate endDate) {
        return Period.between(startDate, endDate).getYears();
    }

    public static Date zonedDateTimeToDate(ZonedDateTime zonedDateTime) {
        return HotelsTimeUtil.zonedDateTimeOptionalToDate(Optional.ofNullable(zonedDateTime));
    }
}

