/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.Identity;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationContext {
    private static final ConcurrentMap<String, ThreadLocal<InvocationContext>> threadLocals = new ConcurrentHashMap<String, ThreadLocal<InvocationContext>>();
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private int callDepth;
    private final Map<String, Identity> uids = new HashMap<String, Identity>();
    private final String category;

    public static InvocationContext get(String category) {
        ThreadLocal threadLocal = (ThreadLocal)threadLocals.get(category);
        if (threadLocal == null && (threadLocal = threadLocals.putIfAbsent(category, ThreadLocal.withInitial(() -> new InvocationContext(category)))) == null) {
            threadLocal = (ThreadLocal)threadLocals.get(category);
        }
        return (InvocationContext)threadLocal.get();
    }

    InvocationContext(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void enter() {
        ++this.callDepth;
    }

    public boolean enter(Identity identity) {
        String identityUid = identity.getUid();
        if (this.uids.containsKey(identityUid)) {
            return false;
        }
        this.uids.put(identityUid, identity);
        ++this.callDepth;
        return true;
    }

    public void exit() {
        --this.callDepth;
        if (this.callDepth < 0) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("invalid call depth detected, category=" + this.category + ", callDepth=" + this.callDepth);
            }
            this.callDepth = 0;
        }
        if (this.callDepth == 0) {
            this.uids.clear();
        }
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    public Identity getIdentity(String uid) {
        return Objects.isNull(uid) ? null : this.uids.get(uid);
    }

    public void putIdentity(Identity identity) {
        this.uids.put(identity.getUid(), identity);
    }

    public void removeIdentity(Identity identity) {
        this.uids.remove(identity.getUid());
    }
}

