/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MultiCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InvocationWorker<T>
extends Thread {
    private static volatile long lastId = 0L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long id;
    private final T target;
    private final MultiCall.Callback<T> callback;
    private Throwable error;
    private final boolean debug;

    InvocationWorker(T t, MultiCall.Callback<T> cb, boolean enableDebug) {
        this.debug = enableDebug;
        this.id = lastId++;
        this.target = t;
        this.callback = cb;
        this.setName("invocation-worker-" + this.id);
        this.setDaemon(true);
    }

    Throwable getError() {
        return this.error;
    }

    T getTarget() {
        return this.target;
    }

    @Override
    public void run() {
        if (this.debug) {
            DebugUtil.enableThreadDebug();
        }
        this.log.debug("BEGIN target=" + this.target);
        try {
            this.setContextClassLoader(this.callback.getClass().getClassLoader());
            this.callback.invoke(this.target);
        }
        catch (Throwable t) {
            this.error = t;
            this.log.error("invocation error detected for target " + this.target, t);
        }
        finally {
            this.log.debug("END target=" + this.target);
            DebugUtil.disableThreadDebug();
        }
    }
}

