/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.JarResource;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;

public final class IoUtil {
    public static boolean emptyFolder(File folder) {
        if (!folder.isDirectory()) {
            return true;
        }
        File[] files = folder.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.isDirectory()) {
                if (IoUtil.emptyFolder(file)) {
                    result &= file.delete();
                    continue;
                }
                result = false;
                continue;
            }
            result &= file.delete();
        }
        return result;
    }

    public static boolean isResourceExists(URL url) {
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            return IoUtil.isJarResourceExists(url);
        }
        File file = IoUtil.url2file(url);
        if (file != null) {
            return file.canRead();
        }
        return IoUtil.isUrlResourceExists(url);
    }

    private static boolean isUrlResourceExists(URL url) {
        try {
            InputStream is = url.openStream();
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJarResourceExists(URL url) {
        boolean bl;
        String urlStr = url.toExternalForm();
        int p = urlStr.indexOf("!/");
        if (p == -1) {
            return false;
        }
        URL fileUrl = new URL(urlStr.substring(4, p));
        File file = IoUtil.url2file(fileUrl);
        if (file == null) {
            return IoUtil.isUrlResourceExists(url);
        }
        if (!file.canRead()) {
            return false;
        }
        if (p == urlStr.length() - 2) {
            return true;
        }
        JarFile jarFile = new JarFile(file);
        try {
            bl = jarFile.getEntry(urlStr.substring(p + 2)) != null;
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public static InputStream getResourceInputStream(File file) throws MalformedURLException, IOException {
        return IoUtil.getResourceInputStream(file.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getResourceInputStream(URL url) throws IOException {
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            File file = IoUtil.url2file(url);
            if (file != null) {
                return new BufferedInputStream(new FileInputStream(file));
            }
            return url.openStream();
        }
        String urlStr = url.toExternalForm();
        if (urlStr.endsWith("!/")) {
            throw new FileNotFoundException(url.toExternalForm());
        }
        int p = urlStr.indexOf("!/");
        if (p == -1) {
            throw new MalformedURLException(url.toExternalForm());
        }
        String path = urlStr.substring(p + 2);
        File file = IoUtil.url2file(new URL(urlStr.substring(4, p)));
        if (file == null) {
            return url.openStream();
        }
        try (JarFile jarFile = new JarFile(file);){
            ByteArrayInputStream byteArrayInputStream;
            ZipEntry entry = jarFile.getEntry(path);
            if (entry == null) {
                throw new FileNotFoundException(url.toExternalForm());
            }
            InputStream in = jarFile.getInputStream(entry);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IoUtil.copyStream(in, out, 1024);
                byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return byteArrayInputStream;
        }
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buf = new byte[bufferSize];
        while ((len = in.read(buf)) != -1) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("thread interrupted");
            }
            out.write(buf, 0, len);
        }
    }

    public static void copyStream(Reader in, Appendable out, int bufferSize) throws IOException {
        int len;
        char[] buf = new char[bufferSize];
        while ((len = in.read(buf)) != -1) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("thread interrupted");
            }
            for (int i = 0; i < len; ++i) {
                out.append(buf[i]);
            }
        }
    }

    public static File url2file(URL url) {
        String prot = url.getProtocol();
        if ("jar".equalsIgnoreCase(prot)) {
            if (url.getFile().endsWith("!/")) {
                String urlStr = url.toExternalForm();
                try {
                    return IoUtil.url2file(new URL(urlStr.substring(4, urlStr.length() - 2)));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return new JarResource(url.toExternalForm());
        }
        if (!"file".equalsIgnoreCase(prot)) {
            return null;
        }
        try {
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new File(URLDecoder.decode(url.getFile()));
        }
    }

    public static URL file2url(File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    public static URL encodeUrl(URL url) throws URISyntaxException, MalformedURLException {
        return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
    }

    public static final String getExtension(File file) {
        return IoUtil.getExtension(file.getAbsolutePath());
    }

    public static final String getExtension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(".");
        if (i != -1 && i < fileName.length() - 1) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static final String removeExtension(File file) {
        return IoUtil.removeExtension(file.getAbsolutePath());
    }

    public static final String removeExtension(String fileName) {
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            fileName = fileName.substring(0, i);
        }
        return fileName;
    }

    public static final String replaceExtension(File file, String newExtension) {
        return IoUtil.replaceExtension(file.getAbsolutePath(), newExtension);
    }

    public static final String replaceExtension(String fileName, String extension) {
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            fileName = fileName.substring(0, i);
        }
        fileName = fileName + "." + extension;
        return fileName;
    }

    public static final String addExtension(File file, String extension) {
        return IoUtil.addExtension(file.getAbsolutePath(), extension);
    }

    public static final String addExtension(String fileName, String extension) {
        fileName = fileName + "." + extension;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File source, File destination, boolean createDirs) throws IOException {
        File parent;
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        if (source.equals(destination)) {
            return;
        }
        if (createDirs && (parent = destination.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException();
        }
        FileChannel fileInputChannel = new FileInputStream(source).getChannel();
        FileChannel fileOutputChannel = new FileOutputStream(destination).getChannel();
        try {
            int maxCount = 67076096;
            long size = fileInputChannel.size();
            for (long position = 0L; position < size; position += fileInputChannel.transferTo(position, maxCount, fileOutputChannel)) {
            }
        }
        finally {
            if (fileInputChannel != null) {
                fileInputChannel.close();
            }
            if (fileOutputChannel != null) {
                fileOutputChannel.close();
            }
        }
    }

    public static final void moveFile(File source, File destination, boolean createDirs) throws IOException {
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        File child = null;
        if (createDirs) {
            File parent;
            for (parent = destination.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                child = parent;
            }
            parent = destination.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                if (child != null) {
                    IoUtil.deleteFile(child);
                }
                throw new IOException();
            }
        }
        if (!source.renameTo(destination)) {
            if (child != null) {
                IoUtil.deleteFile(child);
            }
            throw new IOException();
        }
    }

    public static boolean deleteFile(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] listFiles;
            for (File listFile : listFiles = file.listFiles()) {
                IoUtil.deleteFile(listFile);
            }
        }
        return file.delete();
    }

    public static void synchronizeFolders(File src, File dest) throws IOException {
        IoUtil.synchronizeFolders(src, dest, null);
    }

    public static void synchronizeFolders(File src, File dest, FileFilter filter) throws IOException {
        File[] destFiles;
        File[] srcFiles;
        if (!src.isDirectory()) {
            throw new IOException(String.format("directory expected, but %s is not a directory", src));
        }
        if (dest.isFile()) {
            throw new IOException(String.format("directory expected, but %s denotes a file", dest));
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException(String.format("can't create directory %s", dest));
        }
        for (File srcFile : srcFiles = filter != null ? src.listFiles(filter) : src.listFiles()) {
            File destFile = new File(dest, srcFile.getName());
            if (srcFile.isDirectory()) {
                if (destFile.isFile() && !destFile.delete()) {
                    try {
                        Files.delete(destFile.toPath());
                    }
                    catch (Throwable t) {
                        throw new IOException(String.format("can't delete file %s", destFile));
                    }
                }
                IoUtil.synchronizeFolders(srcFile, destFile, filter);
                continue;
            }
            if (IoUtil.compareFiles(srcFile, destFile)) continue;
            IoUtil.copyFile(srcFile, destFile, false);
        }
        File[] fileArray = destFiles = dest.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File destFile2;
            File destFile = destFile2 = fileArray[i];
            File srcFile = new File(src, destFile.getName());
            if (filter != null && filter.accept(destFile) && srcFile.exists() || filter == null && srcFile.exists()) continue;
            if (destFile.isDirectory() && !IoUtil.emptyFolder(destFile)) {
                throw new IOException(String.format("can't empty folder %s", destFile));
            }
            if (!destFile.exists() || destFile.delete()) continue;
            try {
                Files.delete(destFile.toPath());
                continue;
            }
            catch (Throwable t) {
                throw new IOException(String.format("can't delete file %s", destFile), t);
            }
        }
        dest.setLastModified(src.lastModified());
    }

    public static boolean compareFiles(File file1, File file2) {
        if (!file1.isFile() || !file2.isFile()) {
            return false;
        }
        if (!file1.getName().equals(file2.getName())) {
            return false;
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        return IoUtil.compareFileDates(new Date(file1.lastModified()), new Date(file2.lastModified()));
    }

    public static boolean compareFileDates(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cldr = Calendar.getInstance(Locale.ENGLISH);
        cldr.setTime(date1);
        cldr.set(14, 0);
        long dt1 = cldr.getTimeInMillis();
        cldr.setTime(date2);
        cldr.set(14, 0);
        long dt2 = cldr.getTimeInMillis();
        return dt1 == dt2;
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String readFileToString(File file) throws IOException {
        return IoUtil.readFileToString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) throws IOException {
        InputStream in = null;
        try {
            in = IoUtil.openInputStream(file);
            String string = IOUtils.toString((InputStream)in, (String)encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        InputStream in = null;
        try {
            in = IoUtil.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static InputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return IoUtil.getResourceInputStream(file);
    }
}

