/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarResource
extends File {
    private static final long serialVersionUID = 9139366493902409164L;
    private final File jar;
    private volatile ZipEntry zipEntry;
    private volatile List<ZipEntry> zipEntries;
    private final String jarPath;
    private final String localPath;
    private volatile boolean dir;

    private JarResource(File jar, List<ZipEntry> zipEntries, String path) {
        super("");
        String lp = path;
        if (lp.startsWith("/")) {
            lp = lp.substring(1);
        }
        this.localPath = lp;
        this.jar = jar;
        this.zipEntries = zipEntries;
        this.jarPath = this.encodeJarPath(jar.getAbsolutePath());
    }

    JarResource(String pathName) {
        super("");
        String jarFile = pathName;
        if (!jarFile.startsWith("jar:")) {
            throw new IllegalArgumentException();
        }
        int p = (jarFile = jarFile.substring(4)).indexOf("!/");
        if (p != -1) {
            String lp = jarFile.substring(p + 2);
            if (separatorChar != '/') {
                lp = lp.replace(separatorChar, '/');
            }
            if (lp.startsWith("/")) {
                lp = lp.substring(1);
            }
            if (lp.endsWith("/")) {
                lp = lp.substring(0, lp.length() - 1);
            }
            this.localPath = lp;
            jarFile = jarFile.substring(0, p);
        } else {
            this.localPath = "";
        }
        try {
            this.jar = new File(new URL(jarFile).toURI().getPath());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.jarPath = this.encodeJarPath(this.jar.getAbsolutePath());
    }

    private JarResource(String child, JarResource parent) {
        this(parent.jar, parent.zipEntries, !"".equals(parent.localPath) ? parent.localPath + "/" + child : child);
    }

    private String getJarFileUrl(String path) {
        String sp = JarResource.slashify(path, false);
        if (!sp.startsWith("//")) {
            if (!sp.startsWith("/")) {
                sp = "/" + sp;
            }
            sp = "//" + sp;
        }
        return "file:" + sp + "!/";
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (separatorChar != '/') {
            p = p.replace(separatorChar, '/');
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    private String encodeJarPath(String path) {
        return "jar:" + this.getJarFileUrl(path);
    }

    @Override
    public String getName() {
        int index = this.localPath.lastIndexOf(separatorChar);
        return index >= 0 ? this.localPath.substring(index + 1) : this.localPath;
    }

    @Override
    public String getParent() {
        String p = super.getParent();
        return p != null ? this.jarPath + p : this.jar.getParent();
    }

    @Override
    public File getParentFile() {
        String p = super.getParent();
        return p != null ? new JarResource(this.jar, this.zipEntries, p) : this.jar.getParentFile();
    }

    @Override
    public String getPath() {
        return this.jarPath + this.localPath;
    }

    @Override
    public boolean isAbsolute() {
        return this.jar.isAbsolute();
    }

    @Override
    public String getAbsolutePath() {
        return this.encodeJarPath(this.jar.getAbsolutePath()) + this.localPath;
    }

    @Override
    public File getAbsoluteFile() {
        return new JarResource(this.jar.getAbsoluteFile(), this.zipEntries, this.localPath);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.encodeJarPath(this.jar.getCanonicalPath()) + this.localPath;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new JarResource(this.jar.getCanonicalFile(), this.zipEntries, this.localPath);
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return new URL("jar", "", this.getJarFileUrl(this.jar.getAbsolutePath()) + JarResource.slashify(this.localPath, this.isDirectory()));
    }

    @Override
    public URI toURI() {
        try {
            return new URI("jar", this.getJarFileUrl(this.jar.getAbsolutePath()) + JarResource.slashify(this.localPath, this.isDirectory()), null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    @Override
    public boolean canRead() {
        return this.jar.canRead() && this.exists();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    protected void open() {
        if (null != this.zipEntry) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(this.jar);){
            ZipEntry ze = zipFile.getEntry(this.localPath + "/");
            if (ze != null) {
                this.zipEntry = ze;
                this.dir = true;
            } else {
                this.zipEntry = zipFile.getEntry(this.localPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean exists() {
        if (!this.jar.exists()) {
            return false;
        }
        this.open();
        return this.zipEntry != null;
    }

    @Override
    public boolean isDirectory() {
        this.open();
        return this.dir;
    }

    @Override
    public boolean isFile() {
        this.open();
        return !this.dir;
    }

    @Override
    public boolean isHidden() {
        return this.jar.isHidden();
    }

    @Override
    public long lastModified() {
        this.open();
        return this.zipEntry != null ? this.zipEntry.getTime() : 0L;
    }

    @Override
    public long length() {
        this.open();
        return this.zipEntry != null ? this.zipEntry.getSize() : 0L;
    }

    @Override
    public boolean createNewFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] list() {
        if (!this.isDirectory()) {
            return null;
        }
        if (null == this.zipEntries) {
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            try (ZipFile zipFile = new ZipFile(this.jar);){
                Enumeration<? extends ZipEntry> c = zipFile.entries();
                while (c.hasMoreElements()) {
                    ZipEntry entry = c.nextElement();
                    entries.add(entry);
                }
            }
            catch (IOException e) {
                return null;
            }
            this.zipEntries = entries;
        }
        ArrayList<String> result = new ArrayList<String>();
        String name = this.zipEntry.getName();
        int len = name.length();
        for (ZipEntry entry : this.zipEntries) {
            String localName;
            if (!entry.getName().startsWith(name) || (localName = entry.getName().substring(len)).length() == 0) continue;
            int p = localName.indexOf(47);
            if (p != -1) {
                if (p != localName.length() - 1) continue;
                localName = localName.substring(0, localName.length() - 1);
            }
            result.add(localName);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public File[] listFiles() {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new File[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new JarResource(ss[i], this);
        }
        return fs;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<JarResource> v = new ArrayList<JarResource>();
        for (String s : ss) {
            if (filter != null && !filter.accept(this, s)) continue;
            v.add(new JarResource(s, this));
        }
        return v.toArray(new File[v.size()]);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<JarResource> v = new ArrayList<JarResource>();
        for (String s : ss) {
            JarResource f = new JarResource(s, this);
            if (filter != null && !filter.accept(f)) continue;
            v.add(f);
        }
        return v.toArray(new File[v.size()]);
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mkdirs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean renameTo(File dest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setLastModified(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.jar.setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setReadable(boolean readable) {
        return this.jar.setReadable(readable);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public long getTotalSpace() {
        return this.jar.getTotalSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.jar.getFreeSpace();
    }

    @Override
    public long getUsableSpace() {
        return this.jar.getUsableSpace();
    }

    @Override
    public int compareTo(File pathname) {
        boolean isJar = pathname instanceof JarResource;
        File main = isJar ? ((JarResource)pathname).jar : pathname;
        int result = this.jar.compareTo(main);
        if (result != 0) {
            return result;
        }
        return isJar ? super.compareTo(pathname) : 1;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.jar == null ? 0 : this.jar.hashCode());
        result = 31 * result + (this.localPath == null ? 0 : this.localPath.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.getPath();
    }
}

