/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;

public final class JpfUtil {
    public static <T> Collection<T> getInstancesForExtension(String pluginId, String pointId, Class<T> clazz) throws Exception {
        ArrayList result = new ArrayList();
        for (Extension ext : JpfUtil.getConnectedExtensions(pluginId, pointId)) {
            for (Extension.Parameter param : ext.getParameters("class")) {
                result.add(JpfUtil.getClass(param).newInstance());
            }
        }
        return result;
    }

    public static Class<?> getClass(Extension ext) throws PluginLifecycleException, ClassNotFoundException {
        return JpfUtil.getClass(ext.getParameter("class"));
    }

    public static Class<?> getClass(Extension ext, String paramName) throws PluginLifecycleException, ClassNotFoundException {
        return JpfUtil.getClass(ext.getParameter(paramName));
    }

    public static Class<?> getClass(Extension.Parameter param, String subParamName) throws PluginLifecycleException, ClassNotFoundException {
        return JpfUtil.getClass(param.getSubParameter(subParamName));
    }

    public static ClassLoader getClassLoader(Extension ext) throws PluginLifecycleException {
        PluginDescriptor descr;
        if (ext == null) {
            return null;
        }
        PluginManager pm = PluginManager.lookup(JpfUtil.class);
        if (!pm.isPluginActivated(descr = ext.getDeclaringPluginDescriptor()) && !pm.isPluginActivating(descr)) {
            pm.activatePlugin(descr.getId());
        }
        return pm.getPluginClassLoader(descr);
    }

    public static Class<?> getClass(Extension.Parameter param) throws PluginLifecycleException, ClassNotFoundException {
        PluginDescriptor descr;
        if (param == null) {
            return null;
        }
        String className = param.valueAsString();
        PluginManager pm = PluginManager.lookup(JpfUtil.class);
        if (!pm.isPluginActivated(descr = param.getDeclaringPluginDescriptor()) && !pm.isPluginActivating(descr)) {
            pm.activatePlugin(descr.getId());
        }
        return pm.getPluginClassLoader(descr).loadClass(className);
    }

    public static URL getResource(Extension ext, String paramName) throws PluginLifecycleException {
        return JpfUtil.getResource(ext.getParameter(paramName));
    }

    public static URL getResource(Extension.Parameter param) throws PluginLifecycleException {
        PluginDescriptor descr;
        if (param == null) {
            return null;
        }
        String resName = param.valueAsString();
        PluginManager pm = PluginManager.lookup(JpfUtil.class);
        if (!pm.isPluginActivated(descr = param.getDeclaringPluginDescriptor()) && !pm.isPluginActivating(descr)) {
            pm.activatePlugin(descr.getId());
        }
        return pm.getPluginClassLoader(descr).getResource(resName);
    }

    public static Extension findExtension(String extensionUid, boolean connectedOnly) {
        for (PluginDescriptor descr : PluginManager.lookup(JpfUtil.class).getRegistry().getPluginDescriptors()) {
            if (connectedOnly) {
                for (ExtensionPoint point : descr.getExtensionPoints()) {
                    if (!point.isExtensionConnected(extensionUid)) continue;
                    return point.getConnectedExtension(extensionUid);
                }
                continue;
            }
            for (Extension ext : descr.getExtensions()) {
                if (!extensionUid.equals(ext.getUniqueId())) continue;
                return ext;
            }
        }
        return null;
    }

    public static List<Extension> getConnectedExtensions(String pluginId, String pointId) {
        PluginManager pm = PluginManager.lookup(JpfUtil.class);
        if (pm == null) {
            return Collections.emptyList();
        }
        ArrayList<Extension> result = new ArrayList<Extension>(pm.getRegistry().getExtensionPoint(pluginId, pointId).getConnectedExtensions());
        JpfUtil.reorder(result, pm.getRegistry());
        return result;
    }

    public static boolean isExtensionDisabled(Extension ext) {
        return "true".equalsIgnoreCase(System.getProperty("disabledExtension:" + ext.getUniqueId()));
    }

    public static <T extends PluginElement<?>> void reorder(List<T> elements, PluginRegistry registry) {
        block0: for (int i = 0; i < elements.size(); ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                if (!JpfUtil.isDepends(((PluginElement)elements.get(i)).getDeclaringPluginDescriptor(), ((PluginElement)elements.get(j)).getDeclaringPluginDescriptor(), registry)) continue;
                Collections.swap(elements, i, j);
                i = -1;
                continue block0;
            }
        }
    }

    private static boolean isDepends(PluginDescriptor descr1, PluginDescriptor descr2, PluginRegistry registry) {
        if (descr1.equals(descr2)) {
            return false;
        }
        HashSet<PluginDescriptor> pre1 = new HashSet<PluginDescriptor>();
        HashSet<PluginDescriptor> pre2 = new HashSet<PluginDescriptor>();
        JpfUtil.collectPrerequisites(descr1, pre1, registry);
        JpfUtil.collectPrerequisites(descr2, pre2, registry);
        return pre1.contains(descr2) && !pre2.contains(descr1);
    }

    private static void collectPrerequisites(PluginDescriptor descr, Set<PluginDescriptor> result, PluginRegistry registry) {
        for (PluginPrerequisite pre : descr.getPrerequisites()) {
            PluginDescriptor descriptor;
            if (!pre.matches() || !result.add(descriptor = registry.getPluginDescriptor(pre.getPluginId()))) continue;
            JpfUtil.collectPrerequisites(descriptor, result, registry);
        }
    }

    private JpfUtil() {
    }
}

