/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

public class MathUtil {
    private static final double EARTH_RADIUS = 6372795.0;

    public static double calculateDistance(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 != 0.0 && lon1 != 0.0 && lon2 != 0.0 && lat2 != 0.0) {
            double toRad = Math.PI / 180;
            double dLat = (lat2 - lat1) * toRad;
            double dLon = (lon2 - lon1) * toRad;
            double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.cos(lat1 * toRad) * Math.cos(lat2 * toRad) * Math.pow(Math.sin(dLon / 2.0), 2.0);
            double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            return 6372795.0 * c;
        }
        return -1.0;
    }

    public static double convertMilesToKilometers(double miles) {
        return miles * 1.609;
    }
}

