/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Mergeables {
    public static List<?> mergeWhatIsPossible(List<?> objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object o : objects) {
            if (!(o instanceof IMergeable)) {
                results.add(o);
                continue;
            }
            IMergeable m = (IMergeable)o;
            boolean mergedWithAnything = false;
            for (int i = 0; i < results.size() && !mergedWithAnything; ++i) {
                IMergeable m2;
                Object res = results.get(i);
                if (!(res instanceof IMergeable) || !(m2 = (IMergeable)res).canBeMerged(m)) continue;
                results.set(i, m2.merge(m));
                mergedWithAnything = true;
            }
            if (mergedWithAnything) continue;
            results.add(m);
        }
        return results;
    }

    public static <M extends IMergeable<?>> List<M> merge(List<M> mergeables) {
        return Mergeables.mergeWhatIsPossible(mergeables);
    }

    public static class CollectionMergeable<T>
    implements IMergeable<CollectionMergeable<T>> {
        private final Collection<T> coll;

        public CollectionMergeable(Collection<T> coll) {
            this.coll = MiscUtil.guarded(coll, new ArrayList());
        }

        public CollectionMergeable() {
            this(new ArrayList());
        }

        @Override
        public CollectionMergeable<T> merge(CollectionMergeable<T> cm) {
            if (CollectionUtil.isEmpty(cm.coll)) {
                return this;
            }
            ArrayList<T> temp = new ArrayList<T>(this.coll);
            temp.addAll(cm.coll);
            return new CollectionMergeable<T>(temp);
        }

        @Override
        public boolean canBeMerged(IMergeable<?> mergeable) {
            return mergeable instanceof CollectionMergeable;
        }

        public Collection<T> getCollection() {
            return this.coll;
        }
    }

    public static interface IMergeable<M extends IMergeable<M>> {
        public boolean canBeMerged(IMergeable<?> var1);

        public M merge(M var1);
    }
}

