/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.PdfUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PdfUtilsTest {
    private static File pdfFile;

    @BeforeClass
    public static void beforeClass() {
        pdfFile = PdfUtilsTest.getTestData("pdfContentTest.pdf");
    }

    @Test
    public void getContentTest() throws Exception {
        String pdfContent = PdfUtilsTest.normalize(PdfUtils.getContent(new FileInputStream(pdfFile)));
        String testFileContent = PdfUtilsTest.normalize(this.testFileContent(PdfUtilsTest.getTestData("pdfContentTestAllPages.txt")));
        Assert.assertEquals((Object)pdfContent, (Object)testFileContent);
    }

    @Test
    public void getContentByPagesTest() throws Exception {
        String pdfContent = null;
        String testFileContent = null;
        pdfContent = PdfUtilsTest.normalize(PdfUtils.getContent(new FileInputStream(pdfFile), 1, 1));
        testFileContent = PdfUtilsTest.normalize(this.testFileContent(PdfUtilsTest.getTestData("pdfContentTestFirstPageOnly.txt")));
        Assert.assertEquals((Object)pdfContent, (Object)testFileContent);
        pdfContent = PdfUtilsTest.normalize(PdfUtils.getContent(new FileInputStream(pdfFile), 2, 2));
        testFileContent = PdfUtilsTest.normalize(this.testFileContent(PdfUtilsTest.getTestData("pdfContentTestSecondPageOnly.txt")));
        Assert.assertEquals((Object)pdfContent, (Object)testFileContent);
        pdfContent = PdfUtilsTest.normalize(PdfUtils.getContent(new FileInputStream(pdfFile), 1, 2));
        testFileContent = PdfUtilsTest.normalize(this.testFileContent(PdfUtilsTest.getTestData("pdfContentTestFisrt_SecondPages.txt")));
        Assert.assertEquals((Object)pdfContent, (Object)testFileContent);
        pdfContent = PdfUtilsTest.normalize(PdfUtils.getContent(new FileInputStream(pdfFile), 2, 3));
        testFileContent = PdfUtilsTest.normalize(this.testFileContent(PdfUtilsTest.getTestData("pdfContentTestSecond_ThirdPages.txt")));
        Assert.assertEquals((Object)pdfContent, (Object)testFileContent);
    }

    private String testFileContent(File file) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            StringBuilder res = new StringBuilder();
            int c = -1;
            while ((c = reader.read()) != -1) {
                res.append((char)c);
            }
            String string = res.toString();
            return string;
        }
    }

    private static String normalize(String s) {
        return s.trim().replaceAll("\r\n", "\n");
    }

    private static File getTestData(String fileName) {
        return IoUtil.url2file(PdfUtilsTest.class.getResource("test/testdata/pdfUtilsTest/" + fileName));
    }
}

