/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PhoneNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneHelper {
    public static String getPhoneNumber(String countryCode, String cityCode, String phone) {
        return String.format("+%s(%s)%s", countryCode, cityCode, phone);
    }

    public static boolean isNumberCorrect(String originalCountryCode, String originalCityCode, String originalNumber, String originalExtension) {
        PhoneNumber number = PhoneHelper.getCorrectNumber(originalCountryCode, originalCityCode, originalNumber, originalExtension);
        if (number == null) {
            return false;
        }
        return MiscUtil.equals(originalCountryCode, number.getCountryCode()) && MiscUtil.equals(originalCityCode, number.getCityCode()) && MiscUtil.equals(originalNumber, number.getNumber()) && MiscUtil.equals(originalExtension, number.getExtension());
    }

    public static PhoneNumber getCorrectNumber(String originalCountryCode, String originalCityCode, String originalNumber, String originalExtension) {
        String A1 = originalCountryCode;
        String A2 = originalCityCode;
        String A3 = originalNumber;
        String E = originalExtension;
        String LA1 = PhoneHelper.trim(A1);
        String LA2 = PhoneHelper.trim(A2);
        String LA3 = PhoneHelper.trim(A3);
        String codes = "495|499|916|915|903|905|910|926|800";
        if (LA2 != null && LA2.length() > 0 && LA3 != null && LA3.length() > 0) {
            if (LA1 == null || LA1.length() == 0) {
                LA1 = "7";
            } else if ("8".equals(LA1)) {
                LA1 = "7";
            } else if (LA1.startsWith("+")) {
                LA1 = LA1.substring(1);
            }
            LA1 = LA1.replace("-", "").replace(" ", "");
            if (LA2.startsWith("(") && LA2.endsWith(")")) {
                LA2 = LA2.substring(1, LA2.length() - 2);
            }
            LA2 = LA2.replace("-", "").replace(" ", "");
            LA3 = LA3.replace("-", "").replace(" ", "");
            if ("7".equals(LA1) && LA2.startsWith("0")) {
                LA2 = "4" + LA2.substring(1);
            }
            if (!"|495|499|916|915|903|905|910|926|800|".contains("|" + LA1 + "|") && PhoneHelper.isDigit(LA1) && PhoneHelper.isDigit(LA2) && PhoneHelper.isDigit(LA3) && (!LA1.startsWith("7") && LA3.length() > 2 || LA1.startsWith("7") && LA2.length() >= 3 && (LA2 + LA3).length() == 10)) {
                return new PhoneNumber(LA1, LA2, LA3, E);
            }
        }
        String text = PhoneHelper.concat("-", PhoneHelper.trim(A1), PhoneHelper.trim(A2), !TextUtil.isBlank(A3) ? PhoneHelper.trim(A3) : PhoneHelper.trim(E));
        boolean fromE = TextUtil.isBlank(A3);
        if (!(fromE || text != null && text.length() != 0)) {
            text = PhoneHelper.trim(E);
            fromE = true;
        }
        if (TextUtil.isBlank(text)) {
            return null;
        }
        String S = "(?: +|-|(?=\\())";
        String PA1 = "(?:(?:\\+0*((?:\\d|-)+?)|(?:\\+?(?:9?MOW|9?LED))?(7|8))(?: +|-|(?=\\()))?";
        String PA2 = "(?:\\(((?:\\d| |-)+)\\)(?: +|-|(?=\\())?|(495|499|916|915|903|905|910|926|800)(?: +|-|(?=\\())?|(\\d+)(?: +|-|(?=\\()))";
        String PA3 = "((?:\\d| |-)+)";
        Pattern pattern = Pattern.compile("\\A(?:(?:\\+0*((?:\\d|-)+?)|(?:\\+?(?:9?MOW|9?LED))?(7|8))(?: +|-|(?=\\()))?(?:\\(((?:\\d| |-)+)\\)(?: +|-|(?=\\())?|(495|499|916|915|903|905|910|926|800)(?: +|-|(?=\\())?|(\\d+)(?: +|-|(?=\\()))((?:\\d| |-)+)\\z");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            LA1 = PhoneHelper.coalesce(matcher.group(1), matcher.group(2));
            boolean LA1Present = LA1 != null;
            LA1 = "8".equals(LA1) || LA1 == null ? "7" : LA1.replace("-", "");
            LA2 = PhoneHelper.coalesce(matcher.group(3), matcher.group(4), matcher.group(5));
            if (LA2 != null) {
                LA2 = LA2.replace(" ", "").replace("-", "");
            }
            if ((LA3 = matcher.group(6)) != null) {
                LA3 = LA3.replace(" ", "").replace("-", "");
            }
            if (!LA1Present && PhoneHelper.isDigit(LA2) && PhoneHelper.isDigit(LA3) && LA2.startsWith("8") && (LA2 + LA3).length() == 11) {
                LA2 = LA2.substring(1);
            }
            if ("7".equals(LA1) && PhoneHelper.isDigit(LA2) && LA2.startsWith("0")) {
                LA2 = "4" + LA2.substring(1);
            }
            if (PhoneHelper.isDigit(LA1) && PhoneHelper.isDigit(LA2) && PhoneHelper.isDigit(LA3) && (LA2 + LA3).length() == 10) {
                return new PhoneNumber(LA1, LA2, LA3, !fromE ? E : null);
            }
        }
        if ((matcher = (pattern = Pattern.compile("\\A(\\+?7|8)(495|499|916|915|903|905|910|926|800|9\\d\\d)(\\d{7})\\z")).matcher(text.replace(" ", "").replace("-", ""))).find()) {
            LA1 = matcher.group(1);
            if ("8".equals(LA1)) {
                LA1 = "7";
            }
            LA2 = matcher.group(2);
            LA3 = matcher.group(3);
            return new PhoneNumber(LA1, LA2, LA3, !fromE ? E : null);
        }
        return null;
    }

    private static String concat(String separator, String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (String str : strings) {
            if (str == null || str.length() <= 0) continue;
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private static String coalesce(String ... strs) {
        for (String str : strs) {
            if (str == null) continue;
            return str;
        }
        return null;
    }

    private static boolean isDigit(String str) {
        if (str == null) {
            return false;
        }
        return !str.isEmpty() && PhoneHelper.isNumeric(str);
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String trim(String text) {
        return text != null ? text.trim() : null;
    }
}

