/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;

public final class QRCodeUtil {
    public static BufferedImage generateToImage(String text, int width, int height) throws WriterException {
        return QRCodeUtil.generateToImage(text, width, height, -16777216, -1);
    }

    public static BufferedImage generateToImage(String text, int width, int height, int onColor, int offColor) throws WriterException {
        QRCodeWriter writer = new QRCodeWriter();
        BitMatrix matrix = writer.encode(text, BarcodeFormat.QR_CODE, width, height, Collections.singletonMap(EncodeHintType.CHARACTER_SET, "UTF-8"));
        return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix, (MatrixToImageConfig)new MatrixToImageConfig(onColor, offColor));
    }

    public static void generateToStream(String text, int width, int height, OutputStream os, ImageFormat format) throws WriterException, IOException {
        QRCodeUtil.generateToStream(text, width, height, -16777216, -1, os, format);
    }

    public static void generateToStream(String text, int width, int height, int onColor, int offColor, OutputStream os, ImageFormat format) throws WriterException, IOException {
        Objects.requireNonNull(os, "output stream not specified");
        Objects.requireNonNull(format, "format not specified");
        QRCodeWriter writer = new QRCodeWriter();
        BitMatrix matrix = writer.encode(text, BarcodeFormat.QR_CODE, width, height, Collections.singletonMap(EncodeHintType.CHARACTER_SET, "UTF-8"));
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)format.getFormat(), (OutputStream)os, (MatrixToImageConfig)new MatrixToImageConfig(onColor, offColor));
    }

    public static void generateToFile(String text, int width, int height, String path, ImageFormat format) throws WriterException, IOException {
        QRCodeUtil.generateToFile(text, width, height, -16777216, -1, Paths.get(path, new String[0]), format);
    }

    public static void generateToFile(String text, int width, int height, Path path, ImageFormat format) throws WriterException, IOException {
        QRCodeUtil.generateToFile(text, width, height, -16777216, -1, path, format);
    }

    public static void generateToFile(String text, int width, int height, int onColor, int offColor, Path path, ImageFormat format) throws WriterException, IOException {
        Objects.requireNonNull(path, "path not specified");
        Objects.requireNonNull(format, "format not specified");
        QRCodeWriter writer = new QRCodeWriter();
        BitMatrix matrix = writer.encode(text, BarcodeFormat.QR_CODE, width, height, Collections.singletonMap(EncodeHintType.CHARACTER_SET, "UTF-8"));
        MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)format.getFormat(), (Path)path, (MatrixToImageConfig)new MatrixToImageConfig(onColor, offColor));
    }

    public static enum ImageFormat {
        PNG("PNG");

        private final String format;

        private ImageFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

