/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.ObjectFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class RandomUtil {
    public static final Random RND = new Random();

    public static int getRandomInt(int min, int max) {
        if (max <= min) {
            return min;
        }
        return min + RND.nextInt(max - min);
    }

    public static long getRandomLong(long min, long max) {
        long val;
        long bits;
        if (max <= min) {
            return min;
        }
        long n = max - min;
        while ((bits = RND.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return min + val;
    }

    public static byte[] getRandomBytes(int minLen, int maxLen) {
        byte[] result = new byte[RandomUtil.getRandomInt(minLen, maxLen)];
        RND.nextBytes(result);
        return result;
    }

    public static boolean getRandomBoolean() {
        return RND.nextBoolean();
    }

    public static <E extends Enum<?>> E getRandomEnum(Class<E> cls) {
        Enum[] enums = (Enum[])cls.getEnumConstants();
        return (E)enums[RandomUtil.getRandomInt(0, enums.length)];
    }

    public static <E> E getRandomElement(E[] arr) {
        if (arr.length == 0) {
            return null;
        }
        return arr[RandomUtil.getRandomInt(0, arr.length)];
    }

    public static <E> E getRandomElement(List<E> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(RandomUtil.getRandomInt(0, list.size()));
    }

    public static <E> E getRandomElement(Collection<E> collection) {
        if (collection.size() == 0) {
            return null;
        }
        int pos = RandomUtil.getRandomInt(0, collection.size());
        E result = null;
        int i = 0;
        for (E e : collection) {
            if (i++ != pos) continue;
            result = e;
            break;
        }
        return result;
    }

    public static Date getRandomDate(Date minDate, Date maxDate) {
        return new Date(RandomUtil.getRandomLong(minDate == null ? 0L : minDate.getTime(), maxDate == null ? Long.MAX_VALUE : maxDate.getTime()));
    }

    public static Calendar getRandomCalendar(Date minDate, Date maxDate) {
        Calendar result = Calendar.getInstance();
        result.setTime(RandomUtil.getRandomDate(minDate, maxDate));
        return result;
    }

    public static Date getRandomDate(int yearCount) {
        Calendar c = Calendar.getInstance();
        Date now = c.getTime();
        c.add(1, yearCount);
        if (yearCount < 0) {
            return new Date(RandomUtil.getRandomLong(c.getTime().getTime(), now.getTime()));
        }
        return new Date(RandomUtil.getRandomLong(now.getTime(), c.getTime().getTime()));
    }

    public static Calendar getRandomCalendar(int yearCount) {
        Calendar result = Calendar.getInstance();
        result.setTime(RandomUtil.getRandomDate(yearCount));
        return result;
    }

    public static String getRandomString(Chars chars, int minLen, int maxLen) {
        StringBuilder result = new StringBuilder(minLen);
        char[] data = chars.getData();
        for (int i = 0; i < minLen; ++i) {
            result.append(data[RND.nextInt(data.length)]);
        }
        if (maxLen > minLen) {
            int c = RND.nextInt(maxLen - minLen);
            for (int i = 0; i < c; ++i) {
                result.append(data[RND.nextInt(data.length)]);
            }
        }
        return result.toString();
    }

    public static char getRandomChar(Chars chars) {
        char[] arr = chars.getData();
        return arr[RandomUtil.getRandomInt(0, arr.length)];
    }

    public static <E> List<E> createRandomCollection(int minSize, int maxSize, ObjectFactory<E> factory) {
        int size = RandomUtil.getRandomInt(minSize, maxSize);
        ArrayList<E> result = new ArrayList<E>(size);
        for (int i = 0; i < size; ++i) {
            result.add(factory.createObject());
        }
        return result;
    }

    public static <E> void fillRandomCollection(Collection<E> coll, int minSize, int maxSize, ObjectFactory<E> factory) {
        coll.clear();
        int size = RandomUtil.getRandomInt(minSize, maxSize);
        for (int i = 0; i < size; ++i) {
            coll.add(factory.createObject());
        }
    }

    public static <E, V> void fillRandomMap(Map<E, V> map, int minSize, int maxSize, ObjectFactory<E> keyFactory, ObjectFactory<V> valueFactory) {
        map.clear();
        int size = RandomUtil.getRandomInt(minSize, maxSize);
        for (int i = 0; i < size; ++i) {
            map.put(keyFactory.createObject(), valueFactory.createObject());
        }
    }

    public static String getRandomCurrency() {
        return RandomUtil.getRandomElement(new String[]{"CAD", "CNY", "EUR", "JPY", "KRW", "TWD", "GBP", "USD"});
    }

    private RandomUtil() {
    }

    public static abstract class Chars
    extends Enum<Chars> {
        public static final /* enum */ Chars NUM;
        public static final /* enum */ Chars LATIN_ALPHA_UPPER;
        public static final /* enum */ Chars LATIN_ALPHA_LOWER;
        public static final /* enum */ Chars LATIN_ALPHA_UPPER_LOWER_NUM_SPEC;
        public static final /* enum */ Chars ALPHA;
        public static final /* enum */ Chars SPEC;
        public static final /* enum */ Chars ALPHA_NUM;
        public static final /* enum */ Chars ALPHA_SPEC;
        public static final /* enum */ Chars ALPHA_NUM_SPEC;
        public static final /* enum */ Chars LATIN_ALPHA_NUM;
        protected static final char[] DATA_NUM;
        protected static final char[] DATA_LATIN_ALPHA_UPPER;
        protected static final char[] DATA_LATIN_ALPHA_LOWER;
        protected static final char[] DATA_ALPHA;
        protected static final char[] DATA_SPEC;
        protected static final char[] DATA_SPEC_EXTEND;
        protected static final char[] DATA_ALPHA_NUM;
        protected static final char[] DATA_ALPHA_SPEC;
        protected static final char[] DATA_ALPHA_NUM_SPEC;
        protected static final char[] DATA_LATIN_ALPHA_NUM;
        protected static final char[] DATA_LATIN_ALPHA_UPPER_LOWER_NUM_SPEC;
        private static final /* synthetic */ Chars[] $VALUES;

        public static Chars[] values() {
            return (Chars[])$VALUES.clone();
        }

        public static Chars valueOf(String name) {
            return Enum.valueOf(Chars.class, name);
        }

        abstract char[] getData();

        private static char[] merge(char[] ... arrays) {
            int totalLen = 0;
            for (char[] array : arrays) {
                totalLen += array.length;
            }
            char[] result = new char[totalLen];
            int p = 0;
            for (char[] arr : arrays) {
                System.arraycopy(arr, 0, result, p, arr.length);
                p += arr.length;
            }
            return result;
        }

        static {
            int i;
            NUM = new Chars(){

                @Override
                char[] getData() {
                    return DATA_NUM;
                }
            };
            LATIN_ALPHA_UPPER = new Chars(){

                @Override
                char[] getData() {
                    return DATA_LATIN_ALPHA_UPPER;
                }
            };
            LATIN_ALPHA_LOWER = new Chars(){

                @Override
                char[] getData() {
                    return DATA_LATIN_ALPHA_LOWER;
                }
            };
            LATIN_ALPHA_UPPER_LOWER_NUM_SPEC = new Chars(){

                @Override
                char[] getData() {
                    return DATA_LATIN_ALPHA_UPPER_LOWER_NUM_SPEC;
                }
            };
            ALPHA = new Chars(){

                @Override
                char[] getData() {
                    return DATA_ALPHA;
                }
            };
            SPEC = new Chars(){

                @Override
                char[] getData() {
                    return DATA_SPEC_EXTEND;
                }
            };
            ALPHA_NUM = new Chars(){

                @Override
                char[] getData() {
                    return DATA_ALPHA_NUM;
                }
            };
            ALPHA_SPEC = new Chars(){

                @Override
                char[] getData() {
                    return DATA_ALPHA_SPEC;
                }
            };
            ALPHA_NUM_SPEC = new Chars(){

                @Override
                char[] getData() {
                    return DATA_ALPHA_NUM_SPEC;
                }
            };
            LATIN_ALPHA_NUM = new Chars(){

                @Override
                char[] getData() {
                    return DATA_LATIN_ALPHA_NUM;
                }
            };
            $VALUES = new Chars[]{NUM, LATIN_ALPHA_UPPER, LATIN_ALPHA_LOWER, LATIN_ALPHA_UPPER_LOWER_NUM_SPEC, ALPHA, SPEC, ALPHA_NUM, ALPHA_SPEC, ALPHA_NUM_SPEC, LATIN_ALPHA_NUM};
            DATA_NUM = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
            DATA_LATIN_ALPHA_UPPER = new char[26];
            int c = 0;
            for (i = 65; i < 91; ++i) {
                Chars.DATA_LATIN_ALPHA_UPPER[c++] = (char)i;
            }
            DATA_LATIN_ALPHA_LOWER = new char[26];
            c = 0;
            for (i = 97; i < 123; ++i) {
                Chars.DATA_LATIN_ALPHA_LOWER[c++] = (char)i;
            }
            DATA_ALPHA = new char[118];
            c = 0;
            for (i = 65; i < 91; ++i) {
                Chars.DATA_ALPHA[c++] = (char)i;
            }
            for (i = 97; i < 123; ++i) {
                Chars.DATA_ALPHA[c++] = (char)i;
            }
            for (i = 1040; i < 1106; ++i) {
                Chars.DATA_ALPHA[c++] = (char)i;
            }
            DATA_SPEC = new char[]{'_', '-', '~', '!', '#', '$', '%', '^', '&', '*', '(', ')', '{', '}', '[', ']', '+', '=', ':', '<', '>', '?', '/', '@', '.', ',', '|'};
            DATA_SPEC_EXTEND = Chars.merge({'\r', '\n', '\t', ' ', '\"', '\'', '\\', '`', '\u00a0'}, DATA_SPEC);
            DATA_ALPHA_NUM = Chars.merge(DATA_ALPHA, DATA_NUM);
            DATA_ALPHA_SPEC = Chars.merge(DATA_ALPHA, DATA_SPEC_EXTEND);
            DATA_ALPHA_NUM_SPEC = Chars.merge(DATA_ALPHA, DATA_NUM, DATA_SPEC_EXTEND);
            DATA_LATIN_ALPHA_NUM = Chars.merge(DATA_LATIN_ALPHA_UPPER, DATA_NUM);
            DATA_LATIN_ALPHA_UPPER_LOWER_NUM_SPEC = Chars.merge(DATA_LATIN_ALPHA_UPPER, DATA_LATIN_ALPHA_LOWER, DATA_NUM, DATA_SPEC);
        }
    }
}

