/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.google.common.base.Supplier;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    public static <T> T getValue(Class<?> cls, Object object, String propertyName) {
        try {
            Field field = ReflectionUtil.findField(cls, propertyName);
            if (field == null) {
                return null;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (T)field.get(object);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ReflectionUtil.class).error("unable to get value for a field " + propertyName, (Throwable)e);
            return null;
        }
    }

    private static Field findField(Class<?> cls, String propertyName) {
        for (Field fld : cls.getDeclaredFields()) {
            if (!propertyName.equals(fld.getName())) continue;
            return fld;
        }
        if (cls.getSuperclass() != null && !Object.class.equals(cls.getSuperclass())) {
            return ReflectionUtil.findField(cls.getSuperclass(), propertyName);
        }
        return null;
    }

    public static void setValue(Class<?> cls, Object object, String propertyName, Object value) {
        try {
            Field field = ReflectionUtil.findField(cls, propertyName);
            if (field == null) {
                return;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ReflectionUtil.class).error("unable to set value for a field " + propertyName, (Throwable)e);
        }
    }

    public static Collection<Field> getAllDeclaredFields(Class<?> cls) {
        if (cls.getSuperclass() == null || Object.class.equals(cls.getSuperclass())) {
            return Arrays.asList(cls.getDeclaredFields());
        }
        return CollectionUtil.union(ReflectionUtil.getAllDeclaredFields(cls.getSuperclass()), Arrays.asList(cls.getDeclaredFields()));
    }

    public static Collection<Method> getAllDeclaredMethods(Class<?> cls) {
        if (cls.getSuperclass() == null || Object.class.equals(cls.getSuperclass())) {
            return Arrays.asList(cls.getDeclaredMethods());
        }
        return CollectionUtil.union(ReflectionUtil.getAllDeclaredMethods(cls.getSuperclass()), Arrays.asList(cls.getDeclaredMethods()));
    }

    private static Method findMethod(Class<?> cls, String methodName) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        if (cls.getSuperclass() != null && !Object.class.equals(cls.getSuperclass())) {
            return ReflectionUtil.findMethod(cls.getSuperclass(), methodName);
        }
        return null;
    }

    public static void setMethodValue(Class<?> cls, Object object, String propertyName, Object value) {
        try {
            Method method = ReflectionUtil.findMethod(cls, "set" + TextUtil.capitalize(propertyName));
            if (method == null) {
                return;
            }
            method.invoke(object, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ReflectionUtil.class).error("unable to set value for a property " + propertyName, (Throwable)e);
        }
    }

    private static <T> int length(T[] arr) {
        return arr == null ? 0 : arr.length;
    }

    static <T> Collection<Constructor<T>> findPublicConstructors(Class<T> cls, Object ... parameters) {
        ArrayList<Constructor<T>> candidates = new ArrayList<Constructor<T>>();
        for (Constructor<?> m : cls.getConstructors()) {
            Constructor<?> c = m;
            Class<?>[] requiredTypes = c.getParameterTypes();
            int paramTypesLength = ReflectionUtil.length(requiredTypes);
            if (paramTypesLength != ReflectionUtil.length(parameters)) continue;
            boolean isCandidate = true;
            for (int i = 0; i < paramTypesLength; ++i) {
                Class<?> actualType;
                Object param = parameters[i];
                Class<?> clazz = actualType = param == null ? null : param.getClass();
                if (ClassUtils.isAssignable(actualType, requiredTypes[i], (boolean)true)) continue;
                isCandidate = false;
                break;
            }
            if (!isCandidate) continue;
            candidates.add(c);
        }
        return candidates;
    }

    static <T> Constructor<T> findSinglePublicConstructor(Class<T> cls, Object ... parameters) {
        Collection<Constructor<T>> candidates = ReflectionUtil.findPublicConstructors(cls, parameters);
        if (candidates.isEmpty()) {
            throw new IllegalStateException("no constructors found for class " + cls.getName() + " the given parameters " + parameters);
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException("more than one constructor found for class " + cls.getName() + " for the given parameters " + parameters + ": " + candidates);
        }
        return CollectionUtil.head(candidates);
    }

    public static <T> T createBySystemPropertyName(ClassLoader cl, String sysPropName, Logger log, Supplier<T> defaultSupplier) {
        return ReflectionUtil.createBySystemPropertyName(cl, sysPropName, log, null, defaultSupplier);
    }

    public static <T> T createBySystemPropertyName(ClassLoader cl, String sysPropName, Logger log, Object[] params, Supplier<T> defaultSupplier) {
        String clsName = System.getProperty(sysPropName);
        Object e = null;
        if (clsName != null) {
            try {
                Class<?> cls = cl.loadClass(clsName);
                return (T)ReflectionUtil.findSinglePublicConstructor(cls, params).newInstance(params);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)defaultSupplier.get();
    }

    public static <T> T createBySystemPropertyName(String sysPropName, Logger log, Object[] params, Supplier<T> defaultSupplier) {
        return ReflectionUtil.createBySystemPropertyName(ReflectionUtil.class.getClassLoader(), sysPropName, log, params, defaultSupplier);
    }

    public static <T> T createBySystemPropertyName(String sysPropName, Logger log, Supplier<T> defaultSupplier) {
        return ReflectionUtil.createBySystemPropertyName(ReflectionUtil.class.getClassLoader(), sysPropName, log, defaultSupplier);
    }

    public static MethodHandle getMethodHandleForField(Class<?> clz, String fieldName) {
        try {
            Field field = clz.getDeclaredField(fieldName);
            field.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.unreflectGetter(field);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getField(MethodHandle handle, Object arg) {
        try {
            return (T)handle.invoke(arg);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

