/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Settings {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public Settings(Class<?> cls) {
        this(cls.getName());
    }

    public Settings(String name) {
        this.file = new File(Environment.getDataFolder(), String.format("settings/%s.properties", name));
    }

    public void save() {
        try {
            Properties props = new Properties();
            this.write(props);
            this.file.getParentFile().mkdirs();
            try (FileOutputStream strm = new FileOutputStream(this.file);){
                props.store(strm, null);
            }
            this.log.debug("settings saved to " + this.file);
        }
        catch (Exception e) {
            this.log.warn("failed saving settings to " + this.file, (Throwable)e);
        }
    }

    public void load() {
        try {
            Properties props = new Properties();
            if (this.file.isFile()) {
                try (FileInputStream strm = new FileInputStream(this.file);){
                    props.load(strm);
                }
            }
            this.read(props);
            this.log.debug("settings loaded from " + this.file);
        }
        catch (Exception e) {
            this.log.warn("failed loading settings from " + this.file, (Throwable)e);
        }
    }

    protected abstract void read(Properties var1) throws Exception;

    protected abstract void write(Properties var1) throws Exception;

    public static interface HasSettings {
        public Settings getSettings();
    }
}

