/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.google.common.collect.Maps;
import com.gridnine.xtrip.common.util.FuncUtil;
import com.gridnine.xtrip.common.util.IStopwatch;
import java.util.Map;
import org.slf4j.Logger;

public class Stopwatches {
    private static final ThreadLocal<IStopwatch> stopwatchTL = new ThreadLocal<IStopwatch>(){

        @Override
        protected IStopwatch initialValue() {
            return NO_WATCH;
        }
    };
    static final IStopwatch NO_WATCH = new IStopwatch(){

        @Override
        public IStopwatch stop() {
            return this;
        }

        @Override
        public IStopwatch start(String tag) {
            return this;
        }
    };

    public static IStopwatch get() {
        return stopwatchTL.get();
    }

    private static RealStopwatch install() {
        RealStopwatch result = new RealStopwatch();
        stopwatchTL.set(result);
        result.getRoot().doStart();
        return result;
    }

    static void uninstall() {
        stopwatchTL.set(NO_WATCH);
    }

    public static <T> T inRealStopwatch(String tag, Logger log, double fraction, final FuncUtil.Func1<T, RealStopwatch> f) {
        try {
            return Stopwatches.inRealStopwatchX(tag, log, fraction, new FuncUtil.Func1x<T, RealStopwatch, FuncUtil.FakeException>(){

                @Override
                public T apply(RealStopwatch swatch) {
                    return f.apply(swatch);
                }
            });
        }
        catch (FuncUtil.FakeException e) {
            throw new IllegalStateException();
        }
    }

    public static <T, X extends Exception> T inRealStopwatchX(String tag, Logger log, double fraction, final FuncUtil.Func1x<T, RealStopwatch, X> f) throws X {
        try {
            return Stopwatches.inRealStopwatchXX(tag, log, fraction, new FuncUtil.Func1xx<T, RealStopwatch, X, FuncUtil.FakeException>(){

                @Override
                public T apply(RealStopwatch swatch) throws Exception {
                    return f.apply(swatch);
                }
            });
        }
        catch (FuncUtil.FakeException e) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X1 extends Exception, X2 extends Exception> T inRealStopwatchXX(String tag, Logger log, double fraction, FuncUtil.Func1xx<T, RealStopwatch, X1, X2> f) throws X1, X2 {
        StopwatchInstallation inst = Stopwatches.installIfNone();
        try {
            T t;
            block9: {
                if (!inst.installedByMe) {
                    inst.stopwatch.start(tag);
                }
                try {
                    t = f.apply(inst.stopwatch);
                    if (inst.installedByMe) break block9;
                    inst.stopwatch.stop();
                }
                catch (Throwable throwable) {
                    if (!inst.installedByMe) {
                        inst.stopwatch.stop();
                    }
                    throw throwable;
                }
            }
            return t;
        }
        finally {
            String timing = inst.finish(fraction);
            if (timing != null) {
                log.debug(tag + " " + timing);
            }
        }
    }

    public static <X extends Exception> void inRealStopwatchX(String tag, Logger log, double fraction, final FuncUtil.Proc1x<RealStopwatch, X> proc) throws X {
        Stopwatches.inRealStopwatchX(tag, log, fraction, new FuncUtil.Func1x<Void, RealStopwatch, X>(){

            @Override
            public Void apply(RealStopwatch swatch) throws Exception {
                proc.apply(swatch);
                return null;
            }
        });
    }

    public static <X1 extends Exception, X2 extends Exception> void inRealStopwatchXX(String tag, Logger log, double fraction, final FuncUtil.Proc1xx<RealStopwatch, X1, X2> proc) throws X1, X2 {
        Stopwatches.inRealStopwatchXX(tag, log, fraction, new FuncUtil.Func1xx<Void, RealStopwatch, X1, X2>(){

            @Override
            public Void apply(RealStopwatch swatch) throws Exception, Exception {
                proc.apply(swatch);
                return null;
            }
        });
    }

    public static void inRealStopwatch(String tag, Logger log, double fraction, final FuncUtil.Proc1<RealStopwatch> p) {
        Stopwatches.inRealStopwatch(tag, log, fraction, new FuncUtil.Func1<Void, RealStopwatch>(){

            @Override
            public Void apply(RealStopwatch swatch) {
                p.apply(swatch);
                return null;
            }
        });
    }

    public static StopwatchInstallation installIfNone() {
        IStopwatch currentStopwatch = Stopwatches.get();
        if (currentStopwatch instanceof RealStopwatch) {
            return new StopwatchInstallation(false, (RealStopwatch)currentStopwatch);
        }
        return new StopwatchInstallation(true, Stopwatches.install());
    }

    public static String dump(RealStopwatch watch, double fractionThreshold) {
        StringBuilder sb = new StringBuilder();
        long threshold = (long)((double)watch.root.duration * fractionThreshold);
        Stopwatches.dump(watch.root, sb, threshold, 0);
        return sb.toString();
    }

    public static void dump(RealStopwatch.StopwatchNode node, StringBuilder sb, double threshold, int level) {
        if (level == 0 || (double)node.duration >= threshold) {
            String fixedTag = Stopwatches.fixedTag(node.tag);
            sb.append(String.format("<%s ms=\"%d\" n=\"%d\" avg_ms=\"%.2f\" min_ms=\"%s\" max_ms=\"%s\" stddev_ms=\"%.2f\"", fixedTag, node.duration, node.numberOfInvocations, node.numberOfInvocations == 0 ? "NaN" : Double.valueOf((double)node.duration / (double)node.numberOfInvocations), node.min, node.max, node.stddev()));
            if (node.children.values().isEmpty()) {
                sb.append("/>");
            } else {
                sb.append(">");
                for (RealStopwatch.StopwatchNode child : node.children.values()) {
                    Stopwatches.dump(child, sb, threshold, level + 1);
                }
                sb.append("</" + fixedTag + ">");
            }
        }
    }

    private static String fixedTag(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') {
                sb.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    public static class RealStopwatch
    implements IStopwatch {
        final StopwatchNode root;
        private StopwatchNode current;

        public RealStopwatch() {
            this.current = this.root = new StopwatchNode(null, "ROOT");
        }

        @Override
        public IStopwatch start(String tag) {
            this.current = this.current.start(tag);
            return this;
        }

        @Override
        public IStopwatch stop() {
            if (this.current != this.root) {
                this.current = this.current.stop();
            }
            return this;
        }

        public void complete() {
            while (this.current != this.root) {
                this.current = this.current.stop();
            }
            this.root.stop();
        }

        public StopwatchNode getRoot() {
            return this.root;
        }

        public static class StopwatchNode {
            final StopwatchNode parent;
            final Map<String, StopwatchNode> children = Maps.newLinkedHashMap();
            final String tag;
            private long start;
            long duration;
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            long sumSq;
            int numberOfInvocations;

            public StopwatchNode(StopwatchNode parent, String tag) {
                this.parent = parent;
                this.tag = tag;
            }

            void doStart() {
                this.start = System.currentTimeMillis();
                ++this.numberOfInvocations;
            }

            public StopwatchNode start(String childTag) {
                StopwatchNode child = this.children.get(childTag);
                if (child == null) {
                    child = new StopwatchNode(this, childTag);
                    this.children.put(childTag, child);
                }
                child.doStart();
                return child;
            }

            public double stddev() {
                if (this.numberOfInvocations == 0) {
                    return 0.0;
                }
                return Math.sqrt(Math.abs(((double)this.sumSq - (double)(this.duration * this.duration) / (double)this.numberOfInvocations) / (double)this.numberOfInvocations));
            }

            public StopwatchNode stop() {
                long delta = System.currentTimeMillis() - this.start;
                this.duration += delta;
                this.sumSq += delta * delta;
                if (delta < this.min) {
                    this.min = delta;
                }
                if (delta > this.max) {
                    this.max = delta;
                }
                return this.parent;
            }
        }
    }

    public static class StopwatchInstallation {
        final boolean installedByMe;
        public final RealStopwatch stopwatch;

        StopwatchInstallation(boolean installedByMe, RealStopwatch stopwatch) {
            this.installedByMe = installedByMe;
            this.stopwatch = stopwatch;
        }

        public String finish(double fraction) {
            if (this.installedByMe) {
                this.stopwatch.complete();
                Stopwatches.uninstall();
                return Stopwatches.dump(this.stopwatch, fraction);
            }
            return null;
        }
    }
}

