/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Predicates;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Streams {
    private Streams() {
        throw new RuntimeException("don't do this");
    }

    public static <T> Supplier<T> toUnchecked(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            HashMap result = new HashMap();
            for (Object item : list) {
                Object key = keyMapper.apply((Object)item);
                Object value = valueMapper.apply((Object)item);
                if (result.containsKey(key)) {
                    throw new IllegalStateException(String.format("Duplicate key %s", key));
                }
                result.put(key, value);
            }
            return result;
        });
    }

    public static <I, O extends I> Stream<O> filter(Stream<I> in, Predicates.NarrowingPredicate<I, O> p) {
        if (in == null) {
            return null;
        }
        return in.filter(p);
    }

    public static <E, P> Map<P, E> valuesToMap(Stream<E> stream, Function<E, P> keyMapper) {
        if (stream == null || keyMapper == null) {
            return Collections.emptyMap();
        }
        return stream.collect(Collectors.toMap(keyMapper, Function.identity(), (first, second) -> first));
    }

    public static <E, P> Map<E, P> keysToMap(Stream<E> stream, Function<E, P> valueMapper) {
        if (stream == null || valueMapper == null) {
            return Collections.emptyMap();
        }
        return stream.collect(Collectors.toMap(Function.identity(), valueMapper, (first, second) -> first));
    }

    public static <T> Stream<T> of(T[] ... ts) {
        return Stream.of(ts).flatMap(Stream::of);
    }

    public static <T> T single(Stream<T> stream) {
        return CollectionUtil.single(stream.iterator());
    }

    public static <T> T singleOrNull(Stream<T> stream) {
        return CollectionUtil.singleOrNull(stream.iterator());
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

