/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class TranslitUtil {
    public static String cyr2lat(String data, TranslitRules rules) {
        return data == null ? null : rules.cyr2lat(data);
    }

    public static String cyr2latWithDelimiter(String data, TranslitRules rules, char delimiter) {
        return data == null ? null : rules.cyr2latWithDelimiter(data, delimiter);
    }

    public static enum TranslitRules implements ITranslitRules
    {
        US_DEPARTMENT_OF_STATE{
            private final Map<Character, String> table = new HashMap<Character, String>();
            public static final String handledCharsString = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
            private static final String useEPrevChars = "\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u0411\u0412\u0413\u0414\u0416\u0417\u0419\u041a\u041b\u041c\u041d\u041f\u0420\u0421\u0422\u0424\u0425\u0426\u0427\u0428\u0429";
            private static final String exceptionsString = "\u0435\u0451\u0415\u0401";
            {
                this.table.put(Character.valueOf('\u0430'), "a");
                this.table.put(Character.valueOf('\u0431'), "b");
                this.table.put(Character.valueOf('\u0432'), "v");
                this.table.put(Character.valueOf('\u0433'), "g");
                this.table.put(Character.valueOf('\u0434'), "d");
                this.table.put(Character.valueOf('\u0436'), "zh");
                this.table.put(Character.valueOf('\u0437'), "z");
                this.table.put(Character.valueOf('\u0438'), "i");
                this.table.put(Character.valueOf('\u0439'), "y");
                this.table.put(Character.valueOf('\u043a'), "k");
                this.table.put(Character.valueOf('\u043b'), "l");
                this.table.put(Character.valueOf('\u043c'), "m");
                this.table.put(Character.valueOf('\u043d'), "n");
                this.table.put(Character.valueOf('\u043e'), "o");
                this.table.put(Character.valueOf('\u043f'), "p");
                this.table.put(Character.valueOf('\u0440'), "r");
                this.table.put(Character.valueOf('\u0441'), "s");
                this.table.put(Character.valueOf('\u0442'), "t");
                this.table.put(Character.valueOf('\u0443'), "u");
                this.table.put(Character.valueOf('\u0444'), "f");
                this.table.put(Character.valueOf('\u0445'), "kh");
                this.table.put(Character.valueOf('\u0446'), "ts");
                this.table.put(Character.valueOf('\u0447'), "ch");
                this.table.put(Character.valueOf('\u0448'), "sh");
                this.table.put(Character.valueOf('\u0449'), "shch");
                this.table.put(Character.valueOf('\u044a'), "");
                this.table.put(Character.valueOf('\u044b'), "y");
                this.table.put(Character.valueOf('\u044c'), "");
                this.table.put(Character.valueOf('\u044d'), "e");
                this.table.put(Character.valueOf('\u044e'), "yu");
                this.table.put(Character.valueOf('\u044f'), "ya");
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0416'), "Zh");
                this.table.put(Character.valueOf('\u0417'), "Z");
                this.table.put(Character.valueOf('\u0418'), "I");
                this.table.put(Character.valueOf('\u0419'), "Y");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "Kh");
                this.table.put(Character.valueOf('\u0426'), "Ts");
                this.table.put(Character.valueOf('\u0427'), "Ch");
                this.table.put(Character.valueOf('\u0428'), "Sh");
                this.table.put(Character.valueOf('\u0429'), "Shch");
                this.table.put(Character.valueOf('\u042a'), "");
                this.table.put(Character.valueOf('\u042b'), "Y");
                this.table.put(Character.valueOf('\u042c'), "");
                this.table.put(Character.valueOf('\u042d'), "E");
                this.table.put(Character.valueOf('\u042e'), "Yu");
                this.table.put(Character.valueOf('\u042f'), "Ya");
            }

            private String cyr2lat(char ch, char prevCh) {
                if (handledCharsString.indexOf(ch) >= 0) {
                    int exInd = exceptionsString.indexOf(ch);
                    if (exInd >= 0) {
                        if (useEPrevChars.indexOf(prevCh) >= 0) {
                            return exInd < 2 ? "e" : "E";
                        }
                        return exInd < 2 ? "ye" : "Ye";
                    }
                    return this.table.get(Character.valueOf(ch));
                }
                return String.valueOf(ch);
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder();
                char prevCh = '\u0000';
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    result.append(this.cyr2lat(ch, prevCh));
                    prevCh = ch;
                }
                return result.toString();
            }
        }
        ,
        GOST_52535_1_2006{
            private final Map<Character, String> table = new HashMap<Character, String>();
            public static final String handledCharsString = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0430'), "a");
                this.table.put(Character.valueOf('\u0431'), "b");
                this.table.put(Character.valueOf('\u0432'), "v");
                this.table.put(Character.valueOf('\u0433'), "g");
                this.table.put(Character.valueOf('\u0434'), "d");
                this.table.put(Character.valueOf('\u0435'), "e");
                this.table.put(Character.valueOf('\u0451'), "e");
                this.table.put(Character.valueOf('\u0436'), "zh");
                this.table.put(Character.valueOf('\u0437'), "z");
                this.table.put(Character.valueOf('\u0438'), "i");
                this.table.put(Character.valueOf('\u0439'), "i");
                this.table.put(Character.valueOf('\u043a'), "k");
                this.table.put(Character.valueOf('\u043b'), "l");
                this.table.put(Character.valueOf('\u043c'), "m");
                this.table.put(Character.valueOf('\u043d'), "n");
                this.table.put(Character.valueOf('\u043e'), "o");
                this.table.put(Character.valueOf('\u043f'), "p");
                this.table.put(Character.valueOf('\u0440'), "r");
                this.table.put(Character.valueOf('\u0441'), "s");
                this.table.put(Character.valueOf('\u0442'), "t");
                this.table.put(Character.valueOf('\u0443'), "u");
                this.table.put(Character.valueOf('\u0444'), "f");
                this.table.put(Character.valueOf('\u0445'), "kh");
                this.table.put(Character.valueOf('\u0446'), "tc");
                this.table.put(Character.valueOf('\u0447'), "ch");
                this.table.put(Character.valueOf('\u0448'), "sh");
                this.table.put(Character.valueOf('\u0449'), "shch");
                this.table.put(Character.valueOf('\u044a'), "");
                this.table.put(Character.valueOf('\u044b'), "y");
                this.table.put(Character.valueOf('\u044c'), "");
                this.table.put(Character.valueOf('\u044d'), "e");
                this.table.put(Character.valueOf('\u044e'), "iu");
                this.table.put(Character.valueOf('\u044f'), "ia");
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0415'), "E");
                this.table.put(Character.valueOf('\u0401'), "E");
                this.table.put(Character.valueOf('\u0416'), "Zh");
                this.table.put(Character.valueOf('\u0417'), "Z");
                this.table.put(Character.valueOf('\u0418'), "I");
                this.table.put(Character.valueOf('\u0419'), "I");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "KH");
                this.table.put(Character.valueOf('\u0426'), "TC");
                this.table.put(Character.valueOf('\u0427'), "CH");
                this.table.put(Character.valueOf('\u0428'), "SH");
                this.table.put(Character.valueOf('\u0429'), "SHCH");
                this.table.put(Character.valueOf('\u042a'), "");
                this.table.put(Character.valueOf('\u042b'), "Y");
                this.table.put(Character.valueOf('\u042c'), "");
                this.table.put(Character.valueOf('\u042d'), "E");
                this.table.put(Character.valueOf('\u042e'), "IU");
                this.table.put(Character.valueOf('\u042f'), "IA");
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder((int)((double)data.length() * 1.25));
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    if (handledCharsString.indexOf(ch) >= 0) {
                        result.append(this.table.get(Character.valueOf(ch)));
                        continue;
                    }
                    result.append(ch);
                }
                return result.toString();
            }

            @Override
            public String cyr2latWithDelimiter(String data, char delimiter) {
                String spacedData = data.chars().mapToObj(c -> Character.valueOf((char)c)).flatMap(c -> Stream.of(c, Character.valueOf(delimiter))).limit(data.length() * 2 - 1).collect(StringBuilder::new, (b, c) -> b.append(c), (b, c) -> b.append((CharSequence)c)).toString();
                return this.cyr2lat(spacedData);
            }
        }
        ,
        GOST_R_ISO_IEC_7501_1_2013{
            private final Map<Character, String> table = new HashMap<Character, String>();
            public static final String handledCharsString = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0430'), "a");
                this.table.put(Character.valueOf('\u0431'), "b");
                this.table.put(Character.valueOf('\u0432'), "v");
                this.table.put(Character.valueOf('\u0433'), "g");
                this.table.put(Character.valueOf('\u0434'), "d");
                this.table.put(Character.valueOf('\u0435'), "e");
                this.table.put(Character.valueOf('\u0451'), "e");
                this.table.put(Character.valueOf('\u0436'), "zh");
                this.table.put(Character.valueOf('\u0437'), "z");
                this.table.put(Character.valueOf('\u0438'), "i");
                this.table.put(Character.valueOf('\u0439'), "i");
                this.table.put(Character.valueOf('\u043a'), "k");
                this.table.put(Character.valueOf('\u043b'), "l");
                this.table.put(Character.valueOf('\u043c'), "m");
                this.table.put(Character.valueOf('\u043d'), "n");
                this.table.put(Character.valueOf('\u043e'), "o");
                this.table.put(Character.valueOf('\u043f'), "p");
                this.table.put(Character.valueOf('\u0440'), "r");
                this.table.put(Character.valueOf('\u0441'), "s");
                this.table.put(Character.valueOf('\u0442'), "t");
                this.table.put(Character.valueOf('\u0443'), "u");
                this.table.put(Character.valueOf('\u0444'), "f");
                this.table.put(Character.valueOf('\u0445'), "kh");
                this.table.put(Character.valueOf('\u0446'), "ts");
                this.table.put(Character.valueOf('\u0447'), "ch");
                this.table.put(Character.valueOf('\u0448'), "sh");
                this.table.put(Character.valueOf('\u0449'), "shch");
                this.table.put(Character.valueOf('\u044a'), "ie");
                this.table.put(Character.valueOf('\u044b'), "y");
                this.table.put(Character.valueOf('\u044c'), "");
                this.table.put(Character.valueOf('\u044d'), "e");
                this.table.put(Character.valueOf('\u044e'), "iu");
                this.table.put(Character.valueOf('\u044f'), "ia");
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0415'), "E");
                this.table.put(Character.valueOf('\u0401'), "E");
                this.table.put(Character.valueOf('\u0416'), "Zh");
                this.table.put(Character.valueOf('\u0417'), "Z");
                this.table.put(Character.valueOf('\u0418'), "I");
                this.table.put(Character.valueOf('\u0419'), "I");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "KH");
                this.table.put(Character.valueOf('\u0426'), "TS");
                this.table.put(Character.valueOf('\u0427'), "CH");
                this.table.put(Character.valueOf('\u0428'), "SH");
                this.table.put(Character.valueOf('\u0429'), "SHCH");
                this.table.put(Character.valueOf('\u042a'), "IE");
                this.table.put(Character.valueOf('\u042b'), "Y");
                this.table.put(Character.valueOf('\u042c'), "");
                this.table.put(Character.valueOf('\u042d'), "E");
                this.table.put(Character.valueOf('\u042e'), "IU");
                this.table.put(Character.valueOf('\u042f'), "IA");
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder((int)((double)data.length() * 1.25));
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    if (handledCharsString.indexOf(ch) >= 0) {
                        result.append(this.table.get(Character.valueOf(ch)));
                        continue;
                    }
                    result.append(ch);
                }
                return result.toString();
            }

            @Override
            public String cyr2latWithDelimiter(String data, char delimiter) {
                String spacedData = data.chars().mapToObj(c -> Character.valueOf((char)c)).flatMap(c -> Stream.of(c, Character.valueOf(delimiter))).limit((long)data.length() * 2L - 1L).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
                return this.cyr2lat(spacedData);
            }
        }
        ,
        HTML_ENTITIES{
            private final Map<Character, String> table = new HashMap<Character, String>();
            public static final String handledCharsString = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0430'), "&#1072;");
                this.table.put(Character.valueOf('\u0431'), "&#1073;");
                this.table.put(Character.valueOf('\u0432'), "&#1074;");
                this.table.put(Character.valueOf('\u0433'), "&#1075;");
                this.table.put(Character.valueOf('\u0434'), "&#1076;");
                this.table.put(Character.valueOf('\u0435'), "&#1077;");
                this.table.put(Character.valueOf('\u0451'), "&#1105;");
                this.table.put(Character.valueOf('\u0436'), "&#1078;");
                this.table.put(Character.valueOf('\u0437'), "&#1079;");
                this.table.put(Character.valueOf('\u0438'), "&#1080;");
                this.table.put(Character.valueOf('\u0439'), "&#1081;");
                this.table.put(Character.valueOf('\u043a'), "&#1082;");
                this.table.put(Character.valueOf('\u043b'), "&#1083;");
                this.table.put(Character.valueOf('\u043c'), "&#1084;");
                this.table.put(Character.valueOf('\u043d'), "&#1085;");
                this.table.put(Character.valueOf('\u043e'), "&#1086;");
                this.table.put(Character.valueOf('\u043f'), "&#1087;");
                this.table.put(Character.valueOf('\u0440'), "&#1088;");
                this.table.put(Character.valueOf('\u0441'), "&#1089;");
                this.table.put(Character.valueOf('\u0442'), "&#1090;");
                this.table.put(Character.valueOf('\u0443'), "&#1091;");
                this.table.put(Character.valueOf('\u0444'), "&#1092;");
                this.table.put(Character.valueOf('\u0445'), "&#1093;");
                this.table.put(Character.valueOf('\u0446'), "&#1094;");
                this.table.put(Character.valueOf('\u0447'), "&#1095;");
                this.table.put(Character.valueOf('\u0448'), "&#1096;");
                this.table.put(Character.valueOf('\u0449'), "&#1097;");
                this.table.put(Character.valueOf('\u044a'), "&#1098;");
                this.table.put(Character.valueOf('\u044b'), "&#1099;");
                this.table.put(Character.valueOf('\u044c'), "&#1100;");
                this.table.put(Character.valueOf('\u044d'), "&#1101;");
                this.table.put(Character.valueOf('\u044e'), "&#1102;");
                this.table.put(Character.valueOf('\u044f'), "&#1103;");
                this.table.put(Character.valueOf('\u0410'), "&#1040;");
                this.table.put(Character.valueOf('\u0411'), "&#1041;");
                this.table.put(Character.valueOf('\u0412'), "&#1042;");
                this.table.put(Character.valueOf('\u0413'), "&#1043;");
                this.table.put(Character.valueOf('\u0414'), "&#1044;");
                this.table.put(Character.valueOf('\u0415'), "&#1045;");
                this.table.put(Character.valueOf('\u0401'), "&#1025;");
                this.table.put(Character.valueOf('\u0416'), "&#1046;");
                this.table.put(Character.valueOf('\u0417'), "&#1047;");
                this.table.put(Character.valueOf('\u0418'), "&#1048;");
                this.table.put(Character.valueOf('\u0419'), "&#1049;");
                this.table.put(Character.valueOf('\u041a'), "&#1050;");
                this.table.put(Character.valueOf('\u041b'), "&#1051;");
                this.table.put(Character.valueOf('\u041c'), "&#1052;");
                this.table.put(Character.valueOf('\u041d'), "&#1053;");
                this.table.put(Character.valueOf('\u041e'), "&#1054;");
                this.table.put(Character.valueOf('\u041f'), "&#1055;");
                this.table.put(Character.valueOf('\u0420'), "&#1056;");
                this.table.put(Character.valueOf('\u0421'), "&#1057;");
                this.table.put(Character.valueOf('\u0422'), "&#1058;");
                this.table.put(Character.valueOf('\u0423'), "&#1059;");
                this.table.put(Character.valueOf('\u0424'), "&#1060;");
                this.table.put(Character.valueOf('\u0425'), "&#1061;");
                this.table.put(Character.valueOf('\u0426'), "&#1062;");
                this.table.put(Character.valueOf('\u0427'), "&#1063;");
                this.table.put(Character.valueOf('\u0428'), "&#1064;");
                this.table.put(Character.valueOf('\u0429'), "&#1065;");
                this.table.put(Character.valueOf('\u042a'), "&#1066;");
                this.table.put(Character.valueOf('\u042b'), "&#1067;");
                this.table.put(Character.valueOf('\u042c'), "&#1068;");
                this.table.put(Character.valueOf('\u042d'), "&#1069;");
                this.table.put(Character.valueOf('\u042e'), "&#1070;");
                this.table.put(Character.valueOf('\u042f'), "&#1071;");
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder(data.length() * 3);
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    if (handledCharsString.indexOf(ch) >= 0) {
                        result.append(this.table.get(Character.valueOf(ch)));
                        continue;
                    }
                    result.append(ch);
                }
                return result.toString();
            }
        }
        ,
        SIRENA{
            private final Map<Character, String> table = new HashMap<Character, String>();
            public static final String handledCharsString = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0430'), "a");
                this.table.put(Character.valueOf('\u0431'), "b");
                this.table.put(Character.valueOf('\u0432'), "v");
                this.table.put(Character.valueOf('\u0433'), "g");
                this.table.put(Character.valueOf('\u0434'), "d");
                this.table.put(Character.valueOf('\u0435'), "e");
                this.table.put(Character.valueOf('\u0451'), "yo");
                this.table.put(Character.valueOf('\u0436'), "zh");
                this.table.put(Character.valueOf('\u0437'), "z");
                this.table.put(Character.valueOf('\u0438'), "i");
                this.table.put(Character.valueOf('\u0439'), "y");
                this.table.put(Character.valueOf('\u043a'), "k");
                this.table.put(Character.valueOf('\u043b'), "l");
                this.table.put(Character.valueOf('\u043c'), "m");
                this.table.put(Character.valueOf('\u043d'), "n");
                this.table.put(Character.valueOf('\u043e'), "o");
                this.table.put(Character.valueOf('\u043f'), "p");
                this.table.put(Character.valueOf('\u0440'), "r");
                this.table.put(Character.valueOf('\u0441'), "s");
                this.table.put(Character.valueOf('\u0442'), "t");
                this.table.put(Character.valueOf('\u0443'), "u");
                this.table.put(Character.valueOf('\u0444'), "f");
                this.table.put(Character.valueOf('\u0445'), "kh");
                this.table.put(Character.valueOf('\u0446'), "ts");
                this.table.put(Character.valueOf('\u0447'), "ch");
                this.table.put(Character.valueOf('\u0448'), "sh");
                this.table.put(Character.valueOf('\u0449'), "sh");
                this.table.put(Character.valueOf('\u044b'), "y");
                this.table.put(Character.valueOf('\u044d'), "e");
                this.table.put(Character.valueOf('\u044e'), "yu");
                this.table.put(Character.valueOf('\u044f'), "ya");
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0415'), "E");
                this.table.put(Character.valueOf('\u0401'), "YO");
                this.table.put(Character.valueOf('\u0416'), "ZH");
                this.table.put(Character.valueOf('\u0417'), "Z");
                this.table.put(Character.valueOf('\u0418'), "I");
                this.table.put(Character.valueOf('\u0419'), "Y");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "KH");
                this.table.put(Character.valueOf('\u0426'), "TS");
                this.table.put(Character.valueOf('\u0427'), "CH");
                this.table.put(Character.valueOf('\u0428'), "SH");
                this.table.put(Character.valueOf('\u0429'), "SH");
                this.table.put(Character.valueOf('\u042b'), "Y");
                this.table.put(Character.valueOf('\u042d'), "E");
                this.table.put(Character.valueOf('\u042e'), "YU");
                this.table.put(Character.valueOf('\u042f'), "YA");
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder((int)((double)data.length() * 1.25));
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    if (handledCharsString.indexOf(ch) >= 0) {
                        result.append(this.table.get(Character.valueOf(ch)));
                        continue;
                    }
                    result.append(ch);
                }
                return result.toString();
            }
        }
        ,
        SIRENA_SERVICE_CLASSES_RULES{
            private final Map<Character, String> table = new HashMap<Character, String>();
            private static final String handledCharsString = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0428\u042b\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0415'), "E");
                this.table.put(Character.valueOf('\u0416'), "Z");
                this.table.put(Character.valueOf('\u0418'), "J");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "X");
                this.table.put(Character.valueOf('\u0426'), "C");
                this.table.put(Character.valueOf('\u0428'), "W");
                this.table.put(Character.valueOf('\u042b'), "I");
                this.table.put(Character.valueOf('\u042d'), "Y");
                this.table.put(Character.valueOf('\u042e'), "W");
                this.table.put(Character.valueOf('\u042f'), "Q");
            }

            @Override
            public String cyr2lat(String data) {
                char ch = data.charAt(0);
                if (handledCharsString.indexOf(ch) >= 0) {
                    return this.table.get(Character.valueOf(ch));
                }
                return String.valueOf(ch);
            }
        }
        ,
        SIRENA_REDAPP_RULES{
            private final Map<Character, String> table = new HashMap<Character, String>();
            private static final String handledCharsString = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0428\u042b\u042d\u042e\u042f";
            {
                this.table.put(Character.valueOf('\u0410'), "A");
                this.table.put(Character.valueOf('\u0411'), "B");
                this.table.put(Character.valueOf('\u0412'), "V");
                this.table.put(Character.valueOf('\u0413'), "G");
                this.table.put(Character.valueOf('\u0414'), "D");
                this.table.put(Character.valueOf('\u0415'), "E");
                this.table.put(Character.valueOf('\u0416'), "Z");
                this.table.put(Character.valueOf('\u0418'), "J");
                this.table.put(Character.valueOf('\u041a'), "K");
                this.table.put(Character.valueOf('\u041b'), "L");
                this.table.put(Character.valueOf('\u041c'), "M");
                this.table.put(Character.valueOf('\u041d'), "N");
                this.table.put(Character.valueOf('\u041e'), "O");
                this.table.put(Character.valueOf('\u041f'), "P");
                this.table.put(Character.valueOf('\u0420'), "R");
                this.table.put(Character.valueOf('\u0421'), "S");
                this.table.put(Character.valueOf('\u0422'), "T");
                this.table.put(Character.valueOf('\u0423'), "U");
                this.table.put(Character.valueOf('\u0424'), "F");
                this.table.put(Character.valueOf('\u0425'), "X");
                this.table.put(Character.valueOf('\u0426'), "C");
                this.table.put(Character.valueOf('\u0428'), "W");
                this.table.put(Character.valueOf('\u042b'), "I");
                this.table.put(Character.valueOf('\u042d'), "Y");
                this.table.put(Character.valueOf('\u042e'), "W");
                this.table.put(Character.valueOf('\u042f'), "Q");
            }

            @Override
            public String cyr2lat(String data) {
                StringBuilder result = new StringBuilder((int)((double)data.length() * 1.25));
                for (int i = 0; i < data.length(); ++i) {
                    char ch = data.charAt(i);
                    if (handledCharsString.indexOf(ch) >= 0) {
                        result.append(this.table.get(Character.valueOf(ch)));
                        continue;
                    }
                    result.append(ch);
                }
                return result.toString();
            }
        };

    }

    private static interface ITranslitRules {
        public String cyr2lat(String var1);

        default public String cyr2latWithDelimiter(String data, char delimiter) {
            return this.cyr2lat(data);
        }
    }
}

