/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class XObjectInput
implements Closeable {
    private final DataInputStream dis;

    public XObjectInput(InputStream in) {
        this.dis = new DataInputStream(in);
    }

    public Date readDate() throws IOException {
        if (!this.dis.readBoolean()) {
            return null;
        }
        return new Date(this.dis.readLong());
    }

    public String readString() throws IOException {
        if (!this.dis.readBoolean()) {
            return null;
        }
        return this.dis.readUTF();
    }

    public <T> Class<T> readClass() throws ClassNotFoundException, IOException {
        if (!this.dis.readBoolean()) {
            return null;
        }
        return Class.forName(this.dis.readUTF());
    }

    public <T extends Enum<T>> T readEnum(Class<T> clazz) throws IOException {
        if (!this.dis.readBoolean()) {
            return null;
        }
        return Enum.valueOf(clazz, this.dis.readUTF());
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public byte[] readByteArray() throws IOException {
        if (!this.dis.readBoolean()) {
            return null;
        }
        int length = this.dis.readInt();
        byte[] data = new byte[length];
        this.dis.readFully(data);
        return data;
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }
}

