/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml.xstream.converters;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class XStreamJavaLocalDateConverter
implements SingleValueConverter {
    private final DateTimeFormatter dtf;

    public XStreamJavaLocalDateConverter(String format) {
        this.dtf = DateTimeFormatter.ofPattern(format);
    }

    public boolean canConvert(Class type) {
        return LocalDate.class.equals((Object)type);
    }

    public Object fromString(String str) {
        if (TextUtil.isBlank(str)) {
            return null;
        }
        try {
            return LocalDate.parse(str, this.dtf);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("fromString failed", ex, new Object[0]);
        }
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            LocalDate localDate = (LocalDate)obj;
            return localDate.format(this.dtf);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("toString failed", ex, new Object[0]);
        }
    }
}

