/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.l10n;

import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.UnsupportedCurrencyException;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BulgariaNumber2WordsConverter
implements Number2WordsConverter {
    private static final String NULA = "\u043d\u0443\u043b\u0430";
    private static final String DESET = "\u0434\u0435\u0441\u0435\u0442";
    private static final String EDINADESET = "\u0435\u0434\u0438\u043d\u0430\u0434\u0435\u0441\u0435\u0442";
    private static final String NA = "\u043d\u0430";
    private static final String STO = "\u0441\u0442\u043e";
    private static final String STA = "\u0441\u0442\u0430";
    private static final String STOTIN = "\u0441\u0442\u043e\u0442\u0438\u043d";
    private static final String HILIADI = "\u0445\u0438\u043b\u044f\u0434\u0438";
    private static final String INFINITY = "\u0431\u0435\u0437\u043a\u0440\u0430\u0439\u043d\u043e\u0441\u0442";
    private static final String AND = "\u0438";
    private static final String SEPARATOR = " ";
    private static final String MINUS = "\u043c\u0438\u043d\u0443\u0441";
    private static final String PLURAL = "\u0430";
    private static final Locale locale = new Locale("bg");
    private static final Set<String> currencies = new HashSet<String>();
    private static final String[] exponent = new String[]{"", "\u0445\u0438\u043b\u044f\u0434\u0430", "\u043c\u0438\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u0438\u0430\u0440\u0434", "\u0442\u0440\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u043d\u0430\u043b\u0438\u043e\u043d", "\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0443\u043d\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0434\u0435\u043a\u0430\u043b\u0438\u043e\u043d", "\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0443\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u0446\u0435\u043d\u0442\u0438\u043b\u0438\u043e\u043d"};
    private static final Map<Gender, String[]> digits = new HashMap<Gender, String[]>();

    public Locale getLocale() {
        return locale;
    }

    public Set<String> getCurrencies() {
        return Collections.unmodifiableSet(currencies);
    }

    public String toNumberWords(BigDecimal number) {
        if (number == null) {
            return NULA;
        }
        String numberString = number.toPlainString();
        if (Pattern.compile("^-?0+$").matcher(numberString).find() || !Pattern.compile("^-?\\d+$").matcher(numberString).find()) {
            return NULA;
        }
        StringBuilder wordsString = new StringBuilder();
        if (numberString.substring(0, 1).equals("-")) {
            wordsString.append("\u043c\u0438\u043d\u0443\u0441 ");
            numberString = numberString.substring(1);
        }
        if ((numberString = TextUtil.ltrim((String)numberString, (String)"0")).length() > exponent.length * 3) {
            wordsString.append(INFINITY);
            return wordsString.toString();
        }
        List<String> splitNumbers = this.splitNumber(numberString);
        for (int i = 0; i < splitNumbers.size(); ++i) {
            boolean last;
            String splitNumber = splitNumbers.get(i);
            int pow = splitNumbers.size() - i - 1;
            boolean bl = last = splitNumbers.size() > 1 && i == splitNumbers.size() - 1;
            if (Integer.parseInt(splitNumber) > 1) {
                if (pow == 0) {
                    wordsString.append(this.toWords(splitNumber, Gender.NEUTER, last) + SEPARATOR + exponent[pow] + SEPARATOR);
                    continue;
                }
                if (pow == 1) {
                    wordsString.append(this.toWords(splitNumber, Gender.FEMININE, last) + SEPARATOR + HILIADI + SEPARATOR);
                    continue;
                }
                wordsString.append(this.toWords(splitNumber, Gender.MASCULINE, last) + SEPARATOR + exponent[pow] + PLURAL + SEPARATOR);
                continue;
            }
            if (Integer.parseInt(splitNumber) != 1) continue;
            if (pow == 0) {
                wordsString.append(this.toWords(splitNumber, Gender.NEUTER, last) + SEPARATOR + exponent[pow] + SEPARATOR);
                continue;
            }
            if (pow == 1) {
                wordsString.append(exponent[pow] + SEPARATOR);
                continue;
            }
            wordsString.append(this.toWords(splitNumber, Gender.MASCULINE, last) + SEPARATOR + exponent[pow] + SEPARATOR);
        }
        return TextUtil.rtrim((String)wordsString.toString(), (String)SEPARATOR);
    }

    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction) throws UnsupportedCurrencyException {
        String numberWords;
        if (amount == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Currency is null");
        }
        if (!this.getCurrencies().contains(currency)) {
            throw new UnsupportedCurrencyException(String.format("Currency %s is not supported", currency));
        }
        StringBuilder currencyWords = new StringBuilder();
        String[] entries = amount.setScale(2, RoundingMode.HALF_UP).toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        BigDecimal fraction = new BigDecimal(entries[1]);
        if (!ignoreZeroDecimal || decimal.compareTo(BigDecimal.ZERO) != 0) {
            numberWords = this.toNumberWords(decimal);
            if (numberWords == null) {
                numberWords = NULA;
            }
            currencyWords.append(numberWords);
            currencyWords.append(SEPARATOR);
            currencyWords.append("\u043b\u0432.");
        }
        if (!ignoreZeroFraction || fraction.compareTo(BigDecimal.ZERO) != 0) {
            numberWords = this.toNumberWords(fraction);
            if (numberWords == null) {
                numberWords = NULA;
            }
            if (currencyWords.length() > 0) {
                currencyWords.append(SEPARATOR);
            }
            if (convertFraction) {
                currencyWords.append(numberWords);
            } else {
                currencyWords.append(String.format("%02d", fraction.intValue()));
            }
            currencyWords.append(SEPARATOR);
            currencyWords.append("\u0441\u0442.");
        }
        return currencyWords.toString();
    }

    private String toWords(String number, Gender gender, boolean last) {
        String[] words = new String[6];
        int digit = Integer.parseInt(number);
        int e = digit % 10;
        int d = digit % 100 / 10;
        int s = digit % 1000 / 100;
        int count = 0;
        if (s > 0) {
            words[1] = s == 1 ? STO : (s == 2 || s == 3 ? digits.get((Object)Gender.NEUTER)[s - 1] + STA : digits.get((Object)Gender.NEUTER)[s - 1] + STOTIN);
            ++count;
        }
        if (d > 0) {
            if (d == 1) {
                if (e == 0) {
                    words[3] = DESET;
                } else {
                    words[3] = e == 1 ? EDINADESET : digits.get((Object)Gender.MASCULINE)[e - 1] + NA + DESET;
                    e = 0;
                }
            } else {
                words[3] = digits.get((Object)Gender.MASCULINE)[d - 1] + DESET;
            }
            ++count;
        }
        if (e > 0) {
            words[5] = digits.get((Object)gender)[e - 1];
            ++count;
        }
        if (count > 1) {
            if (e > 0) {
                words[4] = AND;
            } else {
                words[2] = AND;
            }
        }
        if (last && (s == 0 || count == 1)) {
            words[0] = AND;
        }
        return TextUtil.join((String)SEPARATOR, Arrays.asList(words), (boolean)true);
    }

    private List<String> splitNumber(String number) {
        String last;
        ArrayList<String> numbers = new ArrayList<String>();
        String first = number.substring(0, number.length() % 3);
        if (first.length() > 0) {
            numbers.add(first);
        }
        if ((last = number.substring(first.length())).length() > 0) {
            numbers.addAll(Arrays.asList(last.split("(?<=\\G.{3})")));
        }
        return numbers;
    }

    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction, boolean shortName) throws UnsupportedCurrencyException {
        return this.toCurrencyWords(amount, currency, ignoreZeroDecimal, ignoreZeroFraction, convertFraction);
    }

    static {
        digits.put(Gender.NEUTER, new String[]{"\u0435\u0434\u043d\u043e", "\u0434\u0432\u0435", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u0438\u0440\u0438", "\u043f\u0435\u0442", "\u0448\u0435\u0441\u0442", "\u0441\u0435\u0434\u0435\u043c", "\u043e\u0441\u0435\u043c", "\u0434\u0435\u0432\u0435\u0442"});
        digits.put(Gender.MASCULINE, new String[]{"\u0435\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u0438\u0440\u0438", "\u043f\u0435\u0442", "\u0448\u0435\u0441\u0442", "\u0441\u0435\u0434\u0435\u043c", "\u043e\u0441\u0435\u043c", "\u0434\u0435\u0432\u0435\u0442"});
        digits.put(Gender.FEMININE, new String[]{"\u0435\u0434\u043d\u0430", "\u0434\u0432\u0435", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u0438\u0440\u0438", "\u043f\u0435\u0442", "\u0448\u0435\u0441\u0442", "\u0441\u0435\u0434\u0435\u043c", "\u043e\u0441\u0435\u043c", "\u0434\u0435\u0432\u0435\u0442"});
        currencies.add("EUR");
        currencies.add("BGN");
        currencies.add("KZT");
    }

    public static enum Gender {
        NEUTER,
        MASCULINE,
        FEMININE;

    }
}

