/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.rules.standard;

import com.gridnine.xtrip.common.bg.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Arrays;
import java.util.List;

public enum Properties implements RuleProperty
{
    TRANSPORTATION_TYPE{
        private final String domestic = "BG";
        private final String regional = "EURO";

        public String getDisplayName() {
            return "Route restrictions";
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_DOMESTIC.getId(), Conditions.TRANSPORTATION_REGIONAL.getId(), Conditions.TRANSPORTATION_INTERNATIONAL.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder stringBuilder, RuleCondition condition, Object value) {
            if (condition.hasRightSide()) {
                stringBuilder.append(L10n.replace((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString((Object)value)}));
            } else {
                stringBuilder.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{condition.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider propertiesProvider = (BasicAirTicketPropertiesProvider)propertySet;
            if (Conditions.TRANSPORTATION_DOMESTIC.equals(condition)) {
                return RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("BG"));
            }
            if (Conditions.TRANSPORTATION_REGIONAL.equals(condition)) {
                return RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("EURO"));
            }
            if (Conditions.TRANSPORTATION_INTERNATIONAL.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("BG-EURO"));
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

