/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.reports.render.amexreport;

import com.gridnine.xtrip.common.bg.reports.fields.BulgariaAmexReportFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaAmexReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.amexreport.BulgariaAmexReportTicket;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class BulgariaAmexCSVReportRender {
    private static final String SEPARATOR = ",";
    private static final String QUOTE = "\"";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    private static final ThreadLocal<SimpleDateFormat> TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm"));

    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        if (parameters.get("key-batch-data-list") == null) {
            return null;
        }
        ReportFile reportFile = new ReportFile();
        StringWriter out = new StringWriter();
        this.writeCSVData(parameters, out);
        reportFile.setContent(out.toString().getBytes(StandardCharsets.UTF_8));
        reportFile.setContentType(ContentType.TEXT);
        BulgariaAmexReportParameters reportParams = (BulgariaAmexReportParameters)parameters.get("key-report-params");
        Date startDate = reportParams.getPeriodBegin();
        String reportFileName = this.createReportName(startDate);
        reportFile.setTitle(reportFileName);
        reportFile.setName(reportFileName + ".csv");
        EntityContainer reportDocContainer = new EntityContainer(ReportDocument.class);
        ReportDocument reportDoc = (ReportDocument)reportDocContainer.getEntity();
        reportDoc.getFiles().add(reportFile);
        return reportDocContainer;
    }

    private String createReportName(Date startDate) {
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        String monthName = "";
        String year = "";
        if (startDate != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(startDate);
            cal.get(2);
            switch (cal.get(2)) {
                case 0: {
                    monthName = "january";
                    break;
                }
                case 1: {
                    monthName = "february";
                    break;
                }
                case 2: {
                    monthName = "march";
                    break;
                }
                case 3: {
                    monthName = "april";
                    break;
                }
                case 4: {
                    monthName = "may";
                    break;
                }
                case 5: {
                    monthName = "june";
                    break;
                }
                case 6: {
                    monthName = "july";
                    break;
                }
                case 7: {
                    monthName = "august";
                    break;
                }
                case 8: {
                    monthName = "september";
                    break;
                }
                case 9: {
                    monthName = "october";
                    break;
                }
                case 10: {
                    monthName = "november";
                    break;
                }
                case 11: {
                    monthName = "december";
                }
            }
            year = yearFormat.format(startDate);
        }
        return "AMEX_" + monthName + "_" + year;
    }

    private void writeCSVData(Map<String, Object> parameters, StringWriter out) {
        out.write(this.createHeaderString());
        out.write("\n");
        for (ReportBatchData batch : (List)parameters.get("key-batch-data-list")) {
            for (BulgariaAmexReportTicket ticket : batch.getTickets()) {
                out.write(this.createCSVString(ticket));
                out.write("\n");
            }
        }
    }

    private String createHeaderString() {
        StringBuilder builder = new StringBuilder();
        for (BulgariaAmexReportFields field : BulgariaAmexReportFields.values()) {
            builder.append(field.getColumnName()).append(SEPARATOR);
        }
        return builder.toString();
    }

    private String createCSVString(BulgariaAmexReportTicket ticket) {
        StringBuilder ticketString = new StringBuilder();
        for (BulgariaAmexReportFields field : BulgariaAmexReportFields.values()) {
            if (field.equals((Object)BulgariaAmexReportFields.INVOICE_DATE) || field.equals((Object)BulgariaAmexReportFields.DEPARTURE_DATE) || field.equals((Object)BulgariaAmexReportFields.PNR_CREATION_DATE) || field.equals((Object)BulgariaAmexReportFields.DEPARTURE_DATE_SEG) || field.equals((Object)BulgariaAmexReportFields.ARRIVAL_DATE_SEG) || field.equals((Object)BulgariaAmexReportFields.DATE_IN) || field.equals((Object)BulgariaAmexReportFields.DATE_OUT_NUMBER_OF_NIGHTS)) {
                ticketString.append(MiscUtil.toString((Object)ticket.get(field), (SimpleDateFormat)DATE_FORMAT.get())).append(SEPARATOR);
                continue;
            }
            if (field.equals((Object)BulgariaAmexReportFields.DEPARTURE_TIME) || field.equals((Object)BulgariaAmexReportFields.ARRIVAL_TIME)) {
                ticketString.append(MiscUtil.toString((Object)ticket.get(field), (SimpleDateFormat)TIME_FORMAT.get())).append(SEPARATOR);
                continue;
            }
            if (field.equals((Object)BulgariaAmexReportFields.HOTEL_ADDRESS)) {
                ticketString.append(QUOTE).append(MiscUtil.toString((Object)ticket.get(field))).append(QUOTE).append(SEPARATOR);
                continue;
            }
            ticketString.append(MiscUtil.toString((Object)ticket.get(field))).append(SEPARATOR);
        }
        return ticketString.toString();
    }
}

