/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.reports.render.prismreport;

import com.gridnine.xtrip.common.bg.reports.fields.BulgariaPrismReportSummaryFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaPrismReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportSummary;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BulgariaPrismSummaryReportRender {
    private static final String SEPARATOR = "\t";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm");
    private static final BulgariaPrismReportSummaryFields[] FIELDS = BulgariaPrismReportSummaryFields.values();

    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        if (parameters.get("key-batch-data-list") == null) {
            return null;
        }
        ReportFile reportFile = new ReportFile();
        StringWriter out = new StringWriter();
        this.writeData(parameters, out);
        reportFile.setContent(out.toString().getBytes("utf-8"));
        reportFile.setContentType(ContentType.TEXT);
        BulgariaPrismReportParameters reportParams = (BulgariaPrismReportParameters)parameters.get("key-report-params");
        Date startDate = reportParams.getPeriodBegin();
        String reportFileName = this.createReportName(startDate);
        reportFile.setTitle(reportFileName);
        reportFile.setName(reportFileName + ".txt");
        EntityContainer reportDocContainer = new EntityContainer(ReportDocument.class);
        ReportDocument reportDoc = (ReportDocument)reportDocContainer.getEntity();
        reportDoc.getFiles().add(reportFile);
        return reportDocContainer;
    }

    private String createReportName(Date startDate) {
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
        String monthName = "";
        String year = "";
        if (startDate != null) {
            year = yearFormat.format(startDate);
            monthName = monthFormat.format(startDate);
        }
        String reportFileName = "air__Summary_" + year + monthName;
        return reportFileName;
    }

    private void writeData(Map<String, Object> parameters, StringWriter out) {
        out.write(this.createHeaderString());
        out.write(LINE_SEPARATOR);
        for (BulgariaPrismReportSummary summ : (List)parameters.get("KEY_SUMMARY_DATA")) {
            out.write(this.createString(summ));
            out.write(LINE_SEPARATOR);
        }
    }

    private String createHeaderString() {
        StringBuilder builder = new StringBuilder();
        for (BulgariaPrismReportSummaryFields field : FIELDS) {
            builder.append(field.getColumnName()).append(SEPARATOR);
        }
        return builder.toString();
    }

    private String createString(BulgariaPrismReportSummary summ) {
        StringBuilder ticketString = new StringBuilder();
        for (BulgariaPrismReportSummaryFields field : FIELDS) {
            if (field.equals((Object)BulgariaPrismReportSummaryFields.BEG_DATE) || field.equals((Object)BulgariaPrismReportSummaryFields.END_DATE)) {
                ticketString.append(this.trimToMaxLength(MiscUtil.toString((Object)summ.get(field), (SimpleDateFormat)DATE_FORMAT), field)).append(SEPARATOR);
                continue;
            }
            ticketString.append(this.trimToMaxLength(MiscUtil.toString((Object)summ.get(field)), field)).append(SEPARATOR);
        }
        String result = ticketString.toString();
        return result;
    }

    private String trimToMaxLength(String str, BulgariaPrismReportSummaryFields field) {
        if (str.length() > field.getMaxLength()) {
            str = str.substring(0, field.getMaxLength());
        }
        return str;
    }
}

