/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.reports.render.prismreport;

import com.gridnine.xtrip.common.bg.reports.fields.BulgariaPrismReportFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaPrismReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportTicket;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BulgariaPrismTicketsReportRender {
    private static final String SEPARATOR = "\t";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm");
    private static final BulgariaPrismReportFields[] TICKET_FIELDS = new BulgariaPrismReportFields[]{BulgariaPrismReportFields.IATA_NO, BulgariaPrismReportFields.BRANCH, BulgariaPrismReportFields.INVOICE, BulgariaPrismReportFields.AUX_KEY, BulgariaPrismReportFields.CUSTOMER, BulgariaPrismReportFields.ISSUE_DATE, BulgariaPrismReportFields.REFUND_EXCHANGE, BulgariaPrismReportFields.TICKET_NO, BulgariaPrismReportFields.CONJ_TICKET_NO, BulgariaPrismReportFields.PASSENGER_NO, BulgariaPrismReportFields.ORIG_TICKET_NO, BulgariaPrismReportFields.TICKET_AMT, BulgariaPrismReportFields.BASE_FARE_AMT, BulgariaPrismReportFields.TAX_AMT, BulgariaPrismReportFields.IATA_COMMISION_AMT, BulgariaPrismReportFields.DISCOUNT_COMMISION_AMT, BulgariaPrismReportFields.NON_BSP_TICKET_AMT, BulgariaPrismReportFields.VAL_CARRIER, BulgariaPrismReportFields.LASTNAME, BulgariaPrismReportFields.FIRSTNAME, BulgariaPrismReportFields.CARD_CODE, BulgariaPrismReportFields.PNR_LOCATOR, BulgariaPrismReportFields.TICKET_TYPE, BulgariaPrismReportFields.TOUR_CODE, BulgariaPrismReportFields.COUNTRY_CODE, BulgariaPrismReportFields.CURRENCY_CODE};

    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        if (parameters.get("key-batch-data-list") == null) {
            return null;
        }
        ReportFile reportFile = new ReportFile();
        StringWriter out = new StringWriter();
        this.writeCSVData(parameters, out);
        reportFile.setContent(out.toString().getBytes("utf-8"));
        reportFile.setContentType(ContentType.TEXT);
        BulgariaPrismReportParameters reportParams = (BulgariaPrismReportParameters)parameters.get("key-report-params");
        Date startDate = reportParams.getPeriodBegin();
        String reportFileName = this.createReportName(startDate);
        reportFile.setTitle(reportFileName);
        reportFile.setName(reportFileName + ".txt");
        EntityContainer reportDocContainer = new EntityContainer(ReportDocument.class);
        ReportDocument reportDoc = (ReportDocument)reportDocContainer.getEntity();
        reportDoc.getFiles().add(reportFile);
        return reportDocContainer;
    }

    private String createReportName(Date startDate) {
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
        String monthName = "";
        String year = "";
        if (startDate != null) {
            year = yearFormat.format(startDate);
            monthName = monthFormat.format(startDate);
        }
        String reportFileName = "air__Tickets_" + year + monthName;
        return reportFileName;
    }

    private void writeCSVData(Map<String, Object> parameters, StringWriter out) {
        out.write(this.createHeaderString());
        out.write(LINE_SEPARATOR);
        for (ReportBatchData batch : (List)parameters.get("key-batch-data-list")) {
            for (BulgariaPrismReportTicket ticket : batch.getTickets()) {
                if (ticket.get(BulgariaPrismReportFields.SEG_NUMBER) != null) continue;
                out.write(this.createString(ticket));
                out.write(LINE_SEPARATOR);
            }
        }
    }

    private String createHeaderString() {
        StringBuilder builder = new StringBuilder();
        for (BulgariaPrismReportFields field : TICKET_FIELDS) {
            builder.append(field.getColumnName()).append(SEPARATOR);
        }
        return builder.toString();
    }

    private String createString(BulgariaPrismReportTicket ticket) {
        StringBuilder ticketString = new StringBuilder();
        for (BulgariaPrismReportFields field : TICKET_FIELDS) {
            if (field.equals((Object)BulgariaPrismReportFields.ISSUE_DATE) || field.equals((Object)BulgariaPrismReportFields.DEPART_DATE) || field.equals((Object)BulgariaPrismReportFields.ARRIVE_DATE)) {
                ticketString.append(this.trimToMaxLength(MiscUtil.toString((Object)ticket.get(field), (SimpleDateFormat)DATE_FORMAT), field)).append(SEPARATOR);
                continue;
            }
            if (field.equals((Object)BulgariaPrismReportFields.DEPART_TIME) || field.equals((Object)BulgariaPrismReportFields.ARRIVE_TIME)) {
                ticketString.append(this.trimToMaxLength(MiscUtil.toString((Object)ticket.get(field), (SimpleDateFormat)TIME_FORMAT), field)).append(SEPARATOR);
                continue;
            }
            ticketString.append(this.trimToMaxLength(MiscUtil.toString((Object)ticket.get(field)), field)).append(SEPARATOR);
        }
        String result = ticketString.toString();
        return result;
    }

    private String trimToMaxLength(String str, BulgariaPrismReportFields field) {
        if (str.length() > field.getMaxLength()) {
            str = str.substring(0, field.getMaxLength());
        }
        return str;
    }
}

