/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.rules;

import com.gridnine.xtrip.common.bus.model.BaseBusAccount;
import com.gridnine.xtrip.common.bus.rules.BusParametersActionsProvider;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public enum BusActions implements RuleAction
{
    APPLICABLE_BUS_ACCOUNTS{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection accounts = (Collection)value;
            if (accounts.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_ApplicableGDSAccounts_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)accounts, (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ApplicableGDSAccounts);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.gds.rules.ValueTypes.GDS_ACCOUNT_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BusParametersActionsProvider as = (BusParametersActionsProvider)proxy.getActionSet();
            for (EntityReference gdsAcc : (Collection)value) {
                as.addApplicableGDSAccount((EntityReference<BaseBusAccount>)gdsAcc);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"applicable-BUS-accounts\"";
        }
    }
    ,
    BUS_RECEIPT{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d(\u044b) \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438(\u0439)";
        }

        public String getRendererId() {
            return ValueTypes.BUS_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "bus_receipts";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            List<EntityReference> templates = value == null ? Collections.emptyList() : (value instanceof List ? (List<EntityReference>)value : Collections.singletonList((EntityReference)value));
            actionSet.setReceiptTemplates(templates);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    };


    public String getId() {
        return this.name();
    }
}

