/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.rules;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BusRulesHelper {
    public static Set<String> collectBusCodes(Set<String> codes, boolean includeCountry) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet stations = new HashSet();
        for (String code : codes) {
            if (TextUtil.isBlank((String)code)) continue;
            stations.addAll(DictHelper.getDictionaryItemsByCode(BusStation.class, (String)code));
        }
        if (stations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        DictionaryCache dictCache = DictionaryCache.get();
        for (Object station : stations) {
            for (Map.Entry entry : station.getCodeVariants().entrySet()) {
                result.add((String)entry.getValue());
            }
            Country country = (Country)dictCache.resolveReference(station.getCountry());
            if (!includeCountry || country == null) continue;
            result.addAll(RulesHelper.collectCountryCodes((Country)country));
        }
        HashSet parents = new HashSet();
        for (BusStation station : stations) {
            BusStation parent = (BusStation)dictCache.resolveReference(station.getParent());
            if (parent == null) continue;
            result.addAll(parent.getCodeVariants().values());
        }
        if (result.containsAll(parents)) {
            return result;
        }
        HashSet<String> diffCodes = new HashSet<String>(parents);
        diffCodes.removeAll(result);
        result.addAll(BusRulesHelper.collectBusCodes(diffCodes, false));
        return result;
    }
}

