/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.templates.jr;

import com.gridnine.xtrip.common.bus.model.BusService;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class BusItineraryReceiptRender {
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENT_CODE = "AGENT_CODE";
    private static final String KEY_SALES_POINT_ADDRESS = "SALES_POINT_ADDRESS";
    private static final String KEY_SALES_POINT_CITY = "SALES_POINT_CITY";
    private static final String KEY_SALES_POINT_LOCATION = "SALES_POINT_LOCATION";
    private static final String KEY_SALES_POINT_PHONE = "SALES_POINT_PHONE";
    private static final String KEY_ISSUE_DATE = "ISSUE_DATE";
    private static final String KEY_TRAVELLERS = "TRAVELLERS";
    private static final String KEY_TRAVELLER_NAME = "TRAVELLER_NAME";
    private static final String KEY_TRAVELLER_PASSPORT_TYPE = "TRAVELLER_PASSPORT_TYPE";
    private static final String KEY_TRAVELLER_PASSPORT_NUMBER = "TRAVELLER_PASSPORT_NUMBER";
    private static final String KEY_PRODUCT_NUMBER = "PRODUCT_NUMBER";
    private static final String KEY_PNR = "PNR";
    private static final String FIELD_DEPARTURE_CITY = "DEPARTURE_CITY";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_ARRIVE_CITY = "ARRIVE_CITY";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_ADDITIONAL_INFO = "ADDITIONAL_INFO";
    private static final String FIELD_PLACES = "PLACES";
    private static final String FIELD_BRAND = "BRAND";
    private static final String FIELD_SERVICES = "SERVICES";
    private static final String FIELD_TRAVEL_TIME = "TRAVEL_TIME";
    private static final String FIELD_CARRIER = "CARRIER";
    private static final String KEY_TARIFF_BASE_AMOUNT = "TARIFF_BASE_AMOUNT";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT = "TAXES_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENT_EQUIVALENT_AMOUNT = "PAYMENT_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT = "TOTAL_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_EQUIVALENT_VAT = "TOTAL_EQUIVALENT_VAT";
    private static final HashMap<BusService, String> BUS_SERVICES = new HashMap<BusService, String>(){
        {
            this.put(BusService.TOILET, "\u0420\u0430\u0431\u043e\u0442\u0430\u044e\u0449\u0438\u0439 \u0442\u0443\u0430\u043b\u0435\u0442");
            this.put(BusService.CONDITIONER, "\u041a\u043b\u0438\u043c\u0430\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c");
            this.put(BusService.COMFORT_SEATS, "\u0421\u0438\u0434\u0435\u043d\u0438\u044f \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0444\u043e\u0440\u0442\u043d\u043e\u0441\u0442\u0438");
            this.put(BusService.RECLINING_SEATS, "\u0421\u0438\u0434\u0435\u043d\u0438\u044f \u043e\u0442\u043a\u0438\u0434\u044b\u0432\u0430\u044e\u0442\u0441\u044f");
            this.put(BusService.WIDTH_SLIDING_SEATS, "\u0421\u0438\u0434\u0435\u043d\u0438\u044f \u0440\u0430\u0437\u0434\u0432\u0438\u0436\u043d\u044b\u0435 \u043f\u043e \u0448\u0438\u0440\u0438\u043d\u0435");
            this.put(BusService.SEAT_BELTS, "\u0420\u0435\u043c\u043d\u0438 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u043d\u0430 \u043a\u0430\u0436\u0434\u043e\u043c \u0441\u0438\u0434\u0435\u043d\u044c\u0435");
            this.put(BusService.CHILD_SEATS, "\u0414\u0435\u0442\u0441\u043a\u0438\u0435 \u0441\u0438\u0434\u0435\u043d\u0438\u044f");
            this.put(BusService.WI_FI, "Wi-fi");
            this.put(BusService.SOCKETS_220, "\u0420\u043e\u0437\u0435\u0442\u043a\u0438 220\u0432");
            this.put(BusService.USB_SOCKETS, "\u0420\u043e\u0437\u0435\u0442\u043a\u0438 USB");
            this.put(BusService.STEWARDESS, "\u0421\u0442\u044e\u0430\u0440\u0434\u0435\u0441\u0441\u0430");
            this.put(BusService.DRINKS, "\u041d\u0430\u043f\u0438\u0442\u043a\u0438, \u0432\u043e\u0434\u0430 \u0432 \u0434\u043e\u0440\u043e\u0433\u0435");
            this.put(BusService.BUS_AUDIO, "\u0410\u0443\u0434\u0438\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043e\u0431\u0449\u0430\u044f \u043d\u0430 \u0432\u0435\u0441\u044c \u0430\u0432\u0442\u043e\u0431\u0443\u0441");
            this.put(BusService.PASSENGER_AUDIO, "\u0410\u0443\u0434\u0438\u043e-\u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0438\u043d\u0434\u0438\u0432\u0438\u0434\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430");
            this.put(BusService.BUS_VIDEO, "\u0412\u0438\u0434\u0435\u043e-\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043e\u0431\u0449\u0430\u044f \u043d\u0430 \u0432\u0435\u0441\u044c \u0430\u0432\u0442\u043e\u0431\u0443\u0441");
            this.put(BusService.PASSENGER_VIDEO, "\u0412\u0438\u0434\u0435\u043e-\u043c\u043e\u043d\u0438\u0442\u043e\u0440 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430");
            this.put(BusService.PASSENGER_LIGHTING, "\u0418\u043d\u0434\u0438\u0432\u0438\u0434\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430");
            this.put(BusService.VIP, "VIP \u0441\u0430\u043b\u043e\u043d (\u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0440\u044f\u0434\u0430\u043c\u0438 \u0438 /\u0438\u043b\u0438 \u043a\u043e\u0436\u0430\u043d\u043d\u044b\u0435 \u0441\u0438\u0434\u0435\u043d\u0438\u044f \u0438 \u0442.\u0434)");
            this.put(BusService.FREE_MEALS, "\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0435 \u043f\u0438\u0442\u0430\u043d\u0438\u0435");
            this.put(BusService.PAID_MEALS, "\u041f\u0438\u0442\u0430\u043d\u0438\u0435 (\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043e\u043f\u043b\u0430\u0442\u0430)");
        }
    };

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, BusProduct product, EntityContainer<TemplateDocument> template) throws Exception {
        Locale locale;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = this.getLocale((TemplateDocument)template.getEntity())), (JRDataSource)this.getDataSource(product, locale), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Locale getLocale(TemplateDocument document) {
        String language = SystemHelper.findMetadataAsString((Collection)document.getMetadata(), (MetadataKey)MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getFileName(BusProduct product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument);
    }

    private String getReportTitle(BusProduct product, TemplateDocument templateDocument) {
        return templateDocument.getTitle() + " " + product.getSystemNumber() + (!product.getTravellers().isEmpty() ? " " + ((Traveller)product.getTravellers().get(0)).getName() : "") + " (" + new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + ")";
    }

    private Map<String, Object> getParameters(BusProduct product, Locale locale) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", locale);
        this.fillAgencyInfo(parameters, product, locale);
        this.fillAgentInfo(parameters, product);
        this.fillSalesPointData(parameters, product, locale);
        this.fillDates(parameters, product);
        this.fillTravellersData(parameters, product, locale);
        this.fillProductNumberInfo(parameters, product);
        this.fillFinanceData(parameters, product, locale);
        return parameters;
    }

    private JRDataSource getDataSource(BusProduct product, Locale locale) {
        ArrayList data = new ArrayList();
        this.fillSegmentsInfo(data, product, locale);
        return new JRMapCollectionDataSource(data);
    }

    private void fillSalesPointData(Map<String, Object> parameters, BusProduct product, Locale locale) {
        EntityReference salesPointRef = GeneralProductHelper.getSalesPoint((BaseProduct)product);
        SalesPoint salesPoint = (SalesPoint)ProfileHelper.resolveReference((EntityReference)salesPointRef);
        if (salesPoint != null) {
            Address address = ProfileHelper.filterAddresses((Collection)salesPoint.getAddresses(), (AddressType)AddressType.FACTUAL);
            StringJoiner salesPointLocation = new StringJoiner(", ");
            if (address != null) {
                parameters.put(KEY_SALES_POINT_ADDRESS, ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)true));
                DictionaryReference city = address.getCity();
                DictionaryReference country = address.getCountry();
                String cityString = city.toString(locale);
                String countryString = country.toString(locale);
                if (TextUtil.nonBlank((String)cityString)) {
                    parameters.put(KEY_SALES_POINT_CITY, cityString);
                    salesPointLocation.add(cityString);
                }
                if (TextUtil.nonBlank((String)countryString)) {
                    salesPointLocation.add(countryString);
                }
            }
            parameters.put(KEY_SALES_POINT_LOCATION, salesPointLocation.toString());
            Communication communication = ProfileHelper.filterCommunications((Collection)salesPoint.getCommunications(), (CommunicationType)CommunicationType.WORK_PHONE);
            if (communication == null) {
                communication = ProfileHelper.filterCommunications((Collection)salesPoint.getCommunications(), (CommunicationType)CommunicationType.MOBILE);
            }
            CommunicationFormat format = new CommunicationFormat("+C (T) N #I");
            parameters.put(KEY_SALES_POINT_PHONE, communication != null ? format.format(communication) : null);
        }
    }

    private void fillDates(Map<String, Object> parameters, BusProduct product) {
        Date issueDate = product.getIssueDate();
        parameters.put(KEY_ISSUE_DATE, issueDate);
    }

    private void fillTravellersData(Map<String, Object> parameters, BusProduct product, Locale locale) {
        List travellers = product.getTravellers();
        if (CollectionUtil.isNotEmpty((Collection)travellers)) {
            Traveller travellerData = (Traveller)travellers.get(0);
            parameters.put(KEY_TRAVELLER_NAME, travellerData.getName());
            Passport passport = travellerData.getPassport();
            if (passport != null) {
                parameters.put(KEY_TRAVELLER_PASSPORT_NUMBER, passport.getNumber());
                Optional.ofNullable(passport.getType()).ifPresent(passportType -> parameters.put(KEY_TRAVELLER_PASSPORT_TYPE, passportType.toString(locale)));
            }
        }
    }

    private void fillProductNumberInfo(Map<String, Object> parameters, BusProduct product) {
        String systemNumber = product.getSystemNumber();
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
        parameters.put(KEY_PRODUCT_NUMBER, systemNumber);
        parameters.put(KEY_PNR, recordLocator);
    }

    private void fillAgentInfo(Map<String, Object> parameters, BusProduct product) {
        Person person = (Person)ProfileHelper.resolveReference((EntityReference)product.getAgent());
        if (person != null) {
            parameters.put(KEY_AGENT_CODE, person.getCode());
        }
    }

    private void fillAgencyInfo(Map<String, Object> parameters, BusProduct product, Locale locale) {
        EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)product);
        if (agency != null) {
            Organization organization = (Organization)ProfileHelper.resolveReference((EntityReference)agency);
            parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName((Organization)organization, (Locale)locale, (boolean)false));
        }
    }

    private void fillSegmentsInfo(List<Map<String, ?>> parameters, BusProduct product, Locale locale) {
        product.getSegments().forEach(segment -> {
            HashMap<String, Object> segmentData = new HashMap<String, Object>();
            DictionaryReference departure = segment.getDeparture();
            if (departure != null) {
                segmentData.put(FIELD_DEPARTURE_CITY, departure.toString(locale));
            }
            segmentData.put(FIELD_DEPARTURE_DATE, segment.getDepartureDate());
            DictionaryReference arrival = segment.getArrival();
            if (arrival != null) {
                segmentData.put(FIELD_ARRIVE_CITY, arrival.toString(locale));
            }
            segmentData.put(FIELD_ARRIVE_DATE, segment.getArrivalDate());
            segmentData.put(FIELD_ADDITIONAL_INFO, segment.getAddInfo());
            segmentData.put(FIELD_BRAND, segment.getBrand());
            segmentData.put(FIELD_CARRIER, segment.getCarrier());
            String places = String.join((CharSequence)", ", segment.getPlaces());
            segmentData.put(FIELD_PLACES, TextUtil.isBlank((String)places) ? null : places);
            segmentData.put(FIELD_TRAVEL_TIME, Optional.ofNullable(segment.getWayTimeMinutes()).map(wayTimeMinutes -> String.format("%d \u043c\u0438\u043d", wayTimeMinutes)).orElse(null));
            StringJoiner busServices = new StringJoiner(", ");
            segment.getServices().stream().map(BUS_SERVICES::get).forEach(busServices::add);
            segmentData.put(FIELD_SERVICES, TextUtil.isBlank((String)busServices.toString()) ? null : busServices.toString());
            parameters.add(segmentData);
        });
    }

    private void fillFinanceData(Map<String, Object> parameters, BusProduct product, Locale locale) {
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        ContractRelationServiceData serviceData = clientContractRelation.getServiceData();
        DictionaryReference currency = clientContractRelation.getGeneralData().getCurrency();
        String equivalentCurrency = currency != null ? currency.getCode() : "";
        BigDecimal baseFare = serviceData.getDetalization().getFare();
        BigDecimal totalPrice = serviceData.getTotalPrice();
        ContractRelationVatDetalization vat = serviceData.getDetalization().getVat();
        BigDecimal totalVat = vat == null ? BigDecimal.ZERO : vat.getComponents().stream().map(VatComponent::getSum).reduce(BigDecimal.ZERO, BigDecimal::add);
        StringJoiner taxesStringJoiner = new StringJoiner(" ");
        serviceData.getDetalization().getTaxes().stream().map(tax -> String.format("%s%s%s", tax.getCode(), String.format("%.2f", tax.getAmount()), equivalentCurrency)).forEach(taxesStringJoiner::add);
        String taxesString = taxesStringJoiner.toString();
        String payments = this.getPayments(product, equivalentCurrency, locale);
        parameters.put(KEY_TARIFF_BASE_AMOUNT, String.format("%.2f%s", baseFare, equivalentCurrency));
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT, taxesString);
        parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT, String.format("%.2f%s", totalPrice, equivalentCurrency));
        parameters.put(KEY_TOTAL_EQUIVALENT_VAT, String.format("%.2f%s", totalVat, equivalentCurrency));
        parameters.put(KEY_PAYMENT_EQUIVALENT_AMOUNT, payments);
    }

    private String getPayments(BusProduct product, String currency, Locale locale) {
        List fops = GeneralProductHelper.getFops((BaseProduct)product, (ContractType)ContractType.CLIENT);
        StringJoiner joiner = new StringJoiner(" / ");
        fops.forEach(productFop -> {
            BigDecimal equivalentAmount = productFop.getEquivalentAmount();
            PaymentType type = productFop.getType();
            joiner.add(String.format("%s - %.2f%s", type.toString(locale), equivalentAmount, currency));
        });
        return joiner.toString();
    }
}

