/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class AsyncTaskAssignment
extends BaseAsset {
    private static final long serialVersionUID = -2155544460475717586L;
    private TaskState state;
    private String creator;
    private byte[] parameters;
    private byte[] result;
    private byte progress = (byte)-1;
    private String message;
    private final List<Message> log = new ArrayList<Message>();
    private byte[] error;
    private Date enqueued;
    private Date started;
    private Date stopped;
    private String tag;
    private String nodeId;
    private String taskClassName;
    private boolean interruptRequested;
    private boolean cleanupRequested;

    public AsyncTaskAssignment() {
    }

    public AsyncTaskAssignment(String uid) {
        super(uid);
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState value) {
        this.state = value;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String value) {
        this.creator = value;
    }

    public byte[] getParameters() {
        return this.parameters;
    }

    public void setParameters(byte[] value) {
        this.parameters = value;
    }

    public byte[] getResult() {
        return this.result;
    }

    public void setResult(byte[] value) {
        this.result = value;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    public byte[] getError() {
        return this.error;
    }

    public void setError(byte[] value) {
        this.error = value;
    }

    public Date getEnqueued() {
        return this.enqueued;
    }

    public void setEnqueued(Date value) {
        this.enqueued = value;
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date value) {
        this.started = value;
    }

    public Date getStopped() {
        return this.stopped;
    }

    public void setStopped(Date value) {
        this.stopped = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String value) {
        this.tag = value;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String value) {
        this.nodeId = value;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public void setTaskClassName(String value) {
        this.taskClassName = value;
    }

    public byte getProgress() {
        return this.progress;
    }

    public void setProgress(byte value) {
        this.progress = value;
    }

    public List<Message> getLog() {
        return this.log;
    }

    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    public void setInterruptRequested(boolean value) {
        this.interruptRequested = value;
    }

    public boolean isCleanupRequested() {
        return this.cleanupRequested;
    }

    public void setCleanupRequested(boolean value) {
        this.cleanupRequested = value;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.state = (TaskState)XHelper.readEnum((Element)elm, (String)"state", TaskState.class);
        this.creator = XHelper.readString((Element)elm, (String)"creator");
        this.parameters = XHelper.readBytes((Element)elm, (String)"parameters");
        this.result = XHelper.readBytes((Element)elm, (String)"result");
        this.progress = XHelper.readByte((Element)elm, (String)"progress", (byte)-1);
        this.message = XHelper.readString((Element)elm, (String)"message");
        this.log.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"log/item")) {
            Message item = new Message();
            item.fromXML(itemElm);
            this.log.add(item);
        }
        this.error = XHelper.readBytes((Element)elm, (String)"error");
        this.enqueued = XHelper.readDate((Element)elm, (String)"enqueued");
        this.started = XHelper.readDate((Element)elm, (String)"started");
        this.stopped = XHelper.readDate((Element)elm, (String)"stopped");
        this.tag = XHelper.readString((Element)elm, (String)"tag");
        this.nodeId = XHelper.readString((Element)elm, (String)"nodeId");
        this.taskClassName = XHelper.readString((Element)elm, (String)"taskClassName");
        this.interruptRequested = XHelper.readBoolean((Element)elm, (String)"interruptRequested", (boolean)false);
        this.cleanupRequested = XHelper.readBoolean((Element)elm, (String)"cleanupRequested", (boolean)false);
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeEnum((Element)elm, (String)"state", (Enum)this.state);
        XHelper.writeString((Element)elm, (String)"creator", (String)this.creator);
        XHelper.writeBytes((Element)elm, (String)"parameters", (byte[])this.parameters);
        XHelper.writeBytes((Element)elm, (String)"result", (byte[])this.result);
        XHelper.writeByte((Element)elm, (String)"progress", (byte)this.progress);
        XHelper.writeString((Element)elm, (String)"message", (String)this.message);
        for (Message item : this.log) {
            item.toXML(XmlUtil.addElement((Element)elm, (String)"log/item"));
        }
        XHelper.writeBytes((Element)elm, (String)"error", (byte[])this.error);
        XHelper.writeDate((Element)elm, (String)"enqueued", (Date)this.enqueued);
        XHelper.writeDate((Element)elm, (String)"started", (Date)this.started);
        XHelper.writeDate((Element)elm, (String)"stopped", (Date)this.stopped);
        XHelper.writeString((Element)elm, (String)"tag", (String)this.tag);
        XHelper.writeString((Element)elm, (String)"nodeId", (String)this.nodeId);
        XHelper.writeString((Element)elm, (String)"taskClassName", (String)this.taskClassName);
        XHelper.writeBoolean((Element)elm, (String)"interruptRequested", (boolean)this.interruptRequested);
        XHelper.writeBoolean((Element)elm, (String)"cleanupRequested", (boolean)this.cleanupRequested);
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("state".equals(tagName)) {
            this.state = (TaskState)XSHelper.readEnum((XMLStreamReader)reader, TaskState.class);
            return true;
        }
        if ("creator".equals(tagName)) {
            this.creator = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("parameters".equals(tagName)) {
            this.parameters = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("result".equals(tagName)) {
            this.result = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("progress".equals(tagName)) {
            this.progress = XSHelper.readByte((XMLStreamReader)reader, (byte)-1);
            return true;
        }
        if ("message".equals(tagName)) {
            this.message = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("log".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    Message item = new Message();
                    item.fromXML(reader);
                    this.log.add(item);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("error".equals(tagName)) {
            this.error = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("enqueued".equals(tagName)) {
            this.enqueued = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("started".equals(tagName)) {
            this.started = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("stopped".equals(tagName)) {
            this.stopped = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("tag".equals(tagName)) {
            this.tag = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("nodeId".equals(tagName)) {
            this.nodeId = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("taskClassName".equals(tagName)) {
            this.taskClassName = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("interruptRequested".equals(tagName)) {
            this.interruptRequested = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
            return true;
        }
        if ("cleanupRequested".equals(tagName)) {
            this.cleanupRequested = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
            return true;
        }
        return false;
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"state", (Enum)this.state);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"creator", (String)this.creator);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"parameters", (byte[])this.parameters);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"result", (byte[])this.result);
        XSHelper.writeByte((XMLStreamWriter)writer, (String)"progress", (byte)this.progress);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"message", (String)this.message);
        if (!this.log.isEmpty()) {
            writer.writeStartElement("log");
            for (Message item : this.log) {
                writer.writeStartElement("item");
                item.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"error", (byte[])this.error);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"enqueued", (Date)this.enqueued);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"started", (Date)this.started);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"stopped", (Date)this.stopped);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"tag", (String)this.tag);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"nodeId", (String)this.nodeId);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"taskClassName", (String)this.taskClassName);
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)"interruptRequested", (boolean)this.interruptRequested);
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)"cleanupRequested", (boolean)this.cleanupRequested);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        AsyncTaskAssignment source = (AsyncTaskAssignment)sourceAsset;
        this.state = source.state;
        this.creator = source.creator;
        this.parameters = (byte[])XCloneHelper.cloneArray((Object)source.parameters, (boolean)newUids, uids);
        this.result = (byte[])XCloneHelper.cloneArray((Object)source.result, (boolean)newUids, uids);
        this.progress = source.progress;
        this.message = source.message;
        this.log.clear();
        this.log.addAll(XCloneHelper.cloneCollection(source.log, (boolean)newUids, uids));
        this.error = (byte[])XCloneHelper.cloneArray((Object)source.error, (boolean)newUids, uids);
        this.enqueued = XCloneHelper.cloneDate((Date)source.enqueued);
        this.started = XCloneHelper.cloneDate((Date)source.started);
        this.stopped = XCloneHelper.cloneDate((Date)source.stopped);
        this.tag = source.tag;
        this.nodeId = source.nodeId;
        this.taskClassName = source.taskClassName;
        this.interruptRequested = source.interruptRequested;
        this.cleanupRequested = source.cleanupRequested;
    }

    public static enum Property {
        state,
        creator,
        progress,
        enqueued,
        started,
        stopped,
        tag,
        nodeId,
        taskClassName,
        failed,
        interruptRequested,
        cleanupRequested;

    }

    public static enum TaskState {
        ENQUEUED{

            @Override
            public boolean isFinished() {
                return false;
            }
        }
        ,
        RUNNING{

            @Override
            public boolean isFinished() {
                return false;
            }
        }
        ,
        COMPLETED{

            @Override
            public boolean isFinished() {
                return true;
            }
        }
        ,
        INTERRUPTED{

            @Override
            public boolean isFinished() {
                return true;
            }
        };


        public abstract boolean isFinished();
    }
}

