/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.assets;

import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class FxWorkspace
extends BaseAsset {
    private static final long serialVersionUID = -3621448850414742891L;
    private String owner;
    private String name;
    private final List<FxWorkspaceItem> items = new ArrayList<FxWorkspaceItem>();

    public FxWorkspace() {
    }

    public FxWorkspace(String uid) {
        super(uid);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String value) {
        this.owner = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public List<FxWorkspaceItem> getItems() {
        return this.items;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.owner = XHelper.readString((Element)elm, (String)"owner");
        this.name = XHelper.readString((Element)elm, (String)"name");
        this.items.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"items/item")) {
            FxWorkspaceItem item = new FxWorkspaceItem();
            item.fromXML(itemElm);
            this.items.add(item);
        }
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString((Element)elm, (String)"owner", (String)this.owner);
        XHelper.writeString((Element)elm, (String)"name", (String)this.name, (boolean)true);
        for (FxWorkspaceItem item : this.items) {
            item.toXML(XmlUtil.addElement((Element)elm, (String)"items/item"));
        }
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("owner".equals(tagName)) {
            this.owner = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("name".equals(tagName)) {
            this.name = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("items".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    FxWorkspaceItem item = new FxWorkspaceItem();
                    item.fromXML(reader);
                    this.items.add(item);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        return false;
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"owner", (String)this.owner);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"name", (String)this.name, (boolean)true);
        if (!this.items.isEmpty()) {
            writer.writeStartElement("items");
            for (FxWorkspaceItem item : this.items) {
                writer.writeStartElement("item");
                item.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        FxWorkspace source = (FxWorkspace)sourceAsset;
        this.owner = source.owner;
        this.name = source.name;
        this.items.clear();
        this.items.addAll(XCloneHelper.cloneCollection(source.items, (boolean)newUids, uids));
    }

    public static enum Property {
        owner,
        name;

    }
}

