/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.assets;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FxWorkspaceItem
extends BaseIdentity
implements XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = 7183378570937083082L;
    private String name;
    private String toolId;
    private byte[] parameters;
    private final List<FxWorkspaceItem> subItems = new ArrayList<FxWorkspaceItem>();

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getToolId() {
        return this.toolId;
    }

    public void setToolId(String value) {
        this.toolId = value;
    }

    public byte[] getParameters() {
        return this.parameters;
    }

    public void setParameters(byte[] value) {
        this.parameters = value;
    }

    public List<FxWorkspaceItem> getSubItems() {
        return this.subItems;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeString((Element)elm, (String)"uid", (String)this.getUid());
        XHelper.writeString((Element)elm, (String)"name", (String)this.name);
        XHelper.writeString((Element)elm, (String)"toolId", (String)this.toolId);
        XHelper.writeBytes((Element)elm, (String)"parameters", (byte[])this.parameters);
        for (FxWorkspaceItem item : this.subItems) {
            item.toXML(XmlUtil.addElement((Element)elm, (String)"subItems/item"));
        }
    }

    public void fromXML(Element elm) throws Exception {
        if (XHelper.readString((Element)elm, (String)"uid") != null) {
            this.setUid(XHelper.readString((Element)elm, (String)"uid"));
        }
        this.name = XHelper.readString((Element)elm, (String)"name");
        this.toolId = XHelper.readString((Element)elm, (String)"toolId");
        this.parameters = XHelper.readBytes((Element)elm, (String)"parameters");
        this.subItems.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"subItems/item")) {
            FxWorkspaceItem item = new FxWorkspaceItem();
            item.fromXML(itemElm);
            this.subItems.add(item);
        }
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tagName = reader.getName().getLocalPart();
            if ("uid".equals(tagName)) {
                if (XSHelper.readString((XMLStreamReader)reader) == null) continue;
                this.setUid(XSHelper.readString((XMLStreamReader)reader));
                continue;
            }
            if ("name".equals(tagName)) {
                this.name = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("toolId".equals(tagName)) {
                this.toolId = XSHelper.readString((XMLStreamReader)reader);
                continue;
            }
            if ("parameters".equals(tagName)) {
                this.parameters = XSHelper.readBytes((XMLStreamReader)reader);
                continue;
            }
            if ("subItems".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        FxWorkspaceItem item = new FxWorkspaceItem();
                        item.fromXML(reader);
                        this.subItems.add(item);
                        continue;
                    }
                    XSHelper.skipElement((XMLStreamReader)reader);
                }
                continue;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("fromXML(): skipping " + tagName);
            XSHelper.skipElement((XMLStreamReader)reader);
        }
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"uid", (String)this.getUid());
        XSHelper.writeString((XMLStreamWriter)writer, (String)"name", (String)this.name);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"toolId", (String)this.toolId);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"parameters", (byte[])this.parameters);
        if (!this.subItems.isEmpty()) {
            writer.writeStartElement("subItems");
            for (FxWorkspaceItem item : this.subItems) {
                writer.writeStartElement("item");
                item.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        FxWorkspaceItem result = new FxWorkspaceItem();
        if (newUids) {
            uids.put(this.getUid(), result.getUid());
        } else {
            result.setUid(this.getUid());
        }
        result.name = this.name;
        result.toolId = this.toolId;
        result.parameters = (byte[])XCloneHelper.cloneArray((Object)this.parameters, (boolean)newUids, uids);
        result.subItems.addAll(XCloneHelper.cloneCollection(this.subItems, (boolean)newUids, uids));
        return result;
    }
}

