/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.restriction.resource;

import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.meta.ui.UiWidgetBigTableBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetDataView;
import com.gridnine.xtrip.common.meta.ui.UiWidgetGroupsBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetNavigatorBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetPopupBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetTableBox;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.resource.RestrictionUiResource;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

final class ModelRestrictionUiResources {
    static void configure(RestrictionResourcesRegistry registry) {
        HashSet<String> processedContainers = new HashSet<String>();
        ArrayDeque<String> parents = new ArrayDeque<String>();
        parents.addLast(StandardRestrictionGroupResources.GROUP_UI.getId());
        for (UiTilesSpace space : UiMetaRegistry.get().getSpaces().values()) {
            UiAclResource spaceAcl = space.getAcl();
            if (spaceAcl != null) {
                registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(spaceAcl, (String)parents.getLast()));
                parents.addLast(spaceAcl.getId());
                if (space.getOverview() != null && ModelRestrictionUiResources.hasAcl(registry, space.getOverview())) {
                    SpaceOverviceUiResourceImpl res = new SpaceOverviceUiResourceImpl((String)parents.getLast());
                    registry.addResource((RestrictionResource)res);
                    parents.addLast(res.getId());
                    ModelRestrictionUiResources.process(registry, parents, processedContainers, space.getOverview());
                    parents.removeLast();
                }
            }
            for (UiTile tile : space.getTiles()) {
                UiAclResource tileAcl = tile.getAcl();
                if (tileAcl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(tileAcl, (String)parents.getLast()));
                    parents.addLast(tileAcl.getId());
                }
                ModelRestrictionUiResources.process(registry, parents, processedContainers, tile.getCompactPayload());
                ModelRestrictionUiResources.process(registry, parents, processedContainers, tile.getFullPayload());
                if (tileAcl == null) continue;
                parents.removeLast();
            }
            if (spaceAcl == null) continue;
            parents.removeLast();
        }
        for (BaseUiContainer uiCtr : UiMetaRegistry.get().getContainers().values()) {
            if (uiCtr.getAcl() == null) continue;
            ModelRestrictionUiResources.processContainer(registry, parents, processedContainers, uiCtr);
        }
    }

    private static boolean hasAcl(RestrictionResourcesRegistry registry, UiElement uiElm) {
        block10: {
            BaseUiContainer uiCtr;
            block11: {
                block9: {
                    if (uiElm == null || !(uiElm instanceof UiContainerReference)) {
                        return false;
                    }
                    uiCtr = (BaseUiContainer)UiMetaRegistry.get().getContainers().get(((UiContainerReference)uiElm).getId());
                    if (uiCtr.getAcl() != null) {
                        return true;
                    }
                    if (uiCtr instanceof UiSimpleContainer) {
                        return ModelRestrictionUiResources.hasAcl(registry, ((UiSimpleContainer)uiCtr).getPayload());
                    }
                    if (!(uiCtr instanceof UiCardsContainer)) break block9;
                    for (UiCardsContainer.Card card : ((UiCardsContainer)uiCtr).getCards()) {
                        if (card.getAcl() != null) {
                            return true;
                        }
                        if (!ModelRestrictionUiResources.hasAcl(registry, card.getPayload())) continue;
                        return true;
                    }
                    break block10;
                }
                if (!(uiCtr instanceof UiCellsContainer)) break block11;
                for (UiCellsContainer.BaseCell cell : ((UiCellsContainer)uiCtr).getCells()) {
                    if (cell.getAcl() != null) {
                        return true;
                    }
                    if (!(cell instanceof UiCellsContainer.ComplexCell) || !ModelRestrictionUiResources.hasAcl(registry, ((UiCellsContainer.ComplexCell)cell).getPayload())) continue;
                    return true;
                }
                break block10;
            }
            if (!(uiCtr instanceof UiGridContainer)) break block10;
            for (UiGridContainer.Cell cell : ((UiGridContainer)uiCtr).getCells()) {
                if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
                if (cell.getAcl() != null) {
                    return true;
                }
                if (!ModelRestrictionUiResources.hasAcl(registry, cell.getPayload())) continue;
                return true;
            }
        }
        return false;
    }

    private static void process(RestrictionResourcesRegistry registry, Deque<String> parents, Set<String> processedContainers, UiElement uiElm) {
        if (uiElm == null) {
            return;
        }
        if (uiElm instanceof UiContainerReference) {
            ModelRestrictionUiResources.processContainer(registry, parents, processedContainers, (BaseUiContainer)UiMetaRegistry.get().getContainers().get(((UiContainerReference)uiElm).getId()));
        } else if (uiElm instanceof UiWidgetBigTableBox) {
            for (UiWidgetBigTableBox.BaseColumn column : ((UiWidgetBigTableBox)uiElm).getColumns()) {
                UiAclResource acl = column.getAcl();
                if (acl == null) continue;
                registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
            }
        } else if (uiElm instanceof UiWidgetDataView) {
            for (UiWidgetDataView.Column column : ((UiWidgetDataView)uiElm).getColumns()) {
                UiAclResource acl = column.getAcl();
                if (acl == null) continue;
                registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
            }
        } else if (uiElm instanceof UiWidgetGroupsBox) {
            ModelRestrictionUiResources.process(registry, parents, processedContainers, (UiElement)((UiWidgetGroupsBox)uiElm).getPayload());
        } else if (uiElm instanceof UiWidgetNavigatorBox) {
            for (UiWidgetNavigatorBox.Variant variant : ((UiWidgetNavigatorBox)uiElm).getVariants()) {
                UiAclResource acl = variant.getAcl();
                if (acl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
                    parents.addLast(acl.getId());
                }
                ModelRestrictionUiResources.process(registry, parents, processedContainers, (UiElement)variant.getPayload());
                if (acl == null) continue;
                parents.removeLast();
            }
        } else if (uiElm instanceof UiWidgetTableBox) {
            for (UiWidgetTableBox.BaseColumn column : ((UiWidgetTableBox)uiElm).getColumns()) {
                UiAclResource acl = column.getAcl();
                if (acl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
                    parents.addLast(acl.getId());
                }
                if (column instanceof UiWidgetTableBox.SuperColumn) {
                    ModelRestrictionUiResources.process(registry, parents, processedContainers, (UiElement)((UiWidgetTableBox.SuperColumn)column).getPayload());
                }
                if (acl == null) continue;
                parents.removeLast();
            }
        } else if (uiElm instanceof UiWidgetPopupBox) {
            ModelRestrictionUiResources.process(registry, parents, processedContainers, (UiElement)((UiWidgetPopupBox)uiElm).getPayload());
        }
    }

    private static void processContainer(RestrictionResourcesRegistry registry, Deque<String> parents, Set<String> processedContainers, BaseUiContainer uiCtr) {
        if (uiCtr == null || processedContainers.contains(uiCtr.getId())) {
            return;
        }
        processedContainers.add(uiCtr.getId());
        UiAclResource ctrAcl = uiCtr.getAcl();
        if (ctrAcl != null) {
            registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(ctrAcl, parents.getLast()));
            parents.addLast(ctrAcl.getId());
        }
        if (uiCtr instanceof UiSimpleContainer) {
            ModelRestrictionUiResources.process(registry, parents, processedContainers, ((UiSimpleContainer)uiCtr).getPayload());
        } else if (uiCtr instanceof UiCardsContainer) {
            for (UiCardsContainer.Card card : ((UiCardsContainer)uiCtr).getCards()) {
                UiAclResource acl = card.getAcl();
                if (acl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
                    parents.addLast(acl.getId());
                }
                ModelRestrictionUiResources.process(registry, parents, processedContainers, card.getPayload());
                if (acl == null) continue;
                parents.removeLast();
            }
        } else if (uiCtr instanceof UiCellsContainer) {
            for (UiCellsContainer.BaseCell cell : ((UiCellsContainer)uiCtr).getCells()) {
                UiAclResource acl = cell.getAcl();
                if (acl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
                    parents.addLast(acl.getId());
                }
                if (cell instanceof UiCellsContainer.ComplexCell) {
                    ModelRestrictionUiResources.process(registry, parents, processedContainers, ((UiCellsContainer.ComplexCell)cell).getPayload());
                }
                if (acl == null) continue;
                parents.removeLast();
            }
        } else if (uiCtr instanceof UiGridContainer) {
            for (UiGridContainer.Cell cell : ((UiGridContainer)uiCtr).getCells()) {
                if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
                UiAclResource acl = cell.getAcl();
                if (acl != null) {
                    registry.addResource((RestrictionResource)new RestrictionUiResourceImpl(acl, parents.getLast()));
                    parents.addLast(acl.getId());
                }
                ModelRestrictionUiResources.process(registry, parents, processedContainers, cell.getPayload());
                if (acl == null) continue;
                parents.removeLast();
            }
        }
        if (ctrAcl != null) {
            parents.removeLast();
        }
    }

    private ModelRestrictionUiResources() {
    }

    private static class SpaceOverviceUiResourceImpl
    implements RestrictionUiResource {
        private static final Set<String> OPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(StandardRestrictionResourceOperations.ALL.getId(), StandardRestrictionResourceOperations.VIEW.getId(), StandardRestrictionResourceOperations.EDIT.getId())));
        private final String parentId;

        SpaceOverviceUiResourceImpl(String parent) {
            this.parentId = parent;
        }

        public String getParentId() {
            return this.parentId;
        }

        public Set<String> getOperationIds() {
            return OPS;
        }

        public String getId() {
            return this.parentId + ".overview";
        }

        public String getName() {
            return "Overview";
        }

        public String getDescription() {
            return null;
        }
    }

    private static class RestrictionUiResourceImpl
    implements RestrictionUiResource {
        private static final Set<String> OPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(StandardRestrictionResourceOperations.ALL.getId(), StandardRestrictionResourceOperations.VIEW.getId(), StandardRestrictionResourceOperations.EDIT.getId())));
        private final UiAclResource res;
        private final String parentId;

        RestrictionUiResourceImpl(UiAclResource aclRes, String parent) {
            this.res = aclRes;
            this.parentId = parent;
        }

        public String getParentId() {
            return this.parentId;
        }

        public Set<String> getOperationIds() {
            return OPS;
        }

        public String getId() {
            return this.res.getId();
        }

        public String getName() {
            return this.res.toString();
        }

        public String getDescription() {
            return null;
        }
    }
}

